<?php

if (!class_exists('WPSE_WC_Attributes_Sheet')) {

	class WPSE_WC_Attributes_Sheet extends WPSE_Sheet_Factory {

		function __construct() {
			add_filter('vg_sheet_editor/provider/custom_table/table_schema', array($this, 'modify_table_schema'));
			parent::__construct(array(
				'fs_object' => wpsett_fs(),
				'post_type' => array($this, 'get_taxonomies_and_labels'),
				'register_default_taxonomy_columns' => false,
				'bootstrap_class' => 'WPSE_WC_Attributes_Spreadsheet_Bootstrap',
				'columns' => array($this, 'get_columns'),
			));
			add_filter('vg_sheet_editor/provider/default_provider_key', array($this, 'set_default_provider'), 10, 2);
			add_filter('vg_sheet_editor/acf/fields', array($this, 'deactivate_acf_fields'), 10, 2);
			add_action('vg_sheet_editor/terms/before_merge', array($this, 'transfer_variations_after_attribute_merge'), 10, 3);
			add_filter('vg_sheet_editor/advanced_filters/all_fields_groups', array($this, 'add_fields_to_advanced_filters'), 10, 2);
			add_filter('vg_sheet_editor/provider/custom_table/get_rows_sql', array($this, 'filter_rows_query_post_data'), 10, 3);
		}

		function filter_rows_query_post_data($sql, $args, $settings) {
			$post_type = $settings['table_name'];
			if (strpos($post_type, 'woocommerce_attribute_taxonomies') === false) {
				return $sql;
			}

			if (empty($args['wpse_original_filters']) || empty($args['wpse_original_filters']['meta_query'])) {
				return $sql;
			}
			$table_data_filters = wp_list_filter($args['wpse_original_filters']['meta_query'], array(
				'source' => 'attribute_data'
			));
			if (empty($table_data_filters)) {
				return $sql;
			}


			// Replace the ID field key with the real primary key for the search
			$primary_column_key = VGSE()->helpers->get_current_provider()->get_post_data_table_id_key($post_type);
			foreach ($table_data_filters as $index => $table_data_filter) {
				if ($table_data_filter['key'] === 'ID') {
					$table_data_filters[$index]['key'] = $primary_column_key;
				}
			}

			$raw_where = WP_Sheet_Editor_Advanced_Filters::get_instance()->_build_sql_wheres_for_data_table($table_data_filters, 't');
			if (empty($raw_where)) {
				return $sql;
			}

			$where = implode(' AND ', $raw_where);
			if (strpos($sql, ' WHERE ') === false) {
				$where = ' WHERE ' . $where;
			} else {
				$where = ' AND ' . $where;
			}
			$sql = str_replace(' ORDER ', $where . ' ORDER ', $sql);
			return $sql;
		}

		function add_fields_to_advanced_filters($all_fields, $post_type) {
			global $wpdb;
			if (strpos($post_type, 'woocommerce_attribute_taxonomies') === false) {
				return $all_fields;
			}

			$data_fields = wp_list_pluck($wpdb->get_results("SHOW COLUMNS FROM {$wpdb->prefix}woocommerce_attribute_taxonomies;"), 'Field');
			$all_fields['attribute_data'] = $data_fields;

			return $all_fields;
		}

		function transfer_variations_after_attribute_merge($successfully_merged_ids, $term_id_to_keep, $taxonomy) {
			global $wpdb;
			if (empty($successfully_merged_ids) || !taxonomy_exists($taxonomy) || strpos($taxonomy, 'pa_') === false) {
				return;
			}

			$final_term = get_term_by('term_id', $term_id_to_keep, $taxonomy);
			foreach ($successfully_merged_ids as $deleted_term_id) {
				$deleted_term = get_term_by('term_id', $deleted_term_id, $taxonomy);
				if (empty($deleted_term)) {
					continue;
				}
				$sql = $wpdb->prepare("UPDATE {$wpdb->postmeta} SET meta_value = %s WHERE meta_key = %s AND meta_value = %s", $final_term->slug, 'attribute_' . $taxonomy, $deleted_term->slug);
				$wpdb->query($sql);
			}
		}

		function modify_table_schema($schema) {
			if (strpos($schema['table_name'], 'woocommerce_attribute_taxonomies') !== false) {
				$schema['columns']['attribute_name']['type'] = 'slug';
			}
			return $schema;
		}

		function after_full_core_init() {
			if (!$this->is_woocommerce_activated()) {
				return;
			}
			parent::after_full_core_init();
			add_action('vg_sheet_editor/save_rows/after_saving_post', array($this, 'row_updated_on_spreadsheet'), 10, 6);
			add_action('vg_sheet_editor/formulas/execute_formula/after_execution_on_field', array($this, 'row_updated_with_formula'), 10, 8);
			add_action('vg_sheet_editor/formulas/execute_formula/after_sql_execution', array($this, 'after_sql_formula_execution'), 10, 3);
			add_filter('vg_sheet_editor/terms/welcome_sheets_all', array($this, 'show_sheet_in_welcome_page'));
			add_filter('vg_sheet_editor/terms/welcome_sheets', array($this, 'show_sheet_in_welcome_page_as_enabled'));
		}

		function is_woocommerce_activated() {
			return function_exists('WC');
		}

		function show_sheet_in_welcome_page_as_enabled($sheets) {
			global $wpdb;
			$sheets[] = $wpdb->prefix . 'woocommerce_attribute_taxonomies';
			return $sheets;
		}

		function show_sheet_in_welcome_page($sheets) {
			global $wpdb;
			$sheets['post_types'][] = $wpdb->prefix . 'woocommerce_attribute_taxonomies';
			$sheets['labels'][] = __('WooCommerce Attributes', vgse_taxonomy_terms()->textname);
			return $sheets;
		}

		function after_sql_formula_execution($column, $formula, $post_type) {
			if (strpos($post_type, 'woocommerce_attribute_taxonomies') !== false) {
				self::clear_caches();
			}
		}

		static function clear_caches() {
			wp_schedule_single_event(time(), 'woocommerce_flush_rewrite_rules');
			delete_transient('wc_attribute_taxonomies');
			if (class_exists('WC_Cache_Helper')) {
				WC_Cache_Helper::invalidate_cache_group('woocommerce-attributes');
			}
		}

		function row_updated_with_formula($post_id, $initial_data, $modified_data, $column, $formula, $post_type, $cell_args, $spreadsheet_columns) {
			if (strpos($post_type, 'woocommerce_attribute_taxonomies') !== false) {
				self::clear_caches();
			}
		}

		function row_updated_on_spreadsheet($product_id, $item, $data, $post_type, $spreadsheet_columns, $settings) {
			if (strpos($post_type, 'woocommerce_attribute_taxonomies') !== false) {
				self::clear_caches();
			}
		}

		function deactivate_acf_fields($fields, $post_type) {
			if (strpos($post_type, 'woocommerce_attribute_taxonomies') !== false) {
				$fields = array();
			}
			return $fields;
		}

		function set_default_provider($provider_class_key, $provider) {
			if (strpos($provider, 'woocommerce_attribute_taxonomies') !== false) {
				$provider_class_key = 'wc_attributes';
			}
			return $provider_class_key;
		}

		function get_columns() {
			
		}

		function get_taxonomies_and_labels() {
			global $wpdb;
			$out = array(
				'post_types' => array($wpdb->prefix . 'woocommerce_attribute_taxonomies'),
				'labels' => array(__('WooCommerce Attributes', vgse_taxonomy_terms()->textname)),
			);

			return $out;
		}

	}

	$GLOBALS['wpse_wc_attributes_sheet'] = new WPSE_WC_Attributes_Sheet();
}