/**!
 * Sortable 1.10.2
 * @author	RubaXa   <trash@rubaxa.org>
 * @author	owenm    <owen23355@gmail.com>
 * @license MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define(factory):(global=global||self).Sortable=factory()}(this,(function(){"use strict";function userAgent(pattern){if("undefined"!=typeof window&&window.navigator)return!!navigator.userAgent.match(pattern)}const IE11OrLess=userAgent(/(?:Trident.*rv[ :]?11\.|msie|iemobile|Windows Phone)/i),Edge=userAgent(/Edge/i),FireFox=userAgent(/firefox/i),Safari=userAgent(/safari/i)&&!userAgent(/chrome/i)&&!userAgent(/android/i),IOS=userAgent(/iP(ad|od|hone)/i),ChromeForAndroid=userAgent(/chrome/i)&&userAgent(/android/i);var captureMode={capture:!1,passive:!1};function on(el,event,fn){el.addEventListener(event,fn,!IE11OrLess&&captureMode)}function off(el,event,fn){el.removeEventListener(event,fn,!IE11OrLess&&captureMode)}function matches(el,selector){if(selector){if(">"===selector[0]&&(selector=selector.substring(1)),el)try{if(el.matches)return el.matches(selector);if(el.msMatchesSelector)return el.msMatchesSelector(selector);if(el.webkitMatchesSelector)return el.webkitMatchesSelector(selector)}catch(_){return!1}return!1}}function getParentOrHost(el){return el.host&&el!==document&&el.host.nodeType?el.host:el.parentNode}function closest(el,selector,ctx,includeCTX){if(el){ctx=ctx||document;do{if(null!=selector&&(">"===selector[0]?el.parentNode===ctx&&matches(el,selector):matches(el,selector))||includeCTX&&el===ctx)return el;if(el===ctx)break}while(el=getParentOrHost(el))}return null}var _throttleTimeout,R_SPACE=/\s+/g;function toggleClass(el,name,state){if(el&&name)if(el.classList)el.classList[state?"add":"remove"](name);else{var className=(" "+el.className+" ").replace(R_SPACE," ").replace(" "+name+" "," ");el.className=(className+(state?" "+name:"")).replace(R_SPACE," ")}}function css(el,prop,val){var style=el&&el.style;if(style){if(void 0===val)return document.defaultView&&document.defaultView.getComputedStyle?val=document.defaultView.getComputedStyle(el,""):el.currentStyle&&(val=el.currentStyle),void 0===prop?val:val[prop];prop in style||-1!==prop.indexOf("webkit")||(prop="-webkit-"+prop),style[prop]=val+("string"==typeof val?"":"px")}}function matrix(el,selfOnly){var appliedTransforms="";if("string"==typeof el)appliedTransforms=el;else do{var transform=css(el,"transform");transform&&"none"!==transform&&(appliedTransforms=transform+" "+appliedTransforms)}while(!selfOnly&&(el=el.parentNode));var matrixFn=window.DOMMatrix||window.WebKitCSSMatrix||window.CSSMatrix||window.MSCSSMatrix;return matrixFn&&new matrixFn(appliedTransforms)}function find(ctx,tagName,iterator){if(ctx){var list=ctx.getElementsByTagName(tagName),i=0,n=list.length;if(iterator)for(;i<n;i++)iterator(list[i],i);return list}return[]}function getWindowScrollingElement(){var scrollingElement=document.scrollingElement;return scrollingElement||document.documentElement}function getRect(el,relativeToContainingBlock,relativeToNonStaticParent,undoScale,container){if(el.getBoundingClientRect||el===window){var elRect,top,left,bottom,right,height,width;if(el!==window&&el!==getWindowScrollingElement()?(top=(elRect=el.getBoundingClientRect()).top,left=elRect.left,bottom=elRect.bottom,right=elRect.right,height=elRect.height,width=elRect.width):(top=0,left=0,bottom=window.innerHeight,right=window.innerWidth,height=window.innerHeight,width=window.innerWidth),(relativeToContainingBlock||relativeToNonStaticParent)&&el!==window&&(container=container||el.parentNode,!IE11OrLess))do{if(container&&container.getBoundingClientRect&&("none"!==css(container,"transform")||relativeToNonStaticParent&&"static"!==css(container,"position"))){var containerRect=container.getBoundingClientRect();top-=containerRect.top+parseInt(css(container,"border-top-width")),left-=containerRect.left+parseInt(css(container,"border-left-width")),bottom=top+elRect.height,right=left+elRect.width;break}}while(container=container.parentNode);if(undoScale&&el!==window){var elMatrix=matrix(container||el),scaleX=elMatrix&&elMatrix.a,scaleY=elMatrix&&elMatrix.d;elMatrix&&(bottom=(top/=scaleY)+(height/=scaleY),right=(left/=scaleX)+(width/=scaleX))}return{top:top,left:left,bottom:bottom,right:right,width:width,height:height}}}function isScrolledPast(el,elSide,parentSide){for(var parent=getParentAutoScrollElement(el,!0),elSideVal=getRect(el)[elSide];parent;){var parentSideVal=getRect(parent)[parentSide];if(!("top"===parentSide||"left"===parentSide?elSideVal>=parentSideVal:elSideVal<=parentSideVal))return parent;if(parent===getWindowScrollingElement())break;parent=getParentAutoScrollElement(parent,!1)}return!1}function getChild(el,childNum,options){for(var currentChild=0,i=0,children=el.children;i<children.length;){if("none"!==children[i].style.display&&children[i]!==Sortable.ghost&&children[i]!==Sortable.dragged&&closest(children[i],options.draggable,el,!1)){if(currentChild===childNum)return children[i];currentChild++}i++}return null}function lastChild(el,selector){for(var last=el.lastElementChild;last&&(last===Sortable.ghost||"none"===css(last,"display")||selector&&!matches(last,selector));)last=last.previousElementSibling;return last||null}function index(el,selector){var index=0;if(!el||!el.parentNode)return-1;for(;el=el.previousElementSibling;)"TEMPLATE"===el.nodeName.toUpperCase()||el===Sortable.clone||selector&&!matches(el,selector)||index++;return index}function getRelativeScrollOffset(el){var offsetLeft=0,offsetTop=0,winScroller=getWindowScrollingElement();if(el)do{var elMatrix=matrix(el),scaleX=elMatrix.a,scaleY=elMatrix.d;offsetLeft+=el.scrollLeft*scaleX,offsetTop+=el.scrollTop*scaleY}while(el!==winScroller&&(el=el.parentNode));return[offsetLeft,offsetTop]}function getParentAutoScrollElement(el,includeSelf){if(!el||!el.getBoundingClientRect)return getWindowScrollingElement();var elem=el,gotSelf=!1;do{if(elem.clientWidth<elem.scrollWidth||elem.clientHeight<elem.scrollHeight){var elemCSS=css(elem);if(elem.clientWidth<elem.scrollWidth&&("auto"==elemCSS.overflowX||"scroll"==elemCSS.overflowX)||elem.clientHeight<elem.scrollHeight&&("auto"==elemCSS.overflowY||"scroll"==elemCSS.overflowY)){if(!elem.getBoundingClientRect||elem===document.body)return getWindowScrollingElement();if(gotSelf||includeSelf)return elem;gotSelf=!0}}}while(elem=elem.parentNode);return getWindowScrollingElement()}function isRectEqual(rect1,rect2){return Math.round(rect1.top)===Math.round(rect2.top)&&Math.round(rect1.left)===Math.round(rect2.left)&&Math.round(rect1.height)===Math.round(rect2.height)&&Math.round(rect1.width)===Math.round(rect2.width)}function throttle(callback,ms){return function(){if(!_throttleTimeout){var args=arguments,_this=this;1===args.length?callback.call(_this,args[0]):callback.apply(_this,args),_throttleTimeout=setTimeout((function(){_throttleTimeout=void 0}),ms)}}}function scrollBy(el,x,y){el.scrollLeft+=x,el.scrollTop+=y}function clone(el){var Polymer=window.Polymer,$=window.jQuery||window.Zepto;return Polymer&&Polymer.dom?Polymer.dom(el).cloneNode(!0):$?$(el).clone(!0)[0]:el.cloneNode(!0)}function setRect(el,rect){css(el,"position","absolute"),css(el,"top",rect.top),css(el,"left",rect.left),css(el,"width",rect.width),css(el,"height",rect.height)}function unsetRect(el){css(el,"position",""),css(el,"top",""),css(el,"left",""),css(el,"width",""),css(el,"height","")}var expando="Sortable"+(new Date).getTime();function AnimationStateManager(){let animationCallbackId,animationStates=[];return{captureAnimationState(){if(animationStates=[],!this.options.animation)return;[].slice.call(this.el.children).forEach((child=>{if("none"===css(child,"display")||child===Sortable.ghost)return;animationStates.push({target:child,rect:getRect(child)});let fromRect={...animationStates[animationStates.length-1].rect};if(child.thisAnimationDuration){let childMatrix=matrix(child,!0);childMatrix&&(fromRect.top-=childMatrix.f,fromRect.left-=childMatrix.e)}child.fromRect=fromRect}))},addAnimationState(state){animationStates.push(state)},removeAnimationState(target){animationStates.splice(function(arr,obj){for(var i in arr)if(arr.hasOwnProperty(i))for(var key in obj)if(obj.hasOwnProperty(key)&&obj[key]===arr[i][key])return Number(i);return-1}(animationStates,{target:target}),1)},animateAll(callback){if(!this.options.animation)return clearTimeout(animationCallbackId),void("function"==typeof callback&&callback());let animating=!1,animationTime=0;animationStates.forEach((state=>{let time=0,target=state.target,fromRect=target.fromRect,toRect=getRect(target),prevFromRect=target.prevFromRect,prevToRect=target.prevToRect,animatingRect=state.rect,targetMatrix=matrix(target,!0);targetMatrix&&(toRect.top-=targetMatrix.f,toRect.left-=targetMatrix.e),target.toRect=toRect,target.thisAnimationDuration&&isRectEqual(prevFromRect,toRect)&&!isRectEqual(fromRect,toRect)&&(animatingRect.top-toRect.top)/(animatingRect.left-toRect.left)==(fromRect.top-toRect.top)/(fromRect.left-toRect.left)&&(time=function(animatingRect,fromRect,toRect,options){return Math.sqrt(Math.pow(fromRect.top-animatingRect.top,2)+Math.pow(fromRect.left-animatingRect.left,2))/Math.sqrt(Math.pow(fromRect.top-toRect.top,2)+Math.pow(fromRect.left-toRect.left,2))*options.animation}(animatingRect,prevFromRect,prevToRect,this.options)),isRectEqual(toRect,fromRect)||(target.prevFromRect=fromRect,target.prevToRect=toRect,time||(time=this.options.animation),this.animate(target,animatingRect,toRect,time)),time&&(animating=!0,animationTime=Math.max(animationTime,time),clearTimeout(target.animationResetTimer),target.animationResetTimer=setTimeout((function(){target.animationTime=0,target.prevFromRect=null,target.fromRect=null,target.prevToRect=null,target.thisAnimationDuration=null}),time),target.thisAnimationDuration=time)})),clearTimeout(animationCallbackId),animating?animationCallbackId=setTimeout((function(){"function"==typeof callback&&callback()}),animationTime):"function"==typeof callback&&callback(),animationStates=[]},animate(target,currentRect,toRect,duration){if(duration){css(target,"transition",""),css(target,"transform","");let elMatrix=matrix(this.el),scaleX=elMatrix&&elMatrix.a,scaleY=elMatrix&&elMatrix.d,translateX=(currentRect.left-toRect.left)/(scaleX||1),translateY=(currentRect.top-toRect.top)/(scaleY||1);target.animatingX=!!translateX,target.animatingY=!!translateY,css(target,"transform","translate3d("+translateX+"px,"+translateY+"px,0)"),function(target){target.offsetWidth}(target),css(target,"transition","transform "+duration+"ms"+(this.options.easing?" "+this.options.easing:"")),css(target,"transform","translate3d(0,0,0)"),"number"==typeof target.animated&&clearTimeout(target.animated),target.animated=setTimeout((function(){css(target,"transition",""),css(target,"transform",""),target.animated=!1,target.animatingX=!1,target.animatingY=!1}),duration)}}}}let plugins=[];const defaults={initializeByDefault:!0};var PluginManager={mount(plugin){for(let option in defaults)defaults.hasOwnProperty(option)&&!(option in plugin)&&(plugin[option]=defaults[option]);plugins.push(plugin)},pluginEvent(eventName,sortable,evt){this.eventCanceled=!1,evt.cancel=()=>{this.eventCanceled=!0};const eventNameGlobal=eventName+"Global";plugins.forEach((plugin=>{sortable[plugin.pluginName]&&(sortable[plugin.pluginName][eventNameGlobal]&&sortable[plugin.pluginName][eventNameGlobal]({sortable:sortable,...evt}),sortable.options[plugin.pluginName]&&sortable[plugin.pluginName][eventName]&&sortable[plugin.pluginName][eventName]({sortable:sortable,...evt}))}))},initializePlugins(sortable,el,defaults,options){plugins.forEach((plugin=>{const pluginName=plugin.pluginName;if(!sortable.options[pluginName]&&!plugin.initializeByDefault)return;let initialized=new plugin(sortable,el,sortable.options);initialized.sortable=sortable,initialized.options=sortable.options,sortable[pluginName]=initialized,Object.assign(defaults,initialized.defaults)}));for(let option in sortable.options){if(!sortable.options.hasOwnProperty(option))continue;let modified=this.modifyOption(sortable,option,sortable.options[option]);void 0!==modified&&(sortable.options[option]=modified)}},getEventProperties(name,sortable){let eventProperties={};return plugins.forEach((plugin=>{"function"==typeof plugin.eventProperties&&Object.assign(eventProperties,plugin.eventProperties.call(sortable[plugin.pluginName],name))})),eventProperties},modifyOption(sortable,name,value){let modifiedValue;return plugins.forEach((plugin=>{sortable[plugin.pluginName]&&plugin.optionListeners&&"function"==typeof plugin.optionListeners[name]&&(modifiedValue=plugin.optionListeners[name].call(sortable[plugin.pluginName],value))})),modifiedValue}};function dispatchEvent({sortable:sortable,rootEl:rootEl,name:name,targetEl:targetEl,cloneEl:cloneEl,toEl:toEl,fromEl:fromEl,oldIndex:oldIndex,newIndex:newIndex,oldDraggableIndex:oldDraggableIndex,newDraggableIndex:newDraggableIndex,originalEvent:originalEvent,putSortable:putSortable,extraEventProperties:extraEventProperties}){if(!(sortable=sortable||rootEl&&rootEl[expando]))return;let evt,options=sortable.options,onName="on"+name.charAt(0).toUpperCase()+name.substr(1);!window.CustomEvent||IE11OrLess||Edge?(evt=document.createEvent("Event"),evt.initEvent(name,!0,!0)):evt=new CustomEvent(name,{bubbles:!0,cancelable:!0}),evt.to=toEl||rootEl,evt.from=fromEl||rootEl,evt.item=targetEl||rootEl,evt.clone=cloneEl,evt.oldIndex=oldIndex,evt.newIndex=newIndex,evt.oldDraggableIndex=oldDraggableIndex,evt.newDraggableIndex=newDraggableIndex,evt.originalEvent=originalEvent,evt.pullMode=putSortable?putSortable.lastPutMode:void 0;let allEventProperties={...extraEventProperties,...PluginManager.getEventProperties(name,sortable)};for(let option in allEventProperties)evt[option]=allEventProperties[option];rootEl&&rootEl.dispatchEvent(evt),options[onName]&&options[onName].call(sortable,evt)}
/**!
	 * Sortable
	 * @author	RubaXa   <trash@rubaxa.org>
	 * @author	owenm    <owen23355@gmail.com>
	 * @license MIT
	 */let pluginEvent=function(eventName,sortable,{evt:originalEvent,...data}={}){PluginManager.pluginEvent.bind(Sortable)(eventName,sortable,{dragEl:dragEl,parentEl:parentEl,ghostEl:ghostEl,rootEl:rootEl,nextEl:nextEl,lastDownEl:lastDownEl,cloneEl:cloneEl,cloneHidden:cloneHidden,dragStarted:moved,putSortable:putSortable,activeSortable:Sortable.active,originalEvent:originalEvent,oldIndex:oldIndex,oldDraggableIndex:oldDraggableIndex,newIndex:newIndex,newDraggableIndex:newDraggableIndex,hideGhostForTarget:_hideGhostForTarget,unhideGhostForTarget:_unhideGhostForTarget,cloneNowHidden(){cloneHidden=!0},cloneNowShown(){cloneHidden=!1},dispatchSortableEvent(name){_dispatchEvent({sortable:sortable,name:name,originalEvent:originalEvent})},...data})};function _dispatchEvent(info){dispatchEvent({putSortable:putSortable,cloneEl:cloneEl,targetEl:dragEl,rootEl:rootEl,oldIndex:oldIndex,oldDraggableIndex:oldDraggableIndex,newIndex:newIndex,newDraggableIndex:newDraggableIndex,...info})}let dragEl,parentEl,ghostEl,rootEl,nextEl,lastDownEl,cloneEl,cloneHidden,oldIndex,newIndex,oldDraggableIndex,newDraggableIndex,activeGroup,putSortable,tapEvt,touchEvt,lastDx,lastDy,tapDistanceLeft,tapDistanceTop,moved,lastTarget,lastDirection,targetMoveDistance,ghostRelativeParent,awaitingDragStarted=!1,ignoreNextClick=!1,sortables=[],pastFirstInvertThresh=!1,isCircumstantialInvert=!1,ghostRelativeParentInitialScroll=[],_silent=!1,savedInputChecked=[];const documentExists="undefined"!=typeof document,PositionGhostAbsolutely=IOS,CSSFloatProperty=Edge||IE11OrLess?"cssFloat":"float",supportDraggable=documentExists&&!ChromeForAndroid&&!IOS&&"draggable"in document.createElement("div"),supportCssPointerEvents=function(){if(!documentExists)return;if(IE11OrLess)return!1;let el=document.createElement("x");return el.style.cssText="pointer-events:auto","auto"===el.style.pointerEvents}(),_detectDirection=function(el,options){let elCSS=css(el),elWidth=parseInt(elCSS.width)-parseInt(elCSS.paddingLeft)-parseInt(elCSS.paddingRight)-parseInt(elCSS.borderLeftWidth)-parseInt(elCSS.borderRightWidth),child1=getChild(el,0,options),child2=getChild(el,1,options),firstChildCSS=child1&&css(child1),secondChildCSS=child2&&css(child2),firstChildWidth=firstChildCSS&&parseInt(firstChildCSS.marginLeft)+parseInt(firstChildCSS.marginRight)+getRect(child1).width,secondChildWidth=secondChildCSS&&parseInt(secondChildCSS.marginLeft)+parseInt(secondChildCSS.marginRight)+getRect(child2).width;if("flex"===elCSS.display)return"column"===elCSS.flexDirection||"column-reverse"===elCSS.flexDirection?"vertical":"horizontal";if("grid"===elCSS.display)return elCSS.gridTemplateColumns.split(" ").length<=1?"vertical":"horizontal";if(child1&&firstChildCSS.float&&"none"!==firstChildCSS.float){let touchingSideChild2="left"===firstChildCSS.float?"left":"right";return!child2||"both"!==secondChildCSS.clear&&secondChildCSS.clear!==touchingSideChild2?"horizontal":"vertical"}return child1&&("block"===firstChildCSS.display||"flex"===firstChildCSS.display||"table"===firstChildCSS.display||"grid"===firstChildCSS.display||firstChildWidth>=elWidth&&"none"===elCSS[CSSFloatProperty]||child2&&"none"===elCSS[CSSFloatProperty]&&firstChildWidth+secondChildWidth>elWidth)?"vertical":"horizontal"},_prepareGroup=function(options){function toFn(value,pull){return function(to,from,dragEl,evt){let sameGroup=to.options.group.name&&from.options.group.name&&to.options.group.name===from.options.group.name;if(null==value&&(pull||sameGroup))return!0;if(null==value||!1===value)return!1;if(pull&&"clone"===value)return value;if("function"==typeof value)return toFn(value(to,from,dragEl,evt),pull)(to,from,dragEl,evt);{let otherGroup=(pull?to:from).options.group.name;return!0===value||"string"==typeof value&&value===otherGroup||value.join&&value.indexOf(otherGroup)>-1}}}let group={},originalGroup=options.group;originalGroup&&"object"==typeof originalGroup||(originalGroup={name:originalGroup}),group.name=originalGroup.name,group.checkPull=toFn(originalGroup.pull,!0),group.checkPut=toFn(originalGroup.put),group.revertClone=originalGroup.revertClone,options.group=group},_hideGhostForTarget=function(){!supportCssPointerEvents&&ghostEl&&css(ghostEl,"display","none")},_unhideGhostForTarget=function(){!supportCssPointerEvents&&ghostEl&&css(ghostEl,"display","")};documentExists&&document.addEventListener("click",(function(evt){if(ignoreNextClick)return evt.preventDefault(),evt.stopPropagation&&evt.stopPropagation(),evt.stopImmediatePropagation&&evt.stopImmediatePropagation(),ignoreNextClick=!1,!1}),!0);let nearestEmptyInsertDetectEvent=function(evt){if(dragEl){let nearest=function(x,y){let ret;return sortables.some((sortable=>{if(lastChild(sortable))return;let rect=getRect(sortable),threshold=sortable[expando].options.emptyInsertThreshold,insideHorizontally=x>=rect.left-threshold&&x<=rect.right+threshold,insideVertically=y>=rect.top-threshold&&y<=rect.bottom+threshold;return threshold&&insideHorizontally&&insideVertically?ret=sortable:void 0})),ret}((evt=evt.touches?evt.touches[0]:evt).clientX,evt.clientY);if(nearest){let event={};for(let i in evt)evt.hasOwnProperty(i)&&(event[i]=evt[i]);event.target=event.rootEl=nearest,event.preventDefault=void 0,event.stopPropagation=void 0,nearest[expando]._onDragOver(event)}}},_checkOutsideTargetEl=function(evt){dragEl&&dragEl.parentNode[expando]._isOutsideThisEl(evt.target)};function Sortable(el,options){if(!el||!el.nodeType||1!==el.nodeType)throw`Sortable: \`el\` must be an HTMLElement, not ${{}.toString.call(el)}`;this.el=el,this.options=options=Object.assign({},options),el[expando]=this;let defaults={group:null,sort:!0,disabled:!1,store:null,handle:null,draggable:/^[uo]l$/i.test(el.nodeName)?">li":">*",swapThreshold:1,invertSwap:!1,invertedSwapThreshold:null,removeCloneOnHide:!0,direction:function(){return _detectDirection(el,this.options)},ghostClass:"sortable-ghost",chosenClass:"sortable-chosen",dragClass:"sortable-drag",ignore:"a, img",filter:null,preventOnFilter:!0,animation:0,easing:null,setData:function(dataTransfer,dragEl){dataTransfer.setData("Text",dragEl.textContent)},dropBubble:!1,dragoverBubble:!1,dataIdAttr:"data-id",delay:0,delayOnTouchOnly:!1,touchStartThreshold:(Number.parseInt?Number:window).parseInt(window.devicePixelRatio,10)||1,forceFallback:!1,fallbackClass:"sortable-fallback",fallbackOnBody:!1,fallbackTolerance:0,fallbackOffset:{x:0,y:0},supportPointer:!1!==Sortable.supportPointer&&"PointerEvent"in window,emptyInsertThreshold:5};PluginManager.initializePlugins(this,el,defaults);for(let name in defaults)!(name in options)&&(options[name]=defaults[name]);_prepareGroup(options);for(let fn in this)"_"===fn.charAt(0)&&"function"==typeof this[fn]&&(this[fn]=this[fn].bind(this));this.nativeDraggable=!options.forceFallback&&supportDraggable,this.nativeDraggable&&(this.options.touchStartThreshold=1),options.supportPointer?on(el,"pointerdown",this._onTapStart):(on(el,"mousedown",this._onTapStart),on(el,"touchstart",this._onTapStart)),this.nativeDraggable&&(on(el,"dragover",this),on(el,"dragenter",this)),sortables.push(this.el),options.store&&options.store.get&&this.sort(options.store.get(this)||[]),Object.assign(this,AnimationStateManager())}function onMove(fromEl,toEl,dragEl,dragRect,targetEl,targetRect,originalEvent,willInsertAfter){let evt,retVal,sortable=fromEl[expando],onMoveFn=sortable.options.onMove;return!window.CustomEvent||IE11OrLess||Edge?(evt=document.createEvent("Event"),evt.initEvent("move",!0,!0)):evt=new CustomEvent("move",{bubbles:!0,cancelable:!0}),evt.to=toEl,evt.from=fromEl,evt.dragged=dragEl,evt.draggedRect=dragRect,evt.related=targetEl||toEl,evt.relatedRect=targetRect||getRect(toEl),evt.willInsertAfter=willInsertAfter,evt.originalEvent=originalEvent,fromEl.dispatchEvent(evt),onMoveFn&&(retVal=onMoveFn.call(sortable,evt,originalEvent)),retVal}function _disableDraggable(el){el.draggable=!1}function _unsilent(){_silent=!1}function _generateId(el){let str=el.tagName+el.className+el.src+el.href+el.textContent,i=str.length,sum=0;for(;i--;)sum+=str.charCodeAt(i);return sum.toString(36)}function _nextTick(fn){return setTimeout(fn,0)}function _cancelNextTick(id){return clearTimeout(id)}Sortable.prototype={constructor:Sortable,_isOutsideThisEl:function(target){this.el.contains(target)||target===this.el||(lastTarget=null)},_getDirection:function(evt,target){return"function"==typeof this.options.direction?this.options.direction.call(this,evt,target,dragEl):this.options.direction},_onTapStart:function(evt){if(!evt.cancelable)return;let _this=this,el=this.el,options=this.options,preventOnFilter=options.preventOnFilter,type=evt.type,touch=evt.touches&&evt.touches[0]||evt.pointerType&&"touch"===evt.pointerType&&evt,target=(touch||evt).target,originalTarget=evt.target.shadowRoot&&(evt.path&&evt.path[0]||evt.composedPath&&evt.composedPath()[0])||target,filter=options.filter;if(function(root){savedInputChecked.length=0;let inputs=root.getElementsByTagName("input"),idx=inputs.length;for(;idx--;){let el=inputs[idx];el.checked&&savedInputChecked.push(el)}}(el),!dragEl&&!(/mousedown|pointerdown/.test(type)&&0!==evt.button||options.disabled||originalTarget.isContentEditable||(target=closest(target,options.draggable,el,!1),target&&target.animated||lastDownEl===target))){if(oldIndex=index(target),oldDraggableIndex=index(target,options.draggable),"function"==typeof filter){if(filter.call(this,evt,target,this))return _dispatchEvent({sortable:_this,rootEl:originalTarget,name:"filter",targetEl:target,toEl:el,fromEl:el}),pluginEvent("filter",_this,{evt:evt}),void(preventOnFilter&&evt.cancelable&&evt.preventDefault())}else if(filter&&(filter=filter.split(",").some((function(criteria){if(criteria=closest(originalTarget,criteria.trim(),el,!1))return _dispatchEvent({sortable:_this,rootEl:criteria,name:"filter",targetEl:target,fromEl:el,toEl:el}),pluginEvent("filter",_this,{evt:evt}),!0})),filter))return void(preventOnFilter&&evt.cancelable&&evt.preventDefault());options.handle&&!closest(originalTarget,options.handle,el,!1)||this._prepareDragStart(evt,touch,target)}},_prepareDragStart:function(evt,touch,target){let dragStartFn,_this=this,el=_this.el,options=_this.options,ownerDocument=el.ownerDocument;if(target&&!dragEl&&target.parentNode===el){let dragRect=getRect(target);if(rootEl=el,dragEl=target,parentEl=dragEl.parentNode,nextEl=dragEl.nextSibling,lastDownEl=target,activeGroup=options.group,Sortable.dragged=dragEl,tapEvt={target:dragEl,clientX:(touch||evt).clientX,clientY:(touch||evt).clientY},tapDistanceLeft=tapEvt.clientX-dragRect.left,tapDistanceTop=tapEvt.clientY-dragRect.top,this._lastX=(touch||evt).clientX,this._lastY=(touch||evt).clientY,dragEl.style["will-change"]="all",dragStartFn=function(){pluginEvent("delayEnded",_this,{evt:evt}),Sortable.eventCanceled?_this._onDrop():(_this._disableDelayedDragEvents(),!FireFox&&_this.nativeDraggable&&(dragEl.draggable=!0),_this._triggerDragStart(evt,touch),_dispatchEvent({sortable:_this,name:"choose",originalEvent:evt}),toggleClass(dragEl,options.chosenClass,!0))},options.ignore.split(",").forEach((function(criteria){find(dragEl,criteria.trim(),_disableDraggable)})),on(ownerDocument,"dragover",nearestEmptyInsertDetectEvent),on(ownerDocument,"mousemove",nearestEmptyInsertDetectEvent),on(ownerDocument,"touchmove",nearestEmptyInsertDetectEvent),on(ownerDocument,"mouseup",_this._onDrop),on(ownerDocument,"touchend",_this._onDrop),on(ownerDocument,"touchcancel",_this._onDrop),FireFox&&this.nativeDraggable&&(this.options.touchStartThreshold=4,dragEl.draggable=!0),pluginEvent("delayStart",this,{evt:evt}),!options.delay||options.delayOnTouchOnly&&!touch||this.nativeDraggable&&(Edge||IE11OrLess))dragStartFn();else{if(Sortable.eventCanceled)return void this._onDrop();on(ownerDocument,"mouseup",_this._disableDelayedDrag),on(ownerDocument,"touchend",_this._disableDelayedDrag),on(ownerDocument,"touchcancel",_this._disableDelayedDrag),on(ownerDocument,"mousemove",_this._delayedDragTouchMoveHandler),on(ownerDocument,"touchmove",_this._delayedDragTouchMoveHandler),options.supportPointer&&on(ownerDocument,"pointermove",_this._delayedDragTouchMoveHandler),_this._dragStartTimer=setTimeout(dragStartFn,options.delay)}}},_delayedDragTouchMoveHandler:function(e){let touch=e.touches?e.touches[0]:e;Math.max(Math.abs(touch.clientX-this._lastX),Math.abs(touch.clientY-this._lastY))>=Math.floor(this.options.touchStartThreshold/(this.nativeDraggable&&window.devicePixelRatio||1))&&this._disableDelayedDrag()},_disableDelayedDrag:function(){dragEl&&_disableDraggable(dragEl),clearTimeout(this._dragStartTimer),this._disableDelayedDragEvents()},_disableDelayedDragEvents:function(){let ownerDocument=this.el.ownerDocument;off(ownerDocument,"mouseup",this._disableDelayedDrag),off(ownerDocument,"touchend",this._disableDelayedDrag),off(ownerDocument,"touchcancel",this._disableDelayedDrag),off(ownerDocument,"mousemove",this._delayedDragTouchMoveHandler),off(ownerDocument,"touchmove",this._delayedDragTouchMoveHandler),off(ownerDocument,"pointermove",this._delayedDragTouchMoveHandler)},_triggerDragStart:function(evt,touch){touch=touch||"touch"==evt.pointerType&&evt,!this.nativeDraggable||touch?this.options.supportPointer?on(document,"pointermove",this._onTouchMove):on(document,touch?"touchmove":"mousemove",this._onTouchMove):(on(dragEl,"dragend",this),on(rootEl,"dragstart",this._onDragStart));try{document.selection?_nextTick((function(){document.selection.empty()})):window.getSelection().removeAllRanges()}catch(err){}},_dragStarted:function(fallback,evt){if(awaitingDragStarted=!1,rootEl&&dragEl){pluginEvent("dragStarted",this,{evt:evt}),this.nativeDraggable&&on(document,"dragover",_checkOutsideTargetEl);let options=this.options;!fallback&&toggleClass(dragEl,options.dragClass,!1),toggleClass(dragEl,options.ghostClass,!0),Sortable.active=this,fallback&&this._appendGhost(),_dispatchEvent({sortable:this,name:"start",originalEvent:evt})}else this._nulling()},_emulateDragOver:function(){if(touchEvt){this._lastX=touchEvt.clientX,this._lastY=touchEvt.clientY,_hideGhostForTarget();let target=document.elementFromPoint(touchEvt.clientX,touchEvt.clientY),parent=target;for(;target&&target.shadowRoot&&(target=target.shadowRoot.elementFromPoint(touchEvt.clientX,touchEvt.clientY),target!==parent);)parent=target;if(dragEl.parentNode[expando]._isOutsideThisEl(target),parent)do{if(parent[expando]){let inserted;if(inserted=parent[expando]._onDragOver({clientX:touchEvt.clientX,clientY:touchEvt.clientY,target:target,rootEl:parent}),inserted&&!this.options.dragoverBubble)break}target=parent}while(parent=parent.parentNode);_unhideGhostForTarget()}},_onTouchMove:function(evt){if(tapEvt){let options=this.options,fallbackTolerance=options.fallbackTolerance,fallbackOffset=options.fallbackOffset,touch=evt.touches?evt.touches[0]:evt,ghostMatrix=ghostEl&&matrix(ghostEl,!0),scaleX=ghostEl&&ghostMatrix&&ghostMatrix.a,scaleY=ghostEl&&ghostMatrix&&ghostMatrix.d,relativeScrollOffset=PositionGhostAbsolutely&&ghostRelativeParent&&getRelativeScrollOffset(ghostRelativeParent),dx=(touch.clientX-tapEvt.clientX+fallbackOffset.x)/(scaleX||1)+(relativeScrollOffset?relativeScrollOffset[0]-ghostRelativeParentInitialScroll[0]:0)/(scaleX||1),dy=(touch.clientY-tapEvt.clientY+fallbackOffset.y)/(scaleY||1)+(relativeScrollOffset?relativeScrollOffset[1]-ghostRelativeParentInitialScroll[1]:0)/(scaleY||1);if(!Sortable.active&&!awaitingDragStarted){if(fallbackTolerance&&Math.max(Math.abs(touch.clientX-this._lastX),Math.abs(touch.clientY-this._lastY))<fallbackTolerance)return;this._onDragStart(evt,!0)}if(ghostEl){ghostMatrix?(ghostMatrix.e+=dx-(lastDx||0),ghostMatrix.f+=dy-(lastDy||0)):ghostMatrix={a:1,b:0,c:0,d:1,e:dx,f:dy};let cssMatrix=`matrix(${ghostMatrix.a},${ghostMatrix.b},${ghostMatrix.c},${ghostMatrix.d},${ghostMatrix.e},${ghostMatrix.f})`;css(ghostEl,"webkitTransform",cssMatrix),css(ghostEl,"mozTransform",cssMatrix),css(ghostEl,"msTransform",cssMatrix),css(ghostEl,"transform",cssMatrix),lastDx=dx,lastDy=dy,touchEvt=touch}evt.cancelable&&evt.preventDefault()}},_appendGhost:function(){if(!ghostEl){let container=this.options.fallbackOnBody?document.body:rootEl,rect=getRect(dragEl,!0,PositionGhostAbsolutely,!0,container),options=this.options;if(PositionGhostAbsolutely){for(ghostRelativeParent=container;"static"===css(ghostRelativeParent,"position")&&"none"===css(ghostRelativeParent,"transform")&&ghostRelativeParent!==document;)ghostRelativeParent=ghostRelativeParent.parentNode;ghostRelativeParent!==document.body&&ghostRelativeParent!==document.documentElement?(ghostRelativeParent===document&&(ghostRelativeParent=getWindowScrollingElement()),rect.top+=ghostRelativeParent.scrollTop,rect.left+=ghostRelativeParent.scrollLeft):ghostRelativeParent=getWindowScrollingElement(),ghostRelativeParentInitialScroll=getRelativeScrollOffset(ghostRelativeParent)}ghostEl=dragEl.cloneNode(!0),toggleClass(ghostEl,options.ghostClass,!1),toggleClass(ghostEl,options.fallbackClass,!0),toggleClass(ghostEl,options.dragClass,!0),css(ghostEl,"transition",""),css(ghostEl,"transform",""),css(ghostEl,"box-sizing","border-box"),css(ghostEl,"margin",0),css(ghostEl,"top",rect.top),css(ghostEl,"left",rect.left),css(ghostEl,"width",rect.width),css(ghostEl,"height",rect.height),css(ghostEl,"opacity","0.8"),css(ghostEl,"position",PositionGhostAbsolutely?"absolute":"fixed"),css(ghostEl,"zIndex","100000"),css(ghostEl,"pointerEvents","none"),Sortable.ghost=ghostEl,container.appendChild(ghostEl),css(ghostEl,"transform-origin",tapDistanceLeft/parseInt(ghostEl.style.width)*100+"% "+tapDistanceTop/parseInt(ghostEl.style.height)*100+"%")}},_onDragStart:function(evt,fallback){let _this=this,dataTransfer=evt.dataTransfer,options=_this.options;pluginEvent("dragStart",this,{evt:evt}),Sortable.eventCanceled?this._onDrop():(pluginEvent("setupClone",this),Sortable.eventCanceled||(cloneEl=clone(dragEl),cloneEl.draggable=!1,cloneEl.style["will-change"]="",this._hideClone(),toggleClass(cloneEl,this.options.chosenClass,!1),Sortable.clone=cloneEl),_this.cloneId=_nextTick((function(){pluginEvent("clone",_this),Sortable.eventCanceled||(_this.options.removeCloneOnHide||rootEl.insertBefore(cloneEl,dragEl),_this._hideClone(),_dispatchEvent({sortable:_this,name:"clone"}))})),!fallback&&toggleClass(dragEl,options.dragClass,!0),fallback?(ignoreNextClick=!0,_this._loopId=setInterval(_this._emulateDragOver,50)):(off(document,"mouseup",_this._onDrop),off(document,"touchend",_this._onDrop),off(document,"touchcancel",_this._onDrop),dataTransfer&&(dataTransfer.effectAllowed="move",options.setData&&options.setData.call(_this,dataTransfer,dragEl)),on(document,"drop",_this),css(dragEl,"transform","translateZ(0)")),awaitingDragStarted=!0,_this._dragStartId=_nextTick(_this._dragStarted.bind(_this,fallback,evt)),on(document,"selectstart",_this),moved=!0,Safari&&css(document.body,"user-select","none"))},_onDragOver:function(evt){let dragRect,targetRect,revert,vertical,el=this.el,target=evt.target,options=this.options,group=options.group,activeSortable=Sortable.active,isOwner=activeGroup===group,canSort=options.sort,fromSortable=putSortable||activeSortable,_this=this,completedFired=!1;if(!_silent){if(void 0!==evt.preventDefault&&evt.cancelable&&evt.preventDefault(),target=closest(target,options.draggable,el,!0),dragOverEvent("dragOver"),Sortable.eventCanceled)return completedFired;if(dragEl.contains(evt.target)||target.animated&&target.animatingX&&target.animatingY||_this._ignoreWhileAnimating===target)return completed(!1);if(ignoreNextClick=!1,activeSortable&&!options.disabled&&(isOwner?canSort||(revert=!rootEl.contains(dragEl)):putSortable===this||(this.lastPutMode=activeGroup.checkPull(this,activeSortable,dragEl,evt))&&group.checkPut(this,activeSortable,dragEl,evt))){if(vertical="vertical"===this._getDirection(evt,target),dragRect=getRect(dragEl),dragOverEvent("dragOverValid"),Sortable.eventCanceled)return completedFired;if(revert)return parentEl=rootEl,capture(),this._hideClone(),dragOverEvent("revert"),Sortable.eventCanceled||(nextEl?rootEl.insertBefore(dragEl,nextEl):rootEl.appendChild(dragEl)),completed(!0);let elLastChild=lastChild(el,options.draggable);if(!elLastChild||function(evt,vertical,sortable){let rect=getRect(lastChild(sortable.el,sortable.options.draggable));const spacer=10;return vertical?evt.clientX>rect.right+spacer||evt.clientX<=rect.right&&evt.clientY>rect.bottom&&evt.clientX>=rect.left:evt.clientX>rect.right&&evt.clientY>rect.top||evt.clientX<=rect.right&&evt.clientY>rect.bottom+spacer}(evt,vertical,this)&&!elLastChild.animated){if(elLastChild===dragEl)return completed(!1);if(elLastChild&&el===evt.target&&(target=elLastChild),target&&(targetRect=getRect(target)),!1!==onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt,!!target))return capture(),el.appendChild(dragEl),parentEl=el,changed(),completed(!0)}else if(target.parentNode===el){targetRect=getRect(target);let targetBeforeFirstSwap,sibling,direction=0,differentLevel=dragEl.parentNode!==el,differentRowCol=!function(dragRect,targetRect,vertical){let dragElS1Opp=vertical?dragRect.left:dragRect.top,dragElS2Opp=vertical?dragRect.right:dragRect.bottom,dragElOppLength=vertical?dragRect.width:dragRect.height,targetS1Opp=vertical?targetRect.left:targetRect.top,targetS2Opp=vertical?targetRect.right:targetRect.bottom,targetOppLength=vertical?targetRect.width:targetRect.height;return dragElS1Opp===targetS1Opp||dragElS2Opp===targetS2Opp||dragElS1Opp+dragElOppLength/2===targetS1Opp+targetOppLength/2}(dragEl.animated&&dragEl.toRect||dragRect,target.animated&&target.toRect||targetRect,vertical),side1=vertical?"top":"left",scrolledPastTop=isScrolledPast(target,"top","top")||isScrolledPast(dragEl,"top","top"),scrollBefore=scrolledPastTop?scrolledPastTop.scrollTop:void 0;if(lastTarget!==target&&(targetBeforeFirstSwap=targetRect[side1],pastFirstInvertThresh=!1,isCircumstantialInvert=!differentRowCol&&options.invertSwap||differentLevel),direction=function(evt,target,targetRect,vertical,swapThreshold,invertedSwapThreshold,invertSwap,isLastTarget){let mouseOnAxis=vertical?evt.clientY:evt.clientX,targetLength=vertical?targetRect.height:targetRect.width,targetS1=vertical?targetRect.top:targetRect.left,targetS2=vertical?targetRect.bottom:targetRect.right,invert=!1;if(!invertSwap)if(isLastTarget&&targetMoveDistance<targetLength*swapThreshold){if(!pastFirstInvertThresh&&(1===lastDirection?mouseOnAxis>targetS1+targetLength*invertedSwapThreshold/2:mouseOnAxis<targetS2-targetLength*invertedSwapThreshold/2)&&(pastFirstInvertThresh=!0),pastFirstInvertThresh)invert=!0;else if(1===lastDirection?mouseOnAxis<targetS1+targetMoveDistance:mouseOnAxis>targetS2-targetMoveDistance)return-lastDirection}else if(mouseOnAxis>targetS1+targetLength*(1-swapThreshold)/2&&mouseOnAxis<targetS2-targetLength*(1-swapThreshold)/2)return function(target){return index(dragEl)<index(target)?1:-1}(target);if(invert=invert||invertSwap,invert&&(mouseOnAxis<targetS1+targetLength*invertedSwapThreshold/2||mouseOnAxis>targetS2-targetLength*invertedSwapThreshold/2))return mouseOnAxis>targetS1+targetLength/2?1:-1;return 0}(evt,target,targetRect,vertical,differentRowCol?1:options.swapThreshold,null==options.invertedSwapThreshold?options.swapThreshold:options.invertedSwapThreshold,isCircumstantialInvert,lastTarget===target),0!==direction){let dragIndex=index(dragEl);do{dragIndex-=direction,sibling=parentEl.children[dragIndex]}while(sibling&&("none"===css(sibling,"display")||sibling===ghostEl))}if(0===direction||sibling===target)return completed(!1);lastTarget=target,lastDirection=direction;let nextSibling=target.nextElementSibling,after=!1;after=1===direction;let moveVector=onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt,after);if(!1!==moveVector)return 1!==moveVector&&-1!==moveVector||(after=1===moveVector),_silent=!0,setTimeout(_unsilent,30),capture(),after&&!nextSibling?el.appendChild(dragEl):target.parentNode.insertBefore(dragEl,after?nextSibling:target),scrolledPastTop&&scrollBy(scrolledPastTop,0,scrollBefore-scrolledPastTop.scrollTop),parentEl=dragEl.parentNode,void 0===targetBeforeFirstSwap||isCircumstantialInvert||(targetMoveDistance=Math.abs(targetBeforeFirstSwap-getRect(target)[side1])),changed(),completed(!0)}if(el.contains(dragEl))return completed(!1)}return!1}function dragOverEvent(name,extra){pluginEvent(name,_this,{evt:evt,isOwner:isOwner,axis:vertical?"vertical":"horizontal",revert:revert,dragRect:dragRect,targetRect:targetRect,canSort:canSort,fromSortable:fromSortable,target:target,completed:completed,onMove:(target,after)=>onMove(rootEl,el,dragEl,dragRect,target,getRect(target),evt,after),changed:changed,...extra})}function capture(){dragOverEvent("dragOverAnimationCapture"),_this.captureAnimationState(),_this!==fromSortable&&fromSortable.captureAnimationState()}function completed(insertion){return dragOverEvent("dragOverCompleted",{insertion:insertion}),insertion&&(isOwner?activeSortable._hideClone():activeSortable._showClone(_this),_this!==fromSortable&&(toggleClass(dragEl,putSortable?putSortable.options.ghostClass:activeSortable.options.ghostClass,!1),toggleClass(dragEl,options.ghostClass,!0)),putSortable!==_this&&_this!==Sortable.active?putSortable=_this:_this===Sortable.active&&putSortable&&(putSortable=null),fromSortable===_this&&(_this._ignoreWhileAnimating=target),_this.animateAll((function(){dragOverEvent("dragOverAnimationComplete"),_this._ignoreWhileAnimating=null})),_this!==fromSortable&&(fromSortable.animateAll(),fromSortable._ignoreWhileAnimating=null)),(target===dragEl&&!dragEl.animated||target===el&&!target.animated)&&(lastTarget=null),options.dragoverBubble||evt.rootEl||target===document||(dragEl.parentNode[expando]._isOutsideThisEl(evt.target),!insertion&&nearestEmptyInsertDetectEvent(evt)),!options.dragoverBubble&&evt.stopPropagation&&evt.stopPropagation(),completedFired=!0}function changed(){newIndex=index(dragEl),newDraggableIndex=index(dragEl,options.draggable),_dispatchEvent({sortable:_this,name:"change",toEl:el,newIndex:newIndex,newDraggableIndex:newDraggableIndex,originalEvent:evt})}},_ignoreWhileAnimating:null,_offMoveEvents:function(){off(document,"mousemove",this._onTouchMove),off(document,"touchmove",this._onTouchMove),off(document,"pointermove",this._onTouchMove),off(document,"dragover",nearestEmptyInsertDetectEvent),off(document,"mousemove",nearestEmptyInsertDetectEvent),off(document,"touchmove",nearestEmptyInsertDetectEvent)},_offUpEvents:function(){let ownerDocument=this.el.ownerDocument;off(ownerDocument,"mouseup",this._onDrop),off(ownerDocument,"touchend",this._onDrop),off(ownerDocument,"pointerup",this._onDrop),off(ownerDocument,"touchcancel",this._onDrop),off(document,"selectstart",this)},_onDrop:function(evt){let el=this.el,options=this.options;newIndex=index(dragEl),newDraggableIndex=index(dragEl,options.draggable),pluginEvent("drop",this,{evt:evt}),parentEl=dragEl&&dragEl.parentNode,newIndex=index(dragEl),newDraggableIndex=index(dragEl,options.draggable),Sortable.eventCanceled||(awaitingDragStarted=!1,isCircumstantialInvert=!1,pastFirstInvertThresh=!1,clearInterval(this._loopId),clearTimeout(this._dragStartTimer),_cancelNextTick(this.cloneId),_cancelNextTick(this._dragStartId),this.nativeDraggable&&(off(document,"drop",this),off(el,"dragstart",this._onDragStart)),this._offMoveEvents(),this._offUpEvents(),Safari&&css(document.body,"user-select",""),css(dragEl,"transform",""),evt&&(moved&&(evt.cancelable&&evt.preventDefault(),!options.dropBubble&&evt.stopPropagation()),ghostEl&&ghostEl.parentNode&&ghostEl.parentNode.removeChild(ghostEl),(rootEl===parentEl||putSortable&&"clone"!==putSortable.lastPutMode)&&cloneEl&&cloneEl.parentNode&&cloneEl.parentNode.removeChild(cloneEl),dragEl&&(this.nativeDraggable&&off(dragEl,"dragend",this),_disableDraggable(dragEl),dragEl.style["will-change"]="",moved&&!awaitingDragStarted&&toggleClass(dragEl,putSortable?putSortable.options.ghostClass:this.options.ghostClass,!1),toggleClass(dragEl,this.options.chosenClass,!1),_dispatchEvent({sortable:this,name:"unchoose",toEl:parentEl,newIndex:null,newDraggableIndex:null,originalEvent:evt}),rootEl!==parentEl?(newIndex>=0&&(_dispatchEvent({rootEl:parentEl,name:"add",toEl:parentEl,fromEl:rootEl,originalEvent:evt}),_dispatchEvent({sortable:this,name:"remove",toEl:parentEl,originalEvent:evt}),_dispatchEvent({rootEl:parentEl,name:"sort",toEl:parentEl,fromEl:rootEl,originalEvent:evt}),_dispatchEvent({sortable:this,name:"sort",toEl:parentEl,originalEvent:evt})),putSortable&&putSortable.save()):newIndex!==oldIndex&&newIndex>=0&&(_dispatchEvent({sortable:this,name:"update",toEl:parentEl,originalEvent:evt}),_dispatchEvent({sortable:this,name:"sort",toEl:parentEl,originalEvent:evt})),Sortable.active&&(null!=newIndex&&-1!==newIndex||(newIndex=oldIndex,newDraggableIndex=oldDraggableIndex),_dispatchEvent({sortable:this,name:"end",toEl:parentEl,originalEvent:evt}),this.save())))),this._nulling()},_nulling:function(){pluginEvent("nulling",this),rootEl=dragEl=parentEl=ghostEl=nextEl=cloneEl=lastDownEl=cloneHidden=tapEvt=touchEvt=moved=newIndex=newDraggableIndex=oldIndex=oldDraggableIndex=lastTarget=lastDirection=putSortable=activeGroup=Sortable.dragged=Sortable.ghost=Sortable.clone=Sortable.active=null,savedInputChecked.forEach((function(el){el.checked=!0})),savedInputChecked.length=lastDx=lastDy=0},handleEvent:function(evt){switch(evt.type){case"drop":case"dragend":this._onDrop(evt);break;case"dragenter":case"dragover":dragEl&&(this._onDragOver(evt),function(evt){evt.dataTransfer&&(evt.dataTransfer.dropEffect="move");evt.cancelable&&evt.preventDefault()}(evt));break;case"selectstart":evt.preventDefault()}},toArray:function(){let el,order=[],children=this.el.children,i=0,n=children.length,options=this.options;for(;i<n;i++)el=children[i],closest(el,options.draggable,this.el,!1)&&order.push(el.getAttribute(options.dataIdAttr)||_generateId(el));return order},sort:function(order){let items={},rootEl=this.el;this.toArray().forEach((function(id,i){let el=rootEl.children[i];closest(el,this.options.draggable,rootEl,!1)&&(items[id]=el)}),this),order.forEach((function(id){items[id]&&(rootEl.removeChild(items[id]),rootEl.appendChild(items[id]))}))},save:function(){let store=this.options.store;store&&store.set&&store.set(this)},closest:function(el,selector){return closest(el,selector||this.options.draggable,this.el,!1)},option:function(name,value){let options=this.options;if(void 0===value)return options[name];{let modifiedValue=PluginManager.modifyOption(this,name,value);options[name]=void 0!==modifiedValue?modifiedValue:value,"group"===name&&_prepareGroup(options)}},destroy:function(){pluginEvent("destroy",this);let el=this.el;el[expando]=null,off(el,"mousedown",this._onTapStart),off(el,"touchstart",this._onTapStart),off(el,"pointerdown",this._onTapStart),this.nativeDraggable&&(off(el,"dragover",this),off(el,"dragenter",this)),Array.prototype.forEach.call(el.querySelectorAll("[draggable]"),(function(el){el.removeAttribute("draggable")})),this._onDrop(),this._disableDelayedDragEvents(),sortables.splice(sortables.indexOf(this.el),1),this.el=el=null},_hideClone:function(){if(!cloneHidden){if(pluginEvent("hideClone",this),Sortable.eventCanceled)return;css(cloneEl,"display","none"),this.options.removeCloneOnHide&&cloneEl.parentNode&&cloneEl.parentNode.removeChild(cloneEl),cloneHidden=!0}},_showClone:function(putSortable){if("clone"===putSortable.lastPutMode){if(cloneHidden){if(pluginEvent("showClone",this),Sortable.eventCanceled)return;rootEl.contains(dragEl)&&!this.options.group.revertClone?rootEl.insertBefore(cloneEl,dragEl):nextEl?rootEl.insertBefore(cloneEl,nextEl):rootEl.appendChild(cloneEl),this.options.group.revertClone&&this.animate(dragEl,cloneEl),css(cloneEl,"display",""),cloneHidden=!1}}else this._hideClone()}},documentExists&&on(document,"touchmove",(function(evt){(Sortable.active||awaitingDragStarted)&&evt.cancelable&&evt.preventDefault()})),Sortable.utils={on:on,off:off,css:css,find:find,is:function(el,selector){return!!closest(el,selector,el,!1)},extend:function(dst,src){if(dst&&src)for(var key in src)src.hasOwnProperty(key)&&(dst[key]=src[key]);return dst},throttle:throttle,closest:closest,toggleClass:toggleClass,clone:clone,index:index,nextTick:_nextTick,cancelNextTick:_cancelNextTick,detectDirection:_detectDirection,getChild:getChild},Sortable.get=function(element){return element[expando]},Sortable.mount=function(...plugins){plugins[0].constructor===Array&&(plugins=plugins[0]),plugins.forEach((plugin=>{if(!plugin.prototype||!plugin.prototype.constructor)throw`Sortable: Mounted plugin must be a constructor function, not ${{}.toString.call(plugin)}`;plugin.utils&&(Sortable.utils={...Sortable.utils,...plugin.utils}),PluginManager.mount(plugin)}))},Sortable.create=function(el,options){return new Sortable(el,options)},Sortable.version="1.10.2";let scrollEl,scrollRootEl,lastAutoScrollX,lastAutoScrollY,touchEvt$1,pointerElemChangedInterval,autoScrolls=[],scrolling=!1;function clearAutoScrolls(){autoScrolls.forEach((function(autoScroll){clearInterval(autoScroll.pid)})),autoScrolls=[]}function clearPointerElemChangedInterval(){clearInterval(pointerElemChangedInterval)}const autoScroll=throttle((function(evt,options,rootEl,isFallback){if(!options.scroll)return;const x=(evt.touches?evt.touches[0]:evt).clientX,y=(evt.touches?evt.touches[0]:evt).clientY,sens=options.scrollSensitivity,speed=options.scrollSpeed,winScroller=getWindowScrollingElement();let scrollCustomFn,scrollThisInstance=!1;scrollRootEl!==rootEl&&(scrollRootEl=rootEl,clearAutoScrolls(),scrollEl=options.scroll,scrollCustomFn=options.scrollFn,!0===scrollEl&&(scrollEl=getParentAutoScrollElement(rootEl,!0)));let layersOut=0,currentParent=scrollEl;do{let canScrollX,canScrollY,el=currentParent,rect=getRect(el),top=rect.top,bottom=rect.bottom,left=rect.left,right=rect.right,width=rect.width,height=rect.height,scrollWidth=el.scrollWidth,scrollHeight=el.scrollHeight,elCSS=css(el),scrollPosX=el.scrollLeft,scrollPosY=el.scrollTop;el===winScroller?(canScrollX=width<scrollWidth&&("auto"===elCSS.overflowX||"scroll"===elCSS.overflowX||"visible"===elCSS.overflowX),canScrollY=height<scrollHeight&&("auto"===elCSS.overflowY||"scroll"===elCSS.overflowY||"visible"===elCSS.overflowY)):(canScrollX=width<scrollWidth&&("auto"===elCSS.overflowX||"scroll"===elCSS.overflowX),canScrollY=height<scrollHeight&&("auto"===elCSS.overflowY||"scroll"===elCSS.overflowY));let vx=canScrollX&&(Math.abs(right-x)<=sens&&scrollPosX+width<scrollWidth)-(Math.abs(left-x)<=sens&&!!scrollPosX),vy=canScrollY&&(Math.abs(bottom-y)<=sens&&scrollPosY+height<scrollHeight)-(Math.abs(top-y)<=sens&&!!scrollPosY);if(!autoScrolls[layersOut])for(let i=0;i<=layersOut;i++)autoScrolls[i]||(autoScrolls[i]={});autoScrolls[layersOut].vx==vx&&autoScrolls[layersOut].vy==vy&&autoScrolls[layersOut].el===el||(autoScrolls[layersOut].el=el,autoScrolls[layersOut].vx=vx,autoScrolls[layersOut].vy=vy,clearInterval(autoScrolls[layersOut].pid),0==vx&&0==vy||(scrollThisInstance=!0,autoScrolls[layersOut].pid=setInterval(function(){isFallback&&0===this.layer&&Sortable.active._onTouchMove(touchEvt$1);let scrollOffsetY=autoScrolls[this.layer].vy?autoScrolls[this.layer].vy*speed:0,scrollOffsetX=autoScrolls[this.layer].vx?autoScrolls[this.layer].vx*speed:0;"function"==typeof scrollCustomFn&&"continue"!==scrollCustomFn.call(Sortable.dragged.parentNode[expando],scrollOffsetX,scrollOffsetY,evt,touchEvt$1,autoScrolls[this.layer].el)||scrollBy(autoScrolls[this.layer].el,scrollOffsetX,scrollOffsetY)}.bind({layer:layersOut}),24))),layersOut++}while(options.bubbleScroll&&currentParent!==winScroller&&(currentParent=getParentAutoScrollElement(currentParent,!1)));scrolling=scrollThisInstance}),30),drop=function({originalEvent:originalEvent,putSortable:putSortable,dragEl:dragEl,activeSortable:activeSortable,dispatchSortableEvent:dispatchSortableEvent,hideGhostForTarget:hideGhostForTarget,unhideGhostForTarget:unhideGhostForTarget}){if(!originalEvent)return;let toSortable=putSortable||activeSortable;hideGhostForTarget();let touch=originalEvent.changedTouches&&originalEvent.changedTouches.length?originalEvent.changedTouches[0]:originalEvent,target=document.elementFromPoint(touch.clientX,touch.clientY);unhideGhostForTarget(),toSortable&&!toSortable.el.contains(target)&&(dispatchSortableEvent("spill"),this.onSpill({dragEl:dragEl,putSortable:putSortable}))};function Revert(){}function Remove(){}let lastSwapEl;Revert.prototype={startIndex:null,dragStart({oldDraggableIndex:oldDraggableIndex}){this.startIndex=oldDraggableIndex},onSpill({dragEl:dragEl,putSortable:putSortable}){this.sortable.captureAnimationState(),putSortable&&putSortable.captureAnimationState();let nextSibling=getChild(this.sortable.el,this.startIndex,this.options);nextSibling?this.sortable.el.insertBefore(dragEl,nextSibling):this.sortable.el.appendChild(dragEl),this.sortable.animateAll(),putSortable&&putSortable.animateAll()},drop:drop},Object.assign(Revert,{pluginName:"revertOnSpill"}),Remove.prototype={onSpill({dragEl:dragEl,putSortable:putSortable}){const parentSortable=putSortable||this.sortable;parentSortable.captureAnimationState(),dragEl.parentNode&&dragEl.parentNode.removeChild(dragEl),parentSortable.animateAll()},drop:drop},Object.assign(Remove,{pluginName:"removeOnSpill"});let lastMultiDragSelect,multiDragSortable,dragEl$1,clonesFromRect,clonesHidden,multiDragElements=[],multiDragClones=[],initialFolding=!1,folding=!1,dragStarted=!1;function insertMultiDragClones(elementsInserted,rootEl){multiDragClones.forEach(((clone,i)=>{let target=rootEl.children[clone.sortableIndex+(elementsInserted?Number(i):0)];target?rootEl.insertBefore(clone,target):rootEl.appendChild(clone)}))}function removeMultiDragElements(){multiDragElements.forEach((multiDragElement=>{multiDragElement!==dragEl$1&&multiDragElement.parentNode&&multiDragElement.parentNode.removeChild(multiDragElement)}))}return Sortable.mount(new function(){function AutoScroll(){this.defaults={scroll:!0,scrollSensitivity:30,scrollSpeed:10,bubbleScroll:!0};for(let fn in this)"_"===fn.charAt(0)&&"function"==typeof this[fn]&&(this[fn]=this[fn].bind(this))}return AutoScroll.prototype={dragStarted({originalEvent:originalEvent}){this.sortable.nativeDraggable?on(document,"dragover",this._handleAutoScroll):this.options.supportPointer?on(document,"pointermove",this._handleFallbackAutoScroll):originalEvent.touches?on(document,"touchmove",this._handleFallbackAutoScroll):on(document,"mousemove",this._handleFallbackAutoScroll)},dragOverCompleted({originalEvent:originalEvent}){this.options.dragOverBubble||originalEvent.rootEl||this._handleAutoScroll(originalEvent)},drop(){this.sortable.nativeDraggable?off(document,"dragover",this._handleAutoScroll):(off(document,"pointermove",this._handleFallbackAutoScroll),off(document,"touchmove",this._handleFallbackAutoScroll),off(document,"mousemove",this._handleFallbackAutoScroll)),clearPointerElemChangedInterval(),clearAutoScrolls(),clearTimeout(_throttleTimeout),_throttleTimeout=void 0},nulling(){touchEvt$1=scrollRootEl=scrollEl=scrolling=pointerElemChangedInterval=lastAutoScrollX=lastAutoScrollY=null,autoScrolls.length=0},_handleFallbackAutoScroll(evt){this._handleAutoScroll(evt,!0)},_handleAutoScroll(evt,fallback){const x=(evt.touches?evt.touches[0]:evt).clientX,y=(evt.touches?evt.touches[0]:evt).clientY,elem=document.elementFromPoint(x,y);if(touchEvt$1=evt,fallback||Edge||IE11OrLess||Safari){autoScroll(evt,this.options,elem,fallback);let ogElemScroller=getParentAutoScrollElement(elem,!0);!scrolling||pointerElemChangedInterval&&x===lastAutoScrollX&&y===lastAutoScrollY||(pointerElemChangedInterval&&clearPointerElemChangedInterval(),pointerElemChangedInterval=setInterval((()=>{let newElem=getParentAutoScrollElement(document.elementFromPoint(x,y),!0);newElem!==ogElemScroller&&(ogElemScroller=newElem,clearAutoScrolls()),autoScroll(evt,this.options,newElem,fallback)}),10),lastAutoScrollX=x,lastAutoScrollY=y)}else{if(!this.options.bubbleScroll||getParentAutoScrollElement(elem,!0)===getWindowScrollingElement())return void clearAutoScrolls();autoScroll(evt,this.options,getParentAutoScrollElement(elem,!1),!1)}}},Object.assign(AutoScroll,{pluginName:"scroll",initializeByDefault:!0})}),Sortable.mount(Remove,Revert),Sortable.mount(new function(){function Swap(){this.defaults={swapClass:"sortable-swap-highlight"}}return Swap.prototype={dragStart({dragEl:dragEl}){lastSwapEl=dragEl},dragOverValid({completed:completed,target:target,onMove:onMove,activeSortable:activeSortable,changed:changed,cancel:cancel}){if(!activeSortable.options.swap)return;let el=this.sortable.el,options=this.options;if(target&&target!==el){let prevSwapEl=lastSwapEl;!1!==onMove(target)?(toggleClass(target,options.swapClass,!0),lastSwapEl=target):lastSwapEl=null,prevSwapEl&&prevSwapEl!==lastSwapEl&&toggleClass(prevSwapEl,options.swapClass,!1)}changed(),completed(!0),cancel()},drop({activeSortable:activeSortable,putSortable:putSortable,dragEl:dragEl}){let toSortable=putSortable||this.sortable,options=this.options;lastSwapEl&&toggleClass(lastSwapEl,options.swapClass,!1),lastSwapEl&&(options.swap||putSortable&&putSortable.options.swap)&&dragEl!==lastSwapEl&&(toSortable.captureAnimationState(),toSortable!==activeSortable&&activeSortable.captureAnimationState(),function(n1,n2){let i1,i2,p1=n1.parentNode,p2=n2.parentNode;if(!p1||!p2||p1.isEqualNode(n2)||p2.isEqualNode(n1))return;i1=index(n1),i2=index(n2),p1.isEqualNode(p2)&&i1<i2&&i2++;p1.insertBefore(n2,p1.children[i1]),p2.insertBefore(n1,p2.children[i2])}(dragEl,lastSwapEl),toSortable.animateAll(),toSortable!==activeSortable&&activeSortable.animateAll())},nulling(){lastSwapEl=null}},Object.assign(Swap,{pluginName:"swap",eventProperties:()=>({swapItem:lastSwapEl})})}),Sortable.mount(new function(){function MultiDrag(sortable){for(let fn in this)"_"===fn.charAt(0)&&"function"==typeof this[fn]&&(this[fn]=this[fn].bind(this));sortable.options.supportPointer?on(document,"pointerup",this._deselectMultiDrag):(on(document,"mouseup",this._deselectMultiDrag),on(document,"touchend",this._deselectMultiDrag)),on(document,"keydown",this._checkKeyDown),on(document,"keyup",this._checkKeyUp),this.defaults={selectedClass:"sortable-selected",multiDragKey:null,setData(dataTransfer,dragEl){let data="";multiDragElements.length&&multiDragSortable===sortable?multiDragElements.forEach(((multiDragElement,i)=>{data+=(i?", ":"")+multiDragElement.textContent})):data=dragEl.textContent,dataTransfer.setData("Text",data)}}}return MultiDrag.prototype={multiDragKeyDown:!1,isMultiDrag:!1,delayStartGlobal({dragEl:dragged}){dragEl$1=dragged},delayEnded(){this.isMultiDrag=~multiDragElements.indexOf(dragEl$1)},setupClone({sortable:sortable,cancel:cancel}){if(this.isMultiDrag){for(let i=0;i<multiDragElements.length;i++)multiDragClones.push(clone(multiDragElements[i])),multiDragClones[i].sortableIndex=multiDragElements[i].sortableIndex,multiDragClones[i].draggable=!1,multiDragClones[i].style["will-change"]="",toggleClass(multiDragClones[i],this.options.selectedClass,!1),multiDragElements[i]===dragEl$1&&toggleClass(multiDragClones[i],this.options.chosenClass,!1);sortable._hideClone(),cancel()}},clone({sortable:sortable,rootEl:rootEl,dispatchSortableEvent:dispatchSortableEvent,cancel:cancel}){this.isMultiDrag&&(this.options.removeCloneOnHide||multiDragElements.length&&multiDragSortable===sortable&&(insertMultiDragClones(!0,rootEl),dispatchSortableEvent("clone"),cancel()))},showClone({cloneNowShown:cloneNowShown,rootEl:rootEl,cancel:cancel}){this.isMultiDrag&&(insertMultiDragClones(!1,rootEl),multiDragClones.forEach((clone=>{css(clone,"display","")})),cloneNowShown(),clonesHidden=!1,cancel())},hideClone({sortable:sortable,cloneNowHidden:cloneNowHidden,cancel:cancel}){this.isMultiDrag&&(multiDragClones.forEach((clone=>{css(clone,"display","none"),this.options.removeCloneOnHide&&clone.parentNode&&clone.parentNode.removeChild(clone)})),cloneNowHidden(),clonesHidden=!0,cancel())},dragStartGlobal({sortable:sortable}){!this.isMultiDrag&&multiDragSortable&&multiDragSortable.multiDrag._deselectMultiDrag(),multiDragElements.forEach((multiDragElement=>{multiDragElement.sortableIndex=index(multiDragElement)})),multiDragElements=multiDragElements.sort((function(a,b){return a.sortableIndex-b.sortableIndex})),dragStarted=!0},dragStarted({sortable:sortable}){if(this.isMultiDrag){if(this.options.sort&&(sortable.captureAnimationState(),this.options.animation)){multiDragElements.forEach((multiDragElement=>{multiDragElement!==dragEl$1&&css(multiDragElement,"position","absolute")}));let dragRect=getRect(dragEl$1,!1,!0,!0);multiDragElements.forEach((multiDragElement=>{multiDragElement!==dragEl$1&&setRect(multiDragElement,dragRect)})),folding=!0,initialFolding=!0}sortable.animateAll((()=>{folding=!1,initialFolding=!1,this.options.animation&&multiDragElements.forEach((multiDragElement=>{unsetRect(multiDragElement)})),this.options.sort&&removeMultiDragElements()}))}},dragOver({target:target,completed:completed,cancel:cancel}){folding&&~multiDragElements.indexOf(target)&&(completed(!1),cancel())},revert({fromSortable:fromSortable,rootEl:rootEl,sortable:sortable,dragRect:dragRect}){multiDragElements.length>1&&(multiDragElements.forEach((multiDragElement=>{sortable.addAnimationState({target:multiDragElement,rect:folding?getRect(multiDragElement):dragRect}),unsetRect(multiDragElement),multiDragElement.fromRect=dragRect,fromSortable.removeAnimationState(multiDragElement)})),folding=!1,function(clonesInserted,rootEl){multiDragElements.forEach(((multiDragElement,i)=>{let target=rootEl.children[multiDragElement.sortableIndex+(clonesInserted?Number(i):0)];target?rootEl.insertBefore(multiDragElement,target):rootEl.appendChild(multiDragElement)}))}(!this.options.removeCloneOnHide,rootEl))},dragOverCompleted({sortable:sortable,isOwner:isOwner,insertion:insertion,activeSortable:activeSortable,parentEl:parentEl,putSortable:putSortable}){let options=this.options;if(insertion){if(isOwner&&activeSortable._hideClone(),initialFolding=!1,options.animation&&multiDragElements.length>1&&(folding||!isOwner&&!activeSortable.options.sort&&!putSortable)){let dragRectAbsolute=getRect(dragEl$1,!1,!0,!0);multiDragElements.forEach((multiDragElement=>{multiDragElement!==dragEl$1&&(setRect(multiDragElement,dragRectAbsolute),parentEl.appendChild(multiDragElement))})),folding=!0}if(!isOwner)if(folding||removeMultiDragElements(),multiDragElements.length>1){let clonesHiddenBefore=clonesHidden;activeSortable._showClone(sortable),activeSortable.options.animation&&!clonesHidden&&clonesHiddenBefore&&multiDragClones.forEach((clone=>{activeSortable.addAnimationState({target:clone,rect:clonesFromRect}),clone.fromRect=clonesFromRect,clone.thisAnimationDuration=null}))}else activeSortable._showClone(sortable)}},dragOverAnimationCapture({dragRect:dragRect,isOwner:isOwner,activeSortable:activeSortable}){if(multiDragElements.forEach((multiDragElement=>{multiDragElement.thisAnimationDuration=null})),activeSortable.options.animation&&!isOwner&&activeSortable.multiDrag.isMultiDrag){clonesFromRect=Object.assign({},dragRect);let dragMatrix=matrix(dragEl$1,!0);clonesFromRect.top-=dragMatrix.f,clonesFromRect.left-=dragMatrix.e}},dragOverAnimationComplete(){folding&&(folding=!1,removeMultiDragElements())},drop({originalEvent:evt,rootEl:rootEl,parentEl:parentEl,sortable:sortable,dispatchSortableEvent:dispatchSortableEvent,oldIndex:oldIndex,putSortable:putSortable}){let toSortable=putSortable||this.sortable;if(!evt)return;let options=this.options,children=parentEl.children;if(!dragStarted)if(options.multiDragKey&&!this.multiDragKeyDown&&this._deselectMultiDrag(),toggleClass(dragEl$1,options.selectedClass,!~multiDragElements.indexOf(dragEl$1)),~multiDragElements.indexOf(dragEl$1))multiDragElements.splice(multiDragElements.indexOf(dragEl$1),1),lastMultiDragSelect=null,dispatchEvent({sortable:sortable,rootEl:rootEl,name:"deselect",targetEl:dragEl$1,originalEvt:evt});else{if(multiDragElements.push(dragEl$1),dispatchEvent({sortable:sortable,rootEl:rootEl,name:"select",targetEl:dragEl$1,originalEvt:evt}),evt.shiftKey&&lastMultiDragSelect&&sortable.el.contains(lastMultiDragSelect)){let lastIndex=index(lastMultiDragSelect),currentIndex=index(dragEl$1);if(~lastIndex&&~currentIndex&&lastIndex!==currentIndex){let n,i;for(currentIndex>lastIndex?(i=lastIndex,n=currentIndex):(i=currentIndex,n=lastIndex+1);i<n;i++)~multiDragElements.indexOf(children[i])||(toggleClass(children[i],options.selectedClass,!0),multiDragElements.push(children[i]),dispatchEvent({sortable:sortable,rootEl:rootEl,name:"select",targetEl:children[i],originalEvt:evt}))}}else lastMultiDragSelect=dragEl$1;multiDragSortable=toSortable}if(dragStarted&&this.isMultiDrag){if((parentEl[expando].options.sort||parentEl!==rootEl)&&multiDragElements.length>1){let dragRect=getRect(dragEl$1),multiDragIndex=index(dragEl$1,":not(."+this.options.selectedClass+")");if(!initialFolding&&options.animation&&(dragEl$1.thisAnimationDuration=null),toSortable.captureAnimationState(),!initialFolding&&(options.animation&&(dragEl$1.fromRect=dragRect,multiDragElements.forEach((multiDragElement=>{if(multiDragElement.thisAnimationDuration=null,multiDragElement!==dragEl$1){let rect=folding?getRect(multiDragElement):dragRect;multiDragElement.fromRect=rect,toSortable.addAnimationState({target:multiDragElement,rect:rect})}}))),removeMultiDragElements(),multiDragElements.forEach((multiDragElement=>{children[multiDragIndex]?parentEl.insertBefore(multiDragElement,children[multiDragIndex]):parentEl.appendChild(multiDragElement),multiDragIndex++})),oldIndex===index(dragEl$1))){let update=!1;multiDragElements.forEach((multiDragElement=>{multiDragElement.sortableIndex===index(multiDragElement)||(update=!0)})),update&&dispatchSortableEvent("update")}multiDragElements.forEach((multiDragElement=>{unsetRect(multiDragElement)})),toSortable.animateAll()}multiDragSortable=toSortable}(rootEl===parentEl||putSortable&&"clone"!==putSortable.lastPutMode)&&multiDragClones.forEach((clone=>{clone.parentNode&&clone.parentNode.removeChild(clone)}))},nullingGlobal(){this.isMultiDrag=dragStarted=!1,multiDragClones.length=0},destroyGlobal(){this._deselectMultiDrag(),off(document,"pointerup",this._deselectMultiDrag),off(document,"mouseup",this._deselectMultiDrag),off(document,"touchend",this._deselectMultiDrag),off(document,"keydown",this._checkKeyDown),off(document,"keyup",this._checkKeyUp)},_deselectMultiDrag(evt){if(!(void 0!==dragStarted&&dragStarted||multiDragSortable!==this.sortable||evt&&closest(evt.target,this.options.draggable,this.sortable.el,!1)||evt&&0!==evt.button))for(;multiDragElements.length;){let el=multiDragElements[0];toggleClass(el,this.options.selectedClass,!1),multiDragElements.shift(),dispatchEvent({sortable:this.sortable,rootEl:this.sortable.el,name:"deselect",targetEl:el,originalEvt:evt})}},_checkKeyDown(evt){evt.key===this.options.multiDragKey&&(this.multiDragKeyDown=!0)},_checkKeyUp(evt){evt.key===this.options.multiDragKey&&(this.multiDragKeyDown=!1)}},Object.assign(MultiDrag,{pluginName:"multiDrag",utils:{select(el){let sortable=el.parentNode[expando];sortable&&sortable.options.multiDrag&&!~multiDragElements.indexOf(el)&&(multiDragSortable&&multiDragSortable!==sortable&&(multiDragSortable.multiDrag._deselectMultiDrag(),multiDragSortable=sortable),toggleClass(el,sortable.options.selectedClass,!0),multiDragElements.push(el))},deselect(el){let sortable=el.parentNode[expando],index=multiDragElements.indexOf(el);sortable&&sortable.options.multiDrag&&~index&&(toggleClass(el,sortable.options.selectedClass,!1),multiDragElements.splice(index,1))}},eventProperties(){const oldIndicies=[],newIndicies=[];return multiDragElements.forEach((multiDragElement=>{let newIndex;oldIndicies.push({multiDragElement:multiDragElement,index:multiDragElement.sortableIndex}),newIndex=folding&&multiDragElement!==dragEl$1?-1:folding?index(multiDragElement,":not(."+this.options.selectedClass+")"):index(multiDragElement),newIndicies.push({multiDragElement:multiDragElement,index:newIndex})})),{items:[...multiDragElements],clones:[...multiDragClones],oldIndicies:oldIndicies,newIndicies:newIndicies}},optionListeners:{multiDragKey:key=>("ctrl"===(key=key.toLowerCase())?key="Control":key.length>1&&(key=key.charAt(0).toUpperCase()+key.substr(1)),key)}})}),Sortable})),function(){happyFiles.debug&&console.warn("happyfiles.js"),this.HF=function(selector){var hfWrapper,categoriesWrapper,termElements,hf=this;this.selectAll=function(parentNode,selector){if(parentNode){var elements=parentNode.querySelectorAll(selector);return Array.prototype.slice.apply(elements)}},this.onUpload=function(){window.wp&&void 0!==window.wp.Uploader&&void 0!==wp.Uploader&&(void 0!==wp.Uploader.queue&&wp.Uploader.queue.on("all",(function(fileObj,serverData){var uploadWrapper=document.getElementById("hf-upload-wrapper");uploadWrapper&&("add"===fileObj&&(uploadWrapper.classList.remove("is-uploaded"),uploadWrapper.classList.add("is-uploading")),"reset"===fileObj&&(uploadWrapper.classList.add("is-uploaded"),setTimeout((function(){uploadWrapper.classList.remove("is-uploading")}),1e3)))})),jQuery.extend(wp.Uploader.prototype,{init:function(file_attachment){this.uploader.bind("BeforeUpload",(function(up,file){up.settings.multipart_params.hfTermId=parseInt(happyFiles.open)}))},success:function(file_attachment){var openTerm=happyFiles.open;happyFiles.terms.forEach((function(term){"all"==term.term_id&&(term.count+=1),"-1"!=term.term_id||happyFiles.canEdit||(term.count+=1),null==openTerm||"all"==openTerm||"-1"==openTerm?-1==term.term_id&&(term.count+=1):term.term_id==openTerm&&happyFiles.canEdit&&(term.count+=1)})),hf.refreshAttachmentsBrowser()}}))},this.onDelete=function(){jQuery(document).ajaxSuccess((function(event,xhr,settings){settings.hasOwnProperty("data")&&"string"==typeof settings.data&&-1!=settings.data.indexOf("action=delete-post")&&jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_get_attachment_terms",postType:happyFiles.postType,taxonomy:happyFiles.taxonomy},success:function(res){!0===res.success&&res.data.hasOwnProperty("terms")&&(happyFiles.terms=res.data.terms,hf.updateTermCount())}})}))},this.initFilter=function(){if(window.wp&&void 0!==wp.media){var HappyFilesMediaLibraryTaxonomyFilter=wp.media.view.AttachmentFilters.extend({id:happyFiles.filterId,createFilters:function(){var filters={};_.each(happyFiles.terms||{},(function(value,index){var term=happyFiles.terms[index],term_id=term.term_id;filters[term_id]={text:value.name,props:{[happyFiles.taxonomy]:term.hasOwnProperty("value")?term.value:term_id},priority:20}})),filters.all.priority=10,filters[-1].priority=11,this.filters=filters,happyFiles.filters=this.filters}}),AttachmentsBrowser=wp.media.view.AttachmentsBrowser;wp.media.view.AttachmentsBrowser=wp.media.view.AttachmentsBrowser.extend({createToolbar:function(){happyFiles.attachmentsBrowser=this,AttachmentsBrowser.prototype.createToolbar.call(this),this.toolbar.set("HappyFilesMediaLibraryTaxonomyFilter",new HappyFilesMediaLibraryTaxonomyFilter({controller:this.controller,model:this.collection.props,priority:-75}).render())}})}},this.onUpload(),this.onDelete(),this.initFilter(),this.newCategoryListener=function(){var newCategoryWrapper=document.getElementById("hf-new-category-wrapper"),newCategoryToggle=document.getElementById("hf-new-category-toggle"),createCategoryButton=document.getElementById("hf-new-category-create"),createCategoryInput=document.getElementById("hf-new-category-input"),upgradeWrapper=document.getElementById("hf-upgrade-notification-wrapper");newCategoryWrapper&&newCategoryToggle&&newCategoryToggle.addEventListener("click",(function(e){(e.preventDefault(),happyFiles.renaming)?alert(happyFiles.l10n.deleteCategoryFinishRenamingFirst):happyFiles.terms.length-2>=10?upgradeWrapper&&(upgradeWrapper.classList.contains("show")?upgradeWrapper.classList.remove("show"):upgradeWrapper.classList.add("show")):(newCategoryWrapper.classList.toggle("show"),newCategoryWrapper.classList.contains("show")&&createCategoryInput.focus())}));var newCategoryCancel=document.getElementById("hf-new-category-cancel");if(newCategoryWrapper&&newCategoryCancel&&newCategoryCancel.addEventListener("click",(function(e){e.preventDefault(),newCategoryWrapper.classList.remove("show")})),createCategoryButton&&createCategoryInput){var createCategory=function(){var newCategoryNames=createCategoryInput.value;newCategoryNames?jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_create_category",newCategoryNames:newCategoryNames,parentId:happyFiles.open,postType:happyFiles.postType,taxonomy:happyFiles.taxonomy},success:function(res){if(!1===res.success&&res.data.hasOwnProperty("error")&&alert(res.data.error),!0===res.success){if(res.data.hasOwnProperty("limit_reached")&&!0===res.data.limit_reached&&upgradeWrapper.classList.add("show"),createCategoryInput.value="",newCategoryToggle.click(),res.data.hasOwnProperty("tree")&&(happyFiles.tree=res.data.tree),res.data.hasOwnProperty("terms")){happyFiles.terms=res.data.terms;var mediaTermSelectElement=document.getElementById(happyFiles.filterId);mediaTermSelectElement&&happyFiles.terms.forEach((function(term,index){if(!(term.term_id<0||isNaN(term.term_id))&&!mediaTermSelectElement.querySelector('option[value="'+term.term_id+'"]')){var newOption=document.createElement("option");newOption.innerText=happyFiles.terms[index].name,newOption.value=happyFiles.terms[index].term_id,mediaTermSelectElement.append(newOption)}})),happyFiles.attachmentsBrowser&&happyFiles.attachmentsBrowser.toolbar.get("HappyFilesMediaLibraryTaxonomyFilter").createFilters()}var noCategoryNotification=document.getElementById("hf-no-category-notification-wrapper");noCategoryNotification&&noCategoryNotification.remove(),hf.init(),hf.contextMenuListener()}}}):alert(happyFiles.l10n.newCategoryNoName)};createCategoryInput.addEventListener("keydown",(function(event){"Enter"===event.key&&createCategory(),"Escape"===event.key&&newCategoryWrapper.classList.remove("show")})),createCategoryButton.addEventListener("click",(function(e){e.preventDefault(),createCategory()}))}},this.renameCategoryListener=function(){var categoryName,renameButton=document.getElementById("hf-rename-category"),termActionsWrapper=document.getElementById("hf-term-action-wrapper");if(renameButton&&categoriesWrapper){var confirmButton=document.getElementById("hf-confirm"),cancelButton=document.getElementById("hf-cancel"),cancel=function(categoryName){var activeTermWrapper=categoriesWrapper.querySelector(".rename"),activeTerm=activeTermWrapper.querySelector(".term");activeTermWrapper&&activeTerm&&(activeTerm.innerHTML,activeTerm.innerText=categoryName,happyFiles.renaming=!1,termActionsWrapper.classList.remove("show"),activeTerm.removeAttribute("contenteditable"),activeTermWrapper.classList.remove("rename"))},rename=function(categoryName){var activeTermWrapper=categoriesWrapper.querySelector(".rename"),activeTerm=activeTermWrapper.querySelector(".term");if(activeTermWrapper&&activeTerm){happyFiles.renaming=!1;var newCategoryName=activeTerm.innerText.trim();newCategoryName?(termActionsWrapper.classList.remove("show"),jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_rename_category",newCategoryName:newCategoryName,termId:happyFiles.open,taxonomy:happyFiles.taxonomy},success:function(res){!res.success&&res.data.hasOwnProperty("error")&&(activeTerm.innerText=categoryName,alert(res.data.error)),activeTerm.removeAttribute("contenteditable"),activeTermWrapper.classList.remove("rename")}})):alert(happyFiles.l10n.renameCategoryNoName)}};renameButton.addEventListener("click",(function(e){if(e.preventDefault(),!happyFiles.renaming){var activeTermWrapper=categoriesWrapper.querySelector(".active"),activeTerm=activeTermWrapper.querySelector(".term");if(activeTermWrapper){var activeTermId=parseInt(activeTermWrapper.dataset.termId);activeTermId<=0||isNaN(activeTermId)||(categoryName=activeTerm.innerText,happyFiles.renaming=!0,termActionsWrapper.classList.add("show"),activeTermWrapper.classList.add("rename"),activeTerm.setAttribute("contenteditable",!0),activeTerm.setAttribute("spellcheck",!1),activeTerm.focus(),activeTerm.addEventListener("keydown",(function(event){"Enter"===event.key&&(event.preventDefault(),event.stopPropagation(),rename(categoryName)),"Escape"===event.key&&cancel(categoryName)})))}else alert(happyFiles.l10n.renameCategoryNoCategorySelected)}})),confirmButton&&confirmButton.addEventListener("click",(function(e){rename(categoryName)})),cancelButton&&cancelButton.addEventListener("click",(function(e){cancel(categoryName)}))}},this.deleteCategoryListener=function(){var deleteButton=document.getElementById("hf-delete-category");deleteButton&&deleteButton.addEventListener("click",(function(e){var openTerm=happyFiles.open;openTerm<=0||isNaN(openTerm)?alert(happyFiles.l10n.deleteCategoryNoCategorySelected):happyFiles.renaming?alert(happyFiles.l10n.deleteCategoryFinishRenamingFirst):confirm(happyFiles.l10n.deleteCategoryConfirmation)&&jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_delete_category",termId:openTerm,taxonomy:happyFiles.taxonomy,postType:happyFiles.postType},success:function(res){if(!1===res.success&&res.data.hasOwnProperty("error"))console.warn(res.data.error);else if(!0===res.success&&res.data.hasOwnProperty("terms")&&res.data.hasOwnProperty("tree")){happyFiles.terms=res.data.terms,happyFiles.tree=res.data.tree;var termElementToDelete=document.getElementById("hf-term-"+openTerm),childWrapper=termElementToDelete.parentNode,parentId=termElementToDelete.dataset.parentId,parentWrapper=document.getElementById("hf-term-"+parentId);if("0"==parentId?hf.init():(document.getElementById("hf-term-"+parentId).querySelector(".term").click(),termElementToDelete.remove(),hf.updateTermCount(),""==childWrapper.innerHTML&&parentWrapper.classList.remove("has-children","open")),hf.refreshAttachmentsBrowser(),hf.listViewRefreshResults(!0),hf.contextMenuListener(),happyFiles.terms.length-2<10){var upgradeWrapper=document.getElementById("hf-upgrade-notification-wrapper");upgradeWrapper&&upgradeWrapper.classList.remove("show")}}}})}))},this.sortCategoriesListener=function(){var sortToggle=document.getElementById("hf-sort-toggle"),sortWrapper=document.getElementById("hf-context-menu-sort-wrapper");sortToggle&&sortWrapper&&(sortToggle.addEventListener("click",(function(e){setTimeout((function(){sortWrapper.classList.toggle("show")}),10)})),document.addEventListener("click",(function(e){sortWrapper.classList.contains("show")&&sortWrapper.classList.remove("show")})),sortWrapper.addEventListener("click",(function(e){sortWrapper.classList.remove("show");var order=!!e.target.dataset.hasOwnProperty("order")&&e.target.dataset.order;order&&jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_sort_categories",order:order,terms:happyFiles.terms,taxonomy:happyFiles.taxonomy},success:function(res){res.success&&res.data.hasOwnProperty("terms")&&res.data.hasOwnProperty("tree")&&(happyFiles.terms=res.data.terms,happyFiles.tree=res.data.tree,HappyFiles.init())}})})))},this.contextMenuListener=function(){var termElements=hf.selectAll(categoriesWrapper,".term"),contextMenu=document.getElementById("hf-context-menu-wrapper");contextMenu&&termElements.length&&(!0!==happyFiles.initialized&&(document.addEventListener("click",(function(e){contextMenu.classList.contains("show")&&contextMenu.classList.remove("show")})),contextMenu.addEventListener("click",(function(e){switch(e.target.classList.value){case"create":document.getElementById("hf-new-category-toggle").click();break;case"rename":document.getElementById("hf-rename-category").click();break;case"delete":document.getElementById("hf-delete-category").click()}}))),termElements.forEach((function(term){term.addEventListener("contextmenu",(function(e){e.preventDefault(),e.target.click(),happyFiles.renaming||"all"===happyFiles.open||"-1"===happyFiles.open?(contextMenu.querySelector(".create").classList.add("disabled"),contextMenu.querySelector(".rename").classList.add("disabled"),contextMenu.querySelector(".delete").classList.add("disabled")):(contextMenu.querySelector(".create").classList.remove("disabled"),contextMenu.querySelector(".rename").classList.remove("disabled"),contextMenu.querySelector(".delete").classList.remove("disabled")),contextMenu.classList.add("show"),contextMenu.style.left=e.clientX+"px";var distToBottom=window.innerHeight-e.clientY,contextMenuHeight=contextMenu.clientHeight;contextMenu.style.top=distToBottom<contextMenuHeight?e.clientY-contextMenuHeight+"px":e.clientY+"px"}))})))},this.paginationLinksListener=function(){document.body.classList.contains("upload-php")&&happyFiles.listViewDisableAjax||jQuery(document).on("click",".tablenav-pages .pagination-links a",(function(e){e.preventDefault(),e.stopPropagation();var url=this.href;jQuery.ajax({method:"GET",url:url,data:{}}).done((function(e){window.history.replaceState({},"",url);var newDocument=jQuery(e).find("#posts-filter")[0];document.getElementById("posts-filter").innerHTML=newDocument.innerHTML,setTimeout((function(){hf.moveAttachmentListener(),hf.contextMenuListener()}),200)}))}))},this.initSidebar=function(){var sidebarWrapper=document.getElementById("hf-sidebar-wrapper");if(sidebarWrapper){var wrapper=document.createElement("div");wrapper.id="hf-wrapper";var wpMediaWrapper=document.getElementById("wp-media-grid");if(wpMediaWrapper||(wpMediaWrapper=!!document.getElementById("posts-filter")&&document.getElementById("posts-filter").parentNode),wpMediaWrapper){wpMediaWrapper.parentNode.insertBefore(wrapper,wpMediaWrapper);var sidebarWidth=parseInt(happyFiles.width)+52;if(wpMediaWrapper.classList.contains("acf-columns-2")){sidebarWrapper.style.marginTop=0,wpMediaWrapper.style.marginLeft="auto";var acfColumn=wpMediaWrapper.querySelector(".acf-column-2");acfColumn&&(sidebarWidth+=acfColumn.offsetWidth)}wpMediaWrapper.style.width="calc(100% - "+sidebarWidth+"px)",document.body.classList.contains("rtl")&&(wpMediaWrapper.style.marginRight=sidebarWidth-20+"px");var setCategoryHeight=function(){document.getElementById("hf-categories-wrapper").style.height=window.innerHeight-240+"px"};setTimeout((function(){setCategoryHeight()}),10),window.addEventListener("resize",setCategoryHeight),wrapper.appendChild(sidebarWrapper),wrapper.appendChild(wpMediaWrapper),sidebarWrapper.classList.add("show"),HappyFiles.init(),document.addEventListener("mousedown",(function(e){"hf-resizable"===e.target.id&&1===e.which&&(sidebarWrapper.classList.add("resizing"),happyFiles.x=e.clientX,happyFiles.resizing=!0)})),document.addEventListener("mousemove",(function(e){if(happyFiles.resizing){e.preventDefault(),e.stopPropagation();var newWidth=e.clientX-sidebarWrapper.getBoundingClientRect().left-17;if(document.body.classList.contains("rtl")&&(newWidth=sidebarWrapper.getBoundingClientRect().right-e.clientX-17),newWidth<210)return;if(newWidth>600)return;sidebarWrapper.style.width=newWidth+"px";var sidebarWidth=parseInt(newWidth)+52;wpMediaWrapper.style.width="calc(100% - "+sidebarWidth+"px)",document.body.classList.contains("rtl")&&(wpMediaWrapper.style.marginRight=sidebarWidth-20+"px")}})),document.addEventListener("mouseup",(function(e){if(happyFiles.resizing){happyFiles.resizing=!1,happyFiles.width=sidebarWrapper.clientWidth;var newWidth=parseInt(happyFiles.width)-30;sidebarWrapper.classList.remove("resizing"),jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_save_sidebar_width",width:newWidth}})}})),!sidebarWrapper.classList.contains("modal")&&happyFiles.width&&happyFiles.width>210&&(sidebarWrapper.style.width=happyFiles.width+"px");var hfToggle=document.getElementById("hf-toggle");hfToggle&&hfToggle.addEventListener("click",(function(e){sidebarWrapper.classList.contains("minimize")?sidebarWrapper.classList.remove("minimize"):sidebarWrapper.classList.add("minimize"),jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_save_category_minimize",minimize:sidebarWrapper.classList.contains("minimize"),taxonomy:happyFiles.taxonomy},success:function(res){}})}))}}},this.initCategories=function(){if(categoriesWrapper)if(categoriesWrapper.classList.add("hf-tree-wrapper"),categoriesWrapper.classList.add("hf-sortable-wrapper"),categoriesWrapper){var items=happyFiles.tree;if(items){var html="";!function addListItems(items,level=0){items.forEach((function(item){var hasChildren=item.hasOwnProperty("children")&&item.children.length,itemClasses=["term-wrapper"];"all"==item.term_id||"-1"==item.term_id?itemClasses.push("ignore"):itemClasses.push("draggable"),hasChildren&&itemClasses.push("has-children"),0!=item.count?html+='<li id="hf-term-'+item.term_id+'" class="'+itemClasses.join(" ")+'" data-term-id="'+item.term_id+'" data-term-slug="'+item.slug+'" data-parent-id="'+item.parent+'"  data-level="'+level+'" data-count="'+item.count+'">':html+='<li id="hf-term-'+item.term_id+'" class="'+itemClasses.join(" ")+'" data-term-id="'+item.term_id+'" data-term-slug="'+item.slug+'" data-parent-id="'+item.parent+'"  data-level="'+level+'">',html+='<div class="icon"></div>',html+='<div class="term">'+item.name+"</div>","all"!=item.term_id&&"-1"!=item.term_id&&(hasChildren?(html+='<ul class="hf-sortable-wrapper">',addListItems(item.children,level++),html+="</ul>"):html+='<ul class="hf-sortable-wrapper"></ul>'),html+="</li>"}))}(items),categoriesWrapper.innerHTML=html}else console.warn("HappyFilesTree Error: No settings.items array provided for wrapper "+selector)}else console.warn("HappyFilesTree Error: Wrapper not found "+selector)},this.initSortable=function(){for(var uploaderWindow=document.querySelector(".uploader-window"),nestedSortables=hfWrapper.querySelectorAll(".hf-sortable-wrapper"),i=0;i<nestedSortables.length;i++)new Sortable(nestedSortables[i],{animation:20,group:"nested",fallbackOnBody:!0,swapThreshold:.5,delay:100,delayOnTouchOnly:!0,handle:".term",filter:".ignore",draggable:".draggable",ghostClass:"hf-sortable-ghost",chosenClass:"hf-sortable-chosen",dragClass:"hf-sortable-drag",onStart:function(event){(uploaderWindow=document.querySelector(".uploader-window"))&&uploaderWindow.classList.add("hide")},onEnd:function(e){uploaderWindow&&setTimeout((function(){uploaderWindow.classList.remove("hide")}),200),function openParentListItem(node){node.classList.contains("hf-tree-wrapper")||(node.parentNode.classList.contains("term-wrapper")&&(node.parentNode.classList.add("has-children"),node.parentNode.classList.add("open")),openParentListItem(node.parentNode))}(e.to),function removeHasChildrenListItem(node){node.classList.contains("hf-tree-wrapper")||(node.classList.contains("hf-sortable-wrapper")&&(node.innerHTML||node.parentNode.classList.remove("has-children")),removeHasChildrenListItem(node.parentNode))}(e.from);for(var terms=hf.selectAll(categoriesWrapper,".draggable"),termIds=[],i=0;i<terms.length;i++){var termId=terms[i].querySelector(".term").parentNode.dataset.termId;termId&&termIds.push(termId)}jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_update_term_position",termIds:termIds},success:function(res){!1===res.success&&res.data.error&&console.warn(res.data.error)}}),termId=e.item.dataset.termId;var parentId=e.item.parentNode.parentNode.dataset.termId;jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_update_term_parent",parentId:parentId,termId:termId,taxonomy:happyFiles.taxonomy},success:function(res){!res.success&&res.data.error&&console.warn(res.data.error)}})}})},this.selectCategoryListener=function(){hf.selectAll(categoriesWrapper,".icon").forEach((function(folderIcon){folderIcon.addEventListener("click",(function(e){var parentWrapper=folderIcon.parentNode;parentWrapper.classList.contains("has-children")&&parentWrapper.classList.toggle("open")}))}));var termElements=hf.selectAll(categoriesWrapper,".term");termElements.forEach((function(termElement){termElement.addEventListener("click",(function(e){var termId=!!termElement.parentNode.dataset.termId&&termElement.parentNode.dataset.termId;if(termId||console.warn("No termId found (selectCategoryListener)"),hfWrapper=document.getElementById("hf-sidebar-wrapper"),happyFiles.open!=termId||!happyFiles.initialized){jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_save_category_state",termId:termId,taxonomy:happyFiles.taxonomy},success:function(res){(document.body.classList.contains("edit-php")||document.body.classList.contains("upload-php"))&&document.getElementById("posts-filter")&&happyFiles.initialized&&happyFiles.listViewDisableAjax&&(location.href=happyFiles.uploadUrl),happyFiles.initialized=!0}});var selectEl=!!hfWrapper.nextElementSibling&&hfWrapper.nextElementSibling.querySelector("#"+happyFiles.filterId);if(!selectEl){var activeModal=jQuery('div[id^="__wp-uploader-id-"].supports-drag-drop:visible');selectEl=jQuery(activeModal).find("#"+happyFiles.filterId)}termId&&selectEl&&jQuery(selectEl).val(termId).change(),happyFiles.initialized&&setTimeout((function(){hf.listViewRefreshResults(!0)}),400)}happyFiles.open=termId,termElements.forEach((function(term){term.parentNode.classList.remove("active")})),termElement.parentNode.classList.add("active");var termActionsWrapper=document.getElementById("hf-term-action-wrapper");if(termActionsWrapper&&!happyFiles.renaming){var termCoordinates=termElement.getBoundingClientRect();termActionsWrapper.style.top=termCoordinates.top+"px",termActionsWrapper.style.left=termCoordinates.right-2+"px",document.body.classList.contains("rtl")&&(termActionsWrapper.style.top=termCoordinates.top+"px",termActionsWrapper.style.left=termCoordinates.left-80+"px")}}))}))},this.openCurrentCategory=function(){var openId=happyFiles.open&&document.getElementById("hf-term-"+happyFiles.open)?happyFiles.open:"all",openCategory=function(termId,isParent){var openTermWrapper=categoriesWrapper.querySelector('[data-term-id="'+termId+'"]');if(openTermWrapper){isParent?openTermWrapper.classList.add("open"):openTermWrapper.classList.add("active");var parentTermId=openTermWrapper.dataset.parentId;parentTermId&&0!=parentTermId&&openCategory(parentTermId,!0)}};openCategory(openId,!1);var activeTermWrapper=categoriesWrapper.querySelector(".active"),activeTerm=activeTermWrapper.querySelector(".term");activeTermWrapper&&activeTerm&&(activeTermWrapper.classList.contains("has-children")&&activeTermWrapper.classList.add("open"),activeTerm.click())},this.listViewRefreshResults=function(resetPaged=!1){var formFilter=document.getElementById("posts-filter");if(formFilter&&hfWrapper){for(var url=document.body.classList.contains("edit-php")?happyFiles.editUrl:happyFiles.uploadUrl,formFilterData=jQuery(formFilter).serializeArray(),activeFilterCount=0,i=0;formFilterData.length>i;i++){var filter=formFilterData[i];-1===["action","action2","_ajax_nonce","_wpnonce","_wp_http_referer"].indexOf(filter.name)&&(filter.value.length&&"0"!=filter.value&&("post_status"===filter.name&&"all"===filter.value||("paged"!=filter.name||"1"!=filter.value&&!resetPaged?filter.name!==happyFiles.taxonomy&&(url+=0===activeFilterCount?"?"+filter.name+"="+filter.value:"&"+filter.name+"="+filter.value,activeFilterCount++):delete formFilterData[i])))}jQuery.get({url:url,dataType:"html"}).done((function(e){window.history.replaceState({},"",url);var newDocument=jQuery(e).find("#posts-filter")[0];document.getElementById("posts-filter").innerHTML=newDocument.innerHTML,hf.init(!1),hf.updateTermCount(),window.hasOwnProperty("inlineEditPost")&&window.inlineEditPost.init()}))}},this.showCategoriesListener=function(){var categoryWrapper=document.getElementById("hf-context-menu-categories-wrapper");categoryWrapper&&!happyFiles.initialized&&(document.addEventListener("click",(function(e){categoryWrapper.classList.remove("show"),categoryWrapper.innerText=""})),window.addEventListener("contextmenu",(function(e){var itemId=!(!e.target.classList.contains("attachment")||!e.target.dataset.hasOwnProperty("id"))&&e.target.dataset.id;if(!itemId){if("A"===e.target.nodeName)return;var tableRowId=jQuery(e.target).closest("tr").attr("id");if(!tableRowId)return;itemId=tableRowId.replace(/^\D+/g,"")}itemId&&"-1"!=happyFiles.open&&(categoryWrapper.innerText="",e.preventDefault(),jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_get_item_categories",itemId:itemId,postType:happyFiles.postType,open:happyFiles.open,taxonomy:happyFiles.taxonomy},success:function(res){!1!==res.data&&(res.data.forEach((function(term){var categoryItem=document.createElement("li");categoryItem.innerText=term.name+" ("+term.count+")",categoryItem.dataset.termId=term.term_id,categoryItem.style.paddingLeft=15*term.level+"px",term.term_id==happyFiles.open&&categoryItem.classList.add("disabled"),categoryItem.addEventListener("click",(function(e){var termId=e.target.dataset.termId;termId!=happyFiles.open&&(document.querySelector("#hf-term-"+termId+" .term").click(),categoryWrapper.classList.remove("show"),hf.openCurrentCategory())})),categoryWrapper.appendChild(categoryItem)})),categoryWrapper.style.top=e.clientY+"px",categoryWrapper.style.left=e.clientX+"px",categoryWrapper.classList.add("show"))}}))})))},this.moveAttachmentListener=function(){var draggingWrapper=document.createElement("div");draggingWrapper.id="hf-dragging-wrapper",draggingWrapper.dataset.itemId="",draggingWrapper.dataset.termId="",document.body.append(draggingWrapper),window.addEventListener("mousemove",(function(e){if(draggingWrapper.dataset.itemId){draggingWrapper.classList.add("show"),draggingWrapper.style.left=e.clientX+5+"px",draggingWrapper.style.top=e.clientY+5+"px";var itemCount=draggingWrapper.dataset.itemId.split(",").length,draggingWrapperText=happyFiles.l10n.move+" "+itemCount+" ";draggingWrapperText+=1===itemCount?happyFiles.postTypeSingular:happyFiles.postTypePlural,draggingWrapper.innerText=draggingWrapperText}})),termElements.forEach((function(termElement){var termWrapper=termElement.parentNode;termElement.addEventListener("mouseenter",(function(e){draggingWrapper.dataset.itemId&&(termWrapper.classList.add("droppable"),termWrapper.classList.contains("has-children")&&termWrapper.classList.add("open"),draggingWrapper.innerText="termId: "+termWrapper.dataset.termId,draggingWrapper.dataset.termId=termWrapper.dataset.termId)}))})),termElements.forEach((function(termElement){var termWrapper=termElement.parentNode;termElement.addEventListener("mouseleave",(function(e){draggingWrapper.dataset.itemId&&(termWrapper.classList.remove("droppable"),draggingWrapper.dataset.termId="")}))})),jQuery("#the-list").delegate("tr","mousedown",(function(event){if(1===event.which&&("IMG"===event.target.nodeName||event.target.classList.contains("check-column"))){event.preventDefault();var checkboxName="attachment"===happyFiles.postType?"media":"post",selectedAttachments=jQuery('#the-list input[name="'+checkboxName+'[]"]:checked');if(selectedAttachments.length){for(var selectedIds=[],i=0;i<selectedAttachments.length;i++)selectedIds.push(selectedAttachments[i].value);selectedIds.length&&(draggingWrapper.dataset.itemId=selectedIds)}else{var attachementId=jQuery(this).attr("id").replace("post-","");attachementId&&(draggingWrapper.dataset.itemId=attachementId)}}})),window.addEventListener("mousedown",(function(event){if(1===event.which&&event.target.classList.contains("attachment")&&event.target.dataset.id){event.preventDefault();var selectedIds=[];event.target.parentNode.classList.contains("attachments")&&hf.selectAll(event.target.parentNode,".selected").forEach((function(selectedAttachment){selectedAttachment.dataset.id&&selectedIds.push(selectedAttachment.dataset.id)}));var draggingItems=event.target.dataset.id;selectedIds.length&&(draggingItems=selectedIds),draggingWrapper.dataset.itemId=draggingItems}})),window.addEventListener("mouseup",(function(event){draggingWrapper.classList.remove("show");var itemId=draggingWrapper.dataset.itemId,termId=draggingWrapper.dataset.termId;itemId&&termId&&jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_update_attachment_terms",itemId:itemId,termId:termId,openId:happyFiles.open,taxonomy:happyFiles.taxonomy,postType:happyFiles.postType},success:function(res){!1===res.success&&res.data.hasOwnProperty("error")&&console.warn("Error: "+res.data.error),!0===res.success&&res.data.hasOwnProperty("terms")&&(happyFiles.terms=res.data.terms,hf.refreshAttachmentsBrowser(),hf.listViewRefreshResults(),hf.updateTermCount());var mediaFrame=document.querySelector(".media-frame");if(mediaFrame&&mediaFrame.classList.contains("mode-select")){var modeSelectToggleButton=document.querySelector(".select-mode-toggle-button");modeSelectToggleButton&&modeSelectToggleButton.click()}}}),termElements.forEach((function(termElement){termElement.parentNode.classList.remove("droppable"),draggingWrapper.dataset.itemId&&(draggingWrapper.dataset.itemId="",draggingWrapper.dataset.termId="")}))}))},this.updateTermCount=function(){happyFiles.terms.forEach((function(term){termElements.forEach((function(termElement){var termWrapper=termElement.parentNode;termWrapper.dataset.termId==term.term_id&&(0!=term.count?termWrapper.dataset.count=term.count:delete termWrapper.dataset.count)}))}))},this.refreshAttachmentsBrowser=function(){happyFiles.attachmentsBrowser&&happyFiles.attachmentsBrowser.collection.props.set({ignore:+new Date}),hf.updateTermCount()},this.init=function(initCategories=!0){hfWrapper=document.getElementById("hf-sidebar-wrapper"),categoriesWrapper=document.querySelector(selector),happyFiles.minimize&&hfWrapper.classList.add("minimize"),initCategories&&(hf.initCategories(),happyFiles.canEdit&&hf.initSortable()),hf.selectAll(categoriesWrapper,".term-wrapper"),termElements=hf.selectAll(categoriesWrapper,".term"),happyFiles.canEdit&&(hf.moveAttachmentListener(),hf.contextMenuListener()),hf.showCategoriesListener(),hf.selectCategoryListener(),hf.openCurrentCategory(),!0!==happyFiles.initialized&&(hf.paginationLinksListener(),happyFiles.canEdit&&(hf.newCategoryListener(),hf.renameCategoryListener(),hf.deleteCategoryListener(),hf.sortCategoriesListener()))}}}();var HappyFiles=new HF("#hf-categories-wrapper");jQuery(document).ready((function(){document.body.classList.contains("upload-php")&&(happyFiles.debug&&console.warn("library.js"),HappyFiles.initSidebar())})),jQuery(document).ready((function(){document.body.classList.contains("wp-admin")&&document.body.classList.contains("upload-php")||void 0!==wp.media&&(happyFiles.debug&&console.warn("modal.js"),wp.media.view.Modal.prototype.on("prepare",(function(e){HappyFiles.initFilter(),HappyFiles.onUpload()})),wp.media.view.Modal.prototype.on("open",(function(e){var happyFilesWrapper=document.getElementById("hf-sidebar-wrapper"),initModal=function(html){var activeModal=jQuery('div[id^="__wp-uploader-id-"].supports-drag-drop:visible'),mediaFrameWrapper=document.querySelector("#"+activeModal.attr("id")+" .media-frame");if(!jQuery(activeModal).hasClass("image-details")){jQuery(html).appendTo("#"+activeModal.attr("id")+" .media-menu"),mediaFrameWrapper.classList.add("hf-view"),mediaFrameWrapper.classList.contains("hide-menu")&&mediaFrameWrapper.classList.remove("hide-menu"),HappyFiles.init(),happyFilesWrapper=document.getElementById("hf-sidebar-wrapper");var selectEl=jQuery(activeModal).find("#"+happyFiles.filterId);selectEl&&happyFilesWrapper&&happyFiles.open&&jQuery(selectEl).val(happyFiles.open).change(),happyFilesWrapper.classList.add("modal"),HappyFiles.refreshAttachmentsBrowser(),jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_get_category_terms_and_tree",postType:happyFiles.postType,taxonomy:happyFiles.taxonomy},success:function(res){res.data.hasOwnProperty("terms")&&(happyFiles.terms=res.data.terms),res.data.hasOwnProperty("tree")&&(happyFiles.tree=res.data.tree),HappyFiles.init(),HappyFiles.openCurrentCategory()}})}};if(happyFilesWrapper)var counter=0,modelInterval=setInterval((function(){var activeModal=jQuery('div[id^="__wp-uploader-id-"].supports-drag-drop:visible'),mediaFrameWrapper=document.querySelector("#"+activeModal.attr("id")+" .media-frame");activeModal&&mediaFrameWrapper?(clearInterval(modelInterval),initModal(happyFilesWrapper)):++counter>=10&&clearInterval(modelInterval)}),100);else jQuery.ajax({method:"POST",url:happyFiles.ajaxUrl,data:{action:"happyfiles_get_categories_html"},success:function(res){res.data.hasOwnProperty("html")&&initModal(res.data.html)}})})),wp.media.view.Modal.prototype.on("close",(function(e){var happyFilesWrapper=document.getElementById("hf-sidebar-wrapper");happyFilesWrapper&&(jQuery(happyFilesWrapper).appendTo("body"),jQuery(happyFilesWrapper).removeClass("modal"))})))})),window.addEventListener("DOMContentLoaded",(function(event){document.body.classList.contains("media-new-php")&&(happyFiles.debug&&console.warn("media-new.js"),uploader&&uploader.bind("BeforeUpload",(function(up,file){var termId=jQuery("#hf-category-upload").val();termId&&(up.settings.multipart_params.hfTermId=parseInt(termId))})))}));