<?php
/**
 * Podcast player toolkit page
 *
 * @package Podcast Player
 * @since 3.3.0
 */

use Podcast_Player\Helper\Functions\Getters as Get_Fn;
use Podcast_Player\Helper\Functions\Validation as Validation_Fn;

$feed_index = Get_Fn::get_feed_index();
$keep_old   = Get_Fn::get_plugin_option( 'keep_old' );
$sticky_pl  = get_option( 'pp_sticky_player_feed' );
if ( ! $sticky_pl ) {
	$sticky_pl = array();
} elseif ( ! is_array( $sticky_pl ) ) {
	$sticky_pl = array(
		'url' => $sticky_pl,
	);
}
?>

<div class="pp-toolkit-page">
	<div class="pp-toolkit-wrapper">
		<?php require PP_PRO_DIR . '/admin/templates/toolkit/feed-update.php'; ?>
		<?php require PP_PRO_DIR . '/admin/templates/toolkit/feed-import.php'; ?>
		<?php require PP_PRO_DIR . '/admin/templates/toolkit/feed-editor.php'; ?>
		<?php require PP_PRO_DIR . '/admin/templates/toolkit/sticky-player.php'; ?>
		<?php require PP_PRO_DIR . '/admin/templates/toolkit/bulk-audio.php'; ?>
	</div>
</div>
