<?php
/**
 * Podcast player toolkit page
 *
 * @package Podcast Player
 * @since 4.3.0
 */

use PP_Pro\Admin\Templates\Toolkit\Helper\Getters as Toolkit_Fn;
use PP_Pro\Helper\Functions\Getters as PP_Get_Fn;

$bulk_player   = get_option( 'pp_bulk_player' );
$bulk_player   = $bulk_player ? $bulk_player : array();
$bulk_where    = isset( $bulk_player['loc'] ) ? esc_html( $bulk_player['loc'] ) : '';
$bulk_source   = isset( $bulk_player['audio'] ) ? esc_html( $bulk_player['audio'] ) : '';
$bulk_field    = isset( $bulk_player['cf'] ) ? esc_html( $bulk_player['cf'] ) : '';
$bulk_style    = isset( $bulk_player['style'] ) ? esc_html( $bulk_player['style'] ) : '';
$bulk_accent   = isset( $bulk_player['accent'] ) ? sanitize_hex_color( $bulk_player['accent'] ) : '';
$bulk_bg       = isset( $bulk_player['bg'] ) ? sanitize_hex_color( $bulk_player['bg'] ) : '';
$bulk_ss       = isset( $bulk_player['share'] ) ? esc_html( $bulk_player['share'] ) : '';
$bulk_dl       = isset( $bulk_player['dl'] ) ? esc_html( $bulk_player['dl'] ) : '';
$bulk_title    = isset( $bulk_player['htitle'] ) ? esc_html( $bulk_player['htitle'] ) : '';
$bulk_featured = isset( $bulk_player['hfeatured'] ) ? esc_html( $bulk_player['hfeatured'] ) : '';
$is_hide       = 'cf' !== $bulk_source ? true : false;
$post_where    = array(
	''       => esc_html__( 'After Post Content', 'podcast-player' ),
	'before' => esc_html__( 'Before Post Content', 'podcast-player' ),
);
$post_source   = array(
	''        => esc_html__( 'Select a source', 'podcast-player' ),
	'blubrry' => esc_html__( 'Blubrry Powerpress', 'podcast-player' ),
	'ssp'     => esc_html__( 'Seriously Simple Podcasting', 'podcast-player' ),
	'cf'      => esc_html__( 'Custom Field', 'podcast-player' ),
);
$post_style    = array(
	''       => esc_html__( 'Default Player', 'podcast-player' ),
	'modern' => esc_html__( 'Modern Player', 'podcast-player' ),
	'legacy' => esc_html__( 'Catalogue (Legacy) Player', 'podcast-player' ),
	'lv1'    => esc_html__( 'List - Normal', 'pp-pro' ),
	'lv2'    => esc_html__( 'List - small', 'pp-pro' ),
	'lv3'    => esc_html__( 'List - Minimal', 'pp-pro' ),
	'lv4'    => esc_html__( 'List - Individual', 'pp-pro' ),
);
?>

<h3 class="pp-toolkit-title">Bulk Audio Player</h3>
<div class="pp-toolkit-content">
	<div class="pp-opt-desc" style="margin-bottom: 20px;">
		<div class="pp-notice-info"><?php esc_html_e( 'This tool will bulk display single audio players at the beginning or end of multiple posts.', 'podcast-player' ); ?></div>
		<div class="pp-podcast-bulk">
			<div class="bulk-source ppa-bulk-settings">
				<?php
				Toolkit_Fn::label( 'ppa-bulk-source', esc_html__( 'From where to fetch audio URL?', 'podcast-player' ), true );
				Toolkit_Fn::select( 'ppa-bulk-source', $post_source, $bulk_source, array(), true );
				?>
			</div>
			<div class="bulk-cf ppa-bulk-settings" style="<?php echo $is_hide ? 'display: none' : ''; ?>">
				<?php Toolkit_Fn::label( 'ppa-bulk-cf', esc_html__( 'Enter Custom Field', 'podcast-player' ), true ); ?>
				<input class="ppa-bulk-cf" type="text" placeholder="Enter Custom Field" value="<?php echo $bulk_field; ?>">
			</div>
			<div class="bulk-where ppa-bulk-settings">
				<?php
				Toolkit_Fn::label( 'ppa-bulk-where', esc_html__( 'Where to display the player?', 'podcast-player' ), true );
				Toolkit_Fn::select( 'ppa-bulk-where', $post_where, $bulk_where, array(), true );
				?>
			</div>
			<div class="bulk-style ppa-bulk-settings">
				<?php
				Toolkit_Fn::label( 'ppa-bulk-style', esc_html__( 'Choose Player Display Style', 'podcast-player' ), true );
				Toolkit_Fn::select( 'ppa-bulk-style', $post_style, $bulk_style, array(), true );
				?>
			</div>
			<div class="pp-sticky-settings">
				<table class="form-table" role="presentation">
					<tbody>
						<tr>
							<th scope="row" class="pp-toolkit-op-title">
								<span class="pp-opt-title">Player Background Color.</span>
								<span class="pp-opt-desc">Setup sticky player's background color.</span>
							</th>
							<td class="pp-toolkit-op-input"><input class="pp-bg-color pp-color-picker" type="text" title="Setup Background Color" value="<?php echo $bulk_bg; ?>"></td>
						</tr>
						<tr>
							<th scope="row" class="pp-toolkit-op-title">
								<span class="pp-opt-title">Player Acccent Color.</span>
								<span class="pp-opt-desc">Setup sticky player's accent color (Button, links etc.)</span>
							</th>
							<td class="pp-toolkit-op-input"><input class="pp-accent-color pp-color-picker" type="text" title="Setup Accent Color" value="<?php echo $bulk_accent; ?>"></td>
						</tr>
						<tr>
							<th scope="row" class="pp-toolkit-op-title">
								<span class="pp-opt-desc">Hide Social Sharing Options</span>
							</th>
							<td class="pp-toolkit-op-input">
								<label class="switch">
								<input class="pp-social-sharing" type="checkbox" title="Hide Social Sharing" value="yes" <?php checked( $bulk_ss, 'yes' ); ?> >
								<div class="slider"></div>
								</label>
							</td>
						</tr>
						<tr>
							<th scope="row" class="pp-toolkit-op-title">
								<span class="pp-opt-desc">Hide Episode Download Option</span>
							</th>
							<td class="pp-toolkit-op-input">
								<label class="switch">
								<input class="pp-download" type="checkbox" title="Hide Episode Download" value="yes" <?php checked( $bulk_dl, 'yes' ); ?> >
								<div class="slider"></div>
								</label>
							</td>
						</tr>
						<tr>
							<th scope="row" class="pp-toolkit-op-title">
								<span class="pp-opt-desc">Hide Episode Title</span>
							</th>
							<td class="pp-toolkit-op-input">
								<label class="switch">
								<input class="pp-title" type="checkbox" title="Hide Episode Title" value="yes" <?php checked( $bulk_title, 'yes' ); ?> >
								<div class="slider"></div>
								</label>
							</td>
						</tr>
						<tr>
							<th scope="row" class="pp-toolkit-op-title">
								<span class="pp-opt-desc">Hide Episode Featured Image</span>
							</th>
							<td class="pp-toolkit-op-input">
								<label class="switch">
								<input class="pp-featured" type="checkbox" title="Hide Episode Featured Image" value="yes" <?php checked( $bulk_featured, 'yes' ); ?> >
								<div class="slider"></div>
								</label>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<button class="pp-toolkit-buttons pp-add-bulk button">
				<span class="dashicons dashicons-plus-alt2"></span>
				<span class="pp-toolkit-btn-text">Add Bulk Players</span>
			</button>
			<button class="pp-toolkit-buttons pp-remove-bulk button">
				<span class="dashicons dashicons-trash"></span>
				<span class="pp-toolkit-btn-text">Remove Bulk Players</span>
			</button>
			<div class="pp-toolkit-feedback">
				<span class="dashicons dashicons-update"></span>
				<span class="dashicons dashicons-no"></span>
				<span class="dashicons dashicons-yes"></span>
				<span class="pp-feedback"></span>
			</div>
		</div>
	</div>
</div>
