<?php
/**
 * Podcast player toolkit page
 *
 * @package Podcast Player
 * @since 3.3.0
 */

use Podcast_Player\Helper\Functions\Validation as Validation_Fn;

$sticky_url = isset( $sticky_pl['url'] ) ? esc_attr( $sticky_pl['url'] ) : '';
$is_hide    = ( $fmethod && 'feed' !== $fmethod ) ? true : false;
?>

<div class="pp-fetch-feed" style="<?php echo $is_hide ? 'display: none' : ''; ?>">
	<span style="margin-bottom: 5px;display: block;"><?php esc_html_e( 'Add Your Podcast', 'podcast-player' ); ?></span>
	<div class="pp-podcast-feed">
		<?php if ( $feed_index && is_array( $feed_index ) ) : ?>
			<?php $feed_index[''] = esc_html__( 'Select a Podcast to show in bottom sticky player', 'podcast-player' ); ?>
			<select id="pp-feed-index" name="pp-feed-index" class="select-pp-feed-index">
				<?php
				foreach ( $feed_index as $key => $label ) {
					if ( is_array( $label ) ) {
						$label = isset( $label['title'] ) ? $label['title'] : '';
					}
					echo '<option value="' . esc_attr( $key ) . '" ' . selected( $key, $sticky_url, false ) . '>' . esc_html( $label ) . '</option>';
				}
				?>
			</select>
			<h4 class="pp-index-optional" style="padding: 0 20px;"><?php esc_html_e( 'OR', 'podcast-player' ); ?></h4>
		<?php endif; ?>
		<?php
		$sticky_valid_url = '';
		if ( Validation_Fn::is_valid_url( $sticky_url ) ) {
			$sticky_valid_url = esc_attr( esc_url( $sticky_url ) );
		}
		?>
		<input class="pp-toolkit-url" type="url" placeholder="Enter Your Podcast Feed URL" title="Feed Editor" value="<?php echo $sticky_valid_url; ?>">
	</div>
</div>
