<?php
/**
 * Podcast player toolkit page
 *
 * @package Podcast Player
 * @since 3.3.0
 */

use PP_Pro\Admin\Templates\Toolkit\Helper\Getters as Toolkit_Fn;
use PP_Pro\Helper\Functions\Getters as PP_Get_Fn;

$sticky_ptype = isset( $sticky_pl['posttype'] ) ? esc_html( $sticky_pl['posttype'] ) : '';
$sticky_taxon = isset( $sticky_pl['taxonomies'] ) ? esc_html( $sticky_pl['taxonomies'] ) : '';
$sticky_terms = isset( $sticky_pl['terms'] ) ? array_map( 'esc_html', $sticky_pl['terms'] ) : array();
$is_hide      = ( ! $fmethod || 'post' !== $fmethod ) ? true : false;
?>
<div class="pp-fetch-posts" style="<?php echo $is_hide ? 'display: none' : ''; ?>">
	<span style="margin-bottom: 5px;display: block;"><?php esc_html_e( 'Fetch Podcast Episodes', 'podcast-player' ); ?></span>
	<div class="pp-podcast-posts">
		<div class="ppa-post-type ppa-input-even">
			<?php
			Toolkit_Fn::label( 'ppa-posttype', esc_html__( 'Select Post Type', 'podcast-player' ), true );
			Toolkit_Fn::select( 'ppa-posttype', PP_Get_Fn::get_post_types(), $sticky_ptype, array(), true );
			?>
		</div>
		<div class="ppa-taxonomy ppa-input-even">
			<?php Toolkit_Fn::taxonomies_select( $sticky_ptype, $sticky_taxon ); ?>
		</div>
		<div class="ppa-terms" style="<?php echo $sticky_taxon ? '' : 'display: none'; ?>">
			<?php Toolkit_Fn::terms_checklist( $sticky_taxon, $sticky_terms ); ?>
		</div>
	</div>
</div>
