<?php
/**
 * Podcast player utility functions.
 *
 * @link       https://www.vedathemes.com
 * @since      3.3.0
 *
 * @package    Podcast_Player
 * @subpackage Podcast_Player/Helper
 */

namespace PP_Pro\Helper\Functions;

/**
 * Podcast player utility functions.
 *
 * @package    Podcast_Player
 * @subpackage Podcast_Player/Helper
 * @author     vedathemes <contact@vedathemes.com>
 */
class Gfonts {

	/**
	 * Constructor method.
	 *
	 * @since  3.3.0
	 */
	public function __construct() {}

	/**
	 * Get complete google fonts array.
	 *
	 * @param array $fonts Google fonts array.
	 *
	 * @since 2.6.0
	 */
	public static function get_list( $fonts = array() ) {

		return array_merge(
			$fonts,
			array(
				'roboto'                     => 'Roboto',
				'opensans'                   => 'Open Sans',
				'notosansjp'                 => 'Noto Sans JP',
				'lato'                       => 'Lato',
				'montserrat'                 => 'Montserrat',
				'robotocondensed'            => 'Roboto Condensed',
				'sourcesanspro'              => 'Source Sans Pro',
				'oswald'                     => 'Oswald',
				'poppins'                    => 'Poppins',
				'robotomono'                 => 'Roboto Mono',
				'raleway'                    => 'Raleway',
				'notosans'                   => 'Noto Sans',
				'quicksand'                  => 'Quicksand',
				'ptsans'                     => 'PT Sans',
				'ubuntu'                     => 'Ubuntu',
				'merriweather'               => 'Merriweather',
				'robotoslab'                 => 'Roboto Slab',
				'sigmarone'                  => 'Sigmar One',
				'limelight'                  => 'Limelight',
				'playfairdisplay'            => 'Playfair Display',
				'nunito'                     => 'Nunito',
				'opensanscondensed'          => 'Open Sans Condensed',
				'notosanskr'                 => 'Noto Sans KR',
				'rubik'                      => 'Rubik',
				'lora'                       => 'Lora',
				'mukta'                      => 'Mukta',
				'notosanstc'                 => 'Noto Sans TC',
				'worksans'                   => 'Work Sans',
				'nunitosans'                 => 'Nunito Sans',
				'ptserif'                    => 'PT Serif',
				'nanumgothic'                => 'Nanum Gothic',
				'firasans'                   => 'Fira Sans',
				'hindsiliguri'               => 'Hind Siliguri',
				'titilliumweb'               => 'Titillium Web',
				'inter'                      => 'Inter',
				'notoserif'                  => 'Noto Serif',
				'karla'                      => 'Karla',
				'barlow'                     => 'Barlow',
				'heebo'                      => 'Heebo',
				'inconsolata'                => 'Inconsolata',
				'oxygen'                     => 'Oxygen',
				'bebasneue'                  => 'Bebas Neue',
				'yanonekaffeesatz'           => 'Yanone Kaffeesatz',
				'sourcecodepro'              => 'Source Code Pro',
				'josefinsans'                => 'Josefin Sans',
				'ptsansnarrow'               => 'PT Sans Narrow',
				'arimo'                      => 'Arimo',
				'dosis'                      => 'Dosis',
				'anton'                      => 'Anton',
				'mulish'                     => 'Mulish',
				'librefranklin'              => 'Libre Franklin',
				'librebaskerville'           => 'Libre Baskerville',
				'hind'                       => 'Hind',
				'cabin'                      => 'Cabin',
				'ibmplexsans'                => 'IBM Plex Sans',
				'bitter'                     => 'Bitter',
				'notosanssc'                 => 'Noto Sans SC',
				'padauk'                     => 'Padauk',
				'teko'                       => 'Teko',
				'crimsontext'                => 'Crimson Text',
				'dancingscript'              => 'Dancing Script',
				'lobster'                    => 'Lobster',
				'abel'                       => 'Abel',
				'varelaround'                => 'Varela Round',
				'fjallaone'                  => 'Fjalla One',
				'barlowcondensed'            => 'Barlow Condensed',
				'cairo'                      => 'Cairo',
				'prompt'                     => 'Prompt',
				'sourceserifpro'             => 'Source Serif Pro',
				'arvo'                       => 'Arvo',
				'comfortaa'                  => 'Comfortaa',
				'dmsans'                     => 'DM Sans',
				'ebgaramond'                 => 'EB Garamond',
				'notosanshk'                 => 'Noto Sans HK',
				'kanit'                      => 'Kanit',
				'hindmadurai'                => 'Hind Madurai',
				'merriweathersans'           => 'Merriweather Sans',
				'zillaslab'                  => 'Zilla Slab',
				'pacifico'                   => 'Pacifico',
				'indieflower'                => 'Indie Flower',
				'exo2'                       => 'Exo 2',
				'shadowsintolight'           => 'Shadows Into Light',
				'overpass'                   => 'Overpass',
				'asap'                       => 'Asap',
				'archivonarrow'              => 'Archivo Narrow',
				'slabo27px'                  => 'Slabo 27px',
				'questrial'                  => 'Questrial',
				'abrilfatface'               => 'Abril Fatface',
				'cormorantgaramond'          => 'Cormorant Garamond',
				'assistant'                  => 'Assistant',
				'architectsdaughter'         => 'Architects Daughter',
				'notoserifjp'                => 'Noto Serif JP',
				'firasanscondensed'          => 'Fira Sans Condensed',
				'mavenpro'                   => 'Maven Pro',
				'exo'                        => 'Exo',
				'rajdhani'                   => 'Rajdhani',
				'anticslab'                  => 'Antic Slab',
				'caveat'                     => 'Caveat',
				'martel'                     => 'Martel',
				'domine'                     => 'Domine',
				'breeserif'                  => 'Bree Serif',
				'play'                       => 'Play',
				'ibmplexserif'               => 'IBM Plex Serif',
				'amaticsc'                   => 'Amatic SC',
				'catamaran'                  => 'Catamaran',
				'tajawal'                    => 'Tajawal',
				'balsamiqsans'               => 'Balsamiq Sans',
				'acme'                       => 'Acme',
				'archivo'                    => 'Archivo',
				'odibeesans'                 => 'Odibee Sans',
				'nanummyeongjo'              => 'Nanum Myeongjo',
				'righteous'                  => 'Righteous',
				'signika'                    => 'Signika',
				'fredokaone'                 => 'Fredoka One',
				'alfaslabone'                => 'Alfa Slab One',
				'abeezee'                    => 'ABeeZee',
				'ptsanscaption'              => 'PT Sans Caption',
				'manrope'                    => 'Manrope',
				'satisfy'                    => 'Satisfy',
				'cinzel'                     => 'Cinzel',
				'patrickhand'                => 'Patrick Hand',
				'squadaone'                  => 'Squada One',
				'creteround'                 => 'Crete Round',
				'permanentmarker'            => 'Permanent Marker',
				'barlowsemicondensed'        => 'Barlow Semi Condensed',
				'alegreyasans'               => 'Alegreya Sans',
				'vollkorn'                   => 'Vollkorn',
				'sarabun'                    => 'Sarabun',
				'amiri'                      => 'Amiri',
				'courgette'                  => 'Courgette',
				'kalam'                      => 'Kalam',
				'patuaone'                   => 'Patua One',
				'mplusrounded1c'             => 'M PLUS Rounded 1c',
				'spartan'                    => 'Spartan',
				'ubuntucondensed'            => 'Ubuntu Condensed',
				'alegreya'                   => 'Alegreya',
				'frankruhllibre'             => 'Frank Ruhl Libre',
				'tinos'                      => 'Tinos',
				'kaushanscript'              => 'Kaushan Script',
				'monda'                      => 'Monda',
				'mplus1p'                    => 'M PLUS 1p',
				'redhatdisplay'              => 'Red Hat Display',
				'pattaya'                    => 'Pattaya',
				'yantramanav'                => 'Yantramanav',
				'almarai'                    => 'Almarai',
				'lobstertwo'                 => 'Lobster Two',
				'archivoblack'               => 'Archivo Black',
				'encodesans'                 => 'Encode Sans',
				'gothica1'                   => 'Gothic A1',
				'cardo'                      => 'Cardo',
				'greatvibes'                 => 'Great Vibes',
				'jost'                       => 'Jost',
				'orbitron'                   => 'Orbitron',
				'quattrocentosans'           => 'Quattrocento Sans',
				'ibmplexmono'                => 'IBM Plex Mono',
				'sacramento'                 => 'Sacramento',
				'francoisone'                => 'Francois One',
				'chivo'                      => 'Chivo',
				'didactgothic'               => 'Didact Gothic',
				'secularone'                 => 'Secular One',
				'baloo2'                     => 'Baloo 2',
				'prata'                      => 'Prata',
				'noticiatext'                => 'Noticia Text',
				'parisienne'                 => 'Parisienne',
				'cuprum'                     => 'Cuprum',
				'russoone'                   => 'Russo One',
				'signikanegative'            => 'Signika Negative',
				'spectral'                   => 'Spectral',
				'chakrapetch'                => 'Chakra Petch',
				'gloriahallelujah'           => 'Gloria Hallelujah',
				'publicsans'                 => 'Public Sans',
				'cantarell'                  => 'Cantarell',
				'asapcondensed'              => 'Asap Condensed',
				'oldstandardtt'              => 'Old Standard TT',
				'volkhov'                    => 'Volkhov',
				'rokkitt'                    => 'Rokkitt',
				'pathwaygothicone'           => 'Pathway Gothic One',
				'newscycle'                  => 'News Cycle',
				'concertone'                 => 'Concert One',
				'hindguntur'                 => 'Hind Guntur',
				'ropasans'                   => 'Ropa Sans',
				'passionone'                 => 'Passion One',
				'pressstart2p'               => 'Press Start 2P',
				'changa'                     => 'Changa',
				'josefinslab'                => 'Josefin Slab',
				'sairacondensed'             => 'Saira Condensed',
				'luckiestguy'                => 'Luckiest Guy',
				'cormorant'                  => 'Cormorant',
				'dmserifdisplay'             => 'DM Serif Display',
				'quattrocento'               => 'Quattrocento',
				'yellowtail'                 => 'Yellowtail',
				'hammersmithone'             => 'Hammersmith One',
				'cookie'                     => 'Cookie',
				'poiretone'                  => 'Poiret One',
				'monoton'                    => 'Monoton',
				'sawarabimincho'             => 'Sawarabi Mincho',
				'unna'                       => 'Unna',
				'gentiumbookbasic'           => 'Gentium Book Basic',
				'sanchez'                    => 'Sanchez',
				'merienda'                   => 'Merienda',
				'montserratalternates'       => 'Montserrat Alternates',
				'ultra'                      => 'Ultra',
				'paytoneone'                 => 'Paytone One',
				'playfairdisplaysc'          => 'Playfair Display SC',
				'staatliches'                => 'Staatliches',
				'neuton'                     => 'Neuton',
				'faustina'                   => 'Faustina',
				'vidaloka'                   => 'Vidaloka',
				'specialelite'               => 'Special Elite',
				'istokweb'                   => 'Istok Web',
				'taviraj'                    => 'Taviraj',
				'arapey'                     => 'Arapey',
				'khand'                      => 'Khand',
				'crimsonpro'                 => 'Crimson Pro',
				'philosopher'                => 'Philosopher',
				'bangers'                    => 'Bangers',
				'adventpro'                  => 'Advent Pro',
				'handlee'                    => 'Handlee',
				'saira'                      => 'Saira',
				'hindvadodara'               => 'Hind Vadodara',
				'firasansextracondensed'     => 'Fira Sans Extra Condensed',
				'economica'                  => 'Economica',
				'alice'                      => 'Alice',
				'spacemono'                  => 'Space Mono',
				'playball'                   => 'Playball',
				'homemadeapple'              => 'Homemade Apple',
				'notoseriftc'                => 'Noto Serif TC',
				'rocksalt'                   => 'Rock Salt',
				'gentiumbasic'               => 'Gentium Basic',
				'gudea'                      => 'Gudea',
				'ptmono'                     => 'PT Mono',
				'marckscript'                => 'Marck Script',
				'ubuntumono'                 => 'Ubuntu Mono',
				'karma'                      => 'Karma',
				'elmessiri'                  => 'El Messiri',
				'londrinasolid'              => 'Londrina Solid',
				'cabincondensed'             => 'Cabin Condensed',
				'actor'                      => 'Actor',
				'notoserifkr'                => 'Noto Serif KR',
				'nanumpenscript'             => 'Nanum Pen Script',
				'ruda'                       => 'Ruda',
				'tangerine'                  => 'Tangerine',
				'alef'                       => 'Alef',
				'pragatinarrow'              => 'Pragati Narrow',
				'unicaone'                   => 'Unica One',
				'neucha'                     => 'Neucha',
				'lusitana'                   => 'Lusitana',
				'dmseriftext'                => 'DM Serif Text',
				'alata'                      => 'Alata',
				'carterone'                  => 'Carter One',
				'recursive'                  => 'Recursive',
				'benchnine'                  => 'BenchNine',
				'electrolize'                => 'Electrolize',
				'baijamjuree'                => 'Bai Jamjuree',
				'martelsans'                 => 'Martel Sans',
				'jura'                       => 'Jura',
				'tenorsans'                  => 'Tenor Sans',
				'amaranth'                   => 'Amaranth',
				'juliussansone'              => 'Julius Sans One',
				'mitr'                       => 'Mitr',
				'sawarabigothic'             => 'Sawarabi Gothic',
				'viga'                       => 'Viga',
				'yesevaone'                  => 'Yeseva One',
				'palanquin'                  => 'Palanquin',
				'aclonica'                   => 'Aclonica',
				'marcellus'                  => 'Marcellus',
				'allura'                     => 'Allura',
				'badscript'                  => 'Bad Script',
				'cantataone'                 => 'Cantata One',
				'itim'                       => 'Itim',
				'notoserifsc'                => 'Noto Serif SC',
				'cutivemono'                 => 'Cutive Mono',
				'fugazone'                   => 'Fugaz One',
				'sairasemicondensed'         => 'Saira Semi Condensed',
				'jaldi'                      => 'Jaldi',
				'pontanosans'                => 'Pontano Sans',
				'berkshireswash'             => 'Berkshire Swash',
				'gelasio'                    => 'Gelasio',
				'nanumgothiccoding'          => 'Nanum Gothic Coding',
				'audiowide'                  => 'Audiowide',
				'adamina'                    => 'Adamina',
				'nothingyoucoulddo'          => 'Nothing You Could Do',
				'gochihand'                  => 'Gochi Hand',
				'antic'                      => 'Antic',
				'bungee'                     => 'Bungee',
				'mali'                       => 'Mali',
				'enriqueta'                  => 'Enriqueta',
				'markazitext'                => 'Markazi Text',
				'khula'                      => 'Khula',
				'aleo'                       => 'Aleo',
				'quantico'                   => 'Quantico',
				'knewave'                    => 'Knewave',
				'abhayalibre'                => 'Abhaya Libre',
				'encodesanscondensed'        => 'Encode Sans Condensed',
				'sen'                        => 'Sen',
				'rufina'                     => 'Rufina',
				'sortsmillgoudy'             => 'Sorts Mill Goudy',
				'varela'                     => 'Varela',
				'stintultracondensed'        => 'Stint Ultra Condensed',
				'mrdafoe'                    => 'Mr Dafoe',
				'mandali'                    => 'Mandali',
				'alexbrush'                  => 'Alex Brush',
				'eczar'                      => 'Eczar',
				'shadowsintolighttwo'        => 'Shadows Into Light Two',
				'sharetechmono'              => 'Share Tech Mono',
				'damion'                     => 'Damion',
				'courierprime'               => 'Courier Prime',
				'cousine'                    => 'Cousine',
				'sarala'                     => 'Sarala',
				'kosugimaru'                 => 'Kosugi Maru',
				'daysone'                    => 'Days One',
				'sixcaps'                    => 'Six Caps',
				'firamono'                   => 'Fira Mono',
				'boogaloo'                   => 'Boogaloo',
				'coda'                       => 'Coda',
				'lilitaone'                  => 'Lilita One',
				'armata'                     => 'Armata',
				'allan'                      => 'Allan',
				'suezone'                    => 'Suez One',
				'niconne'                    => 'Niconne',
				'michroma'                   => 'Michroma',
				'arimamadurai'               => 'Arima Madurai',
				'gruppo'                     => 'Gruppo',
				'muktamalar'                 => 'Mukta Malar',
				'bigshouldersdisplay'        => 'Big Shoulders Display',
				'basic'                      => 'Basic',
				'chewy'                      => 'Chewy',
				'oleoscript'                 => 'Oleo Script',
				'sairaextracondensed'        => 'Saira Extra Condensed',
				'spinnaker'                  => 'Spinnaker',
				'titanone'                   => 'Titan One',
				'glegoo'                     => 'Glegoo',
				'reemkufi'                   => 'Reem Kufi',
				'yrsa'                       => 'Yrsa',
				'overlock'                   => 'Overlock',
				'ramabhadra'                 => 'Ramabhadra',
				'coveredbyyourgrace'         => 'Covered By Your Grace',
				'sintony'                    => 'Sintony',
				'rubikmonoone'               => 'Rubik Mono One',
				'alegreyasanssc'             => 'Alegreya Sans SC',
				'allerta'                    => 'Allerta',
				'pridi'                      => 'Pridi',
				'sriracha'                   => 'Sriracha',
				'syncopate'                  => 'Syncopate',
				'average'                    => 'Average',
				'pinyonscript'               => 'Pinyon Script',
				'redhattext'                 => 'Red Hat Text',
				'mada'                       => 'Mada',
				'lemonada'                   => 'Lemonada',
				'kreon'                      => 'Kreon',
				'caveatbrush'                => 'Caveat Brush',
				'kronaone'                   => 'Krona One',
				'blackopsone'                => 'Black Ops One',
				'rancho'                     => 'Rancho',
				'ptserifcaption'             => 'PT Serif Caption',
				'candal'                     => 'Candal',
				'shrikhand'                  => 'Shrikhand',
				'forum'                      => 'Forum',
				'codacaption'                => 'Coda Caption',
				'lalezar'                    => 'Lalezar',
				'bowlbyonesc'                => 'Bowlby One SC',
				'lexenddeca'                 => 'Lexend Deca',
				'voltaire'                   => 'Voltaire',
				'frederickathegreat'         => 'Fredericka the Great',
				'overpassmono'               => 'Overpass Mono',
				'miriamlibre'                => 'Miriam Libre',
				'arsenal'                    => 'Arsenal',
				'reeniebeanie'               => 'Reenie Beanie',
				'capriola'                   => 'Capriola',
				'krub'                       => 'Krub',
				'annieuseyourtelescope'      => 'Annie Use Your Telescope',
				'rambla'                     => 'Rambla',
				'italianno'                  => 'Italianno',
				'kameron'                    => 'Kameron',
				'lateef'                     => 'Lateef',
				'creepster'                  => 'Creepster',
				'bevan'                      => 'Bevan',
				'farro'                      => 'Farro',
				'blackhansans'               => 'Black Han Sans',
				'goudybookletter1911'        => 'Goudy Bookletter 1911',
				'telex'                      => 'Telex',
				'ibmplexsanscondensed'       => 'IBM Plex Sans Condensed',
				'corben'                     => 'Corben',
				'cabinsketch'                => 'Cabin Sketch',
				'muktavaani'                 => 'Mukta Vaani',
				'sansita'                    => 'Sansita',
				'vt323'                      => 'VT323',
				'laila'                      => 'Laila',
				'aldrich'                    => 'Aldrich',
				'literata'                   => 'Literata',
				'averagesans'                => 'Average Sans',
				'seaweedscript'              => 'Seaweed Script',
				'norican'                    => 'Norican',
				'anonymouspro'               => 'Anonymous Pro',
				'scheherazade'               => 'Scheherazade',
				'caudex'                     => 'Caudex',
				'justanotherhand'            => 'Just Another Hand',
				'trirong'                    => 'Trirong',
				'nobile'                     => 'Nobile',
				'balootamma2'                => 'Baloo Tamma 2',
				'bubblegumsans'              => 'Bubblegum Sans',
				'arbutusslab'                => 'Arbutus Slab',
				'molengo'                    => 'Molengo',
				'niramit'                    => 'Niramit',
				'matesc'                     => 'Mate SC',
				'gildadisplay'               => 'Gilda Display',
				'yesteryear'                 => 'Yesteryear',
				'holtwoodonesc'              => 'Holtwood One SC',
				'comingsoon'                 => 'Coming Soon',
				'biryani'                    => 'Biryani',
				'cinzeldecorative'           => 'Cinzel Decorative',
				'ovo'                        => 'Ovo',
				'arizonia'                   => 'Arizonia',
				'mate'                       => 'Mate',
				'nixieone'                   => 'Nixie One',
				'rye'                        => 'Rye',
				'racingsansone'              => 'Racing Sans One',
				'charm'                      => 'Charm',
				'mrssaintdelafield'          => 'Mrs Saint Delafield',
				'rochester'                  => 'Rochester',
				'herrvonmuellerhoff'         => 'Herr Von Muellerhoff',
				'judson'                     => 'Judson',
				'epilogue'                   => 'Epilogue',
				'dohyeon'                    => 'Do Hyeon',
				'darkergrotesque'            => 'Darker Grotesque',
				'changaone'                  => 'Changa One',
				'mallanna'                   => 'Mallanna',
				'scada'                      => 'Scada',
				'oranienbaum'                => 'Oranienbaum',
				'leckerlione'                => 'Leckerli One',
				'jua'                        => 'Jua',
				'delius'                     => 'Delius',
				'graduate'                   => 'Graduate',
				'kristi'                     => 'Kristi',
				'kadwa'                      => 'Kadwa',
				'share'                      => 'Share',
				'nanumbrushscript'           => 'Nanum Brush Script',
				'amita'                      => 'Amita',
				'alegreyasc'                 => 'Alegreya SC',
				'marcellussc'                => 'Marcellus SC',
				'bungeeinline'               => 'Bungee Inline',
				'magra'                      => 'Magra',
				'librecaslontext'            => 'Libre Caslon Text',
				'halant'                     => 'Halant',
				'coustard'                   => 'Coustard',
				'allertastencil'             => 'Allerta Stencil',
				'trocchi'                    => 'Trocchi',
				'faunaone'                   => 'Fauna One',
				'rozhaone'                   => 'Rozha One',
				'copse'                      => 'Copse',
				'mountainsofchristmas'       => 'Mountains of Christmas',
				'jockeyone'                  => 'Jockey One',
				'athiti'                     => 'Athiti',
				'cedarvillecursive'          => 'Cedarville Cursive',
				'suranna'                    => 'Suranna',
				'marvel'                     => 'Marvel',
				'carme'                      => 'Carme',
				'carroisgothic'              => 'Carrois Gothic',
				'rosario'                    => 'Rosario',
				'lustria'                    => 'Lustria',
				'contrailone'                => 'Contrail One',
				'schoolbell'                 => 'Schoolbell',
				'gfsdidot'                   => 'GFS Didot',
				'koho'                       => 'KoHo',
				'mrdehaviland'               => 'Mr De Haviland',
				'petitformalscript'          => 'Petit Formal Script',
				'meriendaone'                => 'Merienda One',
				'belleza'                    => 'Belleza',
				'comicneue'                  => 'Comic Neue',
				'palanquindark'              => 'Palanquin Dark',
				'sunflower'                  => 'Sunflower',
				'wallpoet'                   => 'Wallpoet',
				'calligraffitti'             => 'Calligraffitti',
				'pangolin'                   => 'Pangolin',
				'thasadith'                  => 'Thasadith',
				'belgrano'                   => 'Belgrano',
				'slabo13px'                  => 'Slabo 13px',
				'loveyalikeasister'          => 'Love Ya Like A Sister',
				'labelleaurore'              => 'La Belle Aurore',
				'grandhotel'                 => 'Grand Hotel',
				'marmelad'                   => 'Marmelad',
				'amiko'                      => 'Amiko',
				'averiaseriflibre'           => 'Averia Serif Libre',
				'montaga'                    => 'Montaga',
				'cambay'                     => 'Cambay',
				'hanuman'                    => 'Hanuman',
				'commissioner'               => 'Commissioner',
				'mirza'                      => 'Mirza',
				'aladin'                     => 'Aladin',
				'cormorantinfant'            => 'Cormorant Infant',
				'kosugi'                     => 'Kosugi',
				'sora'                       => 'Sora',
				'alatsi'                     => 'Alatsi',
				'radley'                     => 'Radley',
				'maitree'                    => 'Maitree',
				'k2d'                        => 'K2D',
				'metrophobic'                => 'Metrophobic',
				'harmattan'                  => 'Harmattan',
				'sniglet'                    => 'Sniglet',
				'spacegrotesk'               => 'Space Grotesk',
				'rammettoone'                => 'Rammetto One',
				'podkova'                    => 'Podkova',
				'imfelldoublepica'           => 'IM Fell Double Pica',
				'poly'                       => 'Poly',
				'baskervville'               => 'Baskervville',
				'averialibre'                => 'Averia Libre',
				'durusans'                   => 'Duru Sans',
				'chonburi'                   => 'Chonburi',
				'oxygenmono'                 => 'Oxygen Mono',
				'ntr'                        => 'NTR',
				'grandstander'               => 'Grandstander',
				'kellyslab'                  => 'Kelly Slab',
				'lekton'                     => 'Lekton',
				'manjari'                    => 'Manjari',
				'esteban'                    => 'Esteban',
				'bevietnam'                  => 'Be Vietnam',
				'frijole'                    => 'Frijole',
				'homenaje'                   => 'Homenaje',
				'balthazar'                  => 'Balthazar',
				'bodonimoda'                 => 'Bodoni Moda',
				'kumbhsans'                  => 'Kumbh Sans',
				'spectralsc'                 => 'Spectral SC',
				'zcoolxiaowei'               => 'ZCOOL XiaoWei',
				'cutive'                     => 'Cutive',
				'andada'                     => 'Andada',
				'amethysta'                  => 'Amethysta',
				'sueellenfrancisco'          => 'Sue Ellen Francisco',
				'anticdidone'                => 'Antic Didone',
				'blinker'                    => 'Blinker',
				'waitingforthesunrise'       => 'Waiting for the Sunrise',
				'megrim'                     => 'Megrim',
				'balooda2'                   => 'Baloo Da 2',
				'unifrakturmaguntia'         => 'UnifrakturMaguntia',
				'bentham'                    => 'Bentham',
				'monsieurladoulaise'         => 'Monsieur La Doulaise',
				'firacode'                   => 'Fira Code',
				'convergence'                => 'Convergence',
				'inder'                      => 'Inder',
				'chelseamarket'              => 'Chelsea Market',
				'buenard'                    => 'Buenard',
				'alike'                      => 'Alike',
				'turretroad'                 => 'Turret Road',
				'biorhyme'                   => 'BioRhyme',
				'lemon'                      => 'Lemon',
				'gabriela'                   => 'Gabriela',
				'bowlbyone'                  => 'Bowlby One',
				'encodesanssemicondensed'    => 'Encode Sans Semi Condensed',
				'gugi'                       => 'Gugi',
				'gravitasone'                => 'Gravitas One',
				'battambang'                 => 'Battambang',
				'bellefair'                  => 'Bellefair',
				'stardosstencil'             => 'Stardos Stencil',
				'expletussans'               => 'Expletus Sans',
				'imfellenglish'              => 'IM Fell English',
				'heptaslab'                  => 'Hepta Slab',
				'kurale'                     => 'Kurale',
				'emilyscandy'                => 'Emilys Candy',
				'davidlibre'                 => 'David Libre',
				'sedgwickave'                => 'Sedgwick Ave',
				'sharetech'                  => 'Share Tech',
				'bungeeshade'                => 'Bungee Shade',
				'cormorantsc'                => 'Cormorant SC',
				'pompiere'                   => 'Pompiere',
				'sofia'                      => 'Sofia',
				'doppioone'                  => 'Doppio One',
				'rakkas'                     => 'Rakkas',
				'oregano'                    => 'Oregano',
				'imfelldwpica'               => 'IM Fell DW Pica',
				'dawningofanewday'           => 'Dawning of a New Day',
				'rougescript'                => 'Rouge Script',
				'sarpanch'                   => 'Sarpanch',
				'grenzegotisch'              => 'Grenze Gotisch',
				'baumans'                    => 'Baumans',
				'codystar'                   => 'Codystar',
				'qwigley'                    => 'Qwigley',
				'fanwoodtext'                => 'Fanwood Text',
				'meddon'                     => 'Meddon',
				'quando'                     => 'Quando',
				'librebarcode39'             => 'Libre Barcode 39',
				'cevicheone'                 => 'Ceviche One',
				'brawler'                    => 'Brawler',
				'zeyada'                     => 'Zeyada',
				'oleoscriptswashcaps'        => 'Oleo Script Swash Caps',
				'alikeangular'               => 'Alike Angular',
				'fingerpaint'                => 'Finger Paint',
				'b612mono'                   => 'B612 Mono',
				'originalsurfer'             => 'Original Surfer',
				'encodesansexpanded'         => 'Encode Sans Expanded',
				'freckleface'                => 'Freckle Face',
				'numans'                     => 'Numans',
				'andika'                     => 'Andika',
				'shortstack'                 => 'Short Stack',
				'prozalibre'                 => 'Proza Libre',
				'ralewaydots'                => 'Raleway Dots',
				'himelody'                   => 'Hi Melody',
				'montez'                     => 'Montez',
				'rasa'                       => 'Rasa',
				'giveyouglory'               => 'Give You Glory',
				'vastshadow'                 => 'Vast Shadow',
				'clickerscript'              => 'Clicker Script',
				'majormonodisplay'           => 'Major Mono Display',
				'katibeh'                    => 'Katibeh',
				'aguafinascript'             => 'Aguafina Script',
				'patrickhandsc'              => 'Patrick Hand SC',
				'skranji'                    => 'Skranji',
				'anaheim'                    => 'Anaheim',
				'unkempt'                    => 'Unkempt',
				'jetbrainsmono'              => 'JetBrains Mono',
				'wendyone'                   => 'Wendy One',
				'happymonkey'                => 'Happy Monkey',
				'dokdo'                      => 'Dokdo',
				'vollkornsc'                 => 'Vollkorn SC',
				'fondamento'                 => 'Fondamento',
				'sail'                       => 'Sail',
				'girassol'                   => 'Girassol',
				'hanaleifill'                => 'Hanalei Fill',
				'almendra'                   => 'Almendra',
				'overtherainbow'             => 'Over the Rainbow',
				'mclaren'                    => 'McLaren',
				'mousememoirs'               => 'Mouse Memoirs',
				'chauphilomeneone'           => 'Chau Philomene One',
				'mansalva'                   => 'Mansalva',
				'gurajada'                   => 'Gurajada',
				'strait'                     => 'Strait',
				'cambo'                      => 'Cambo',
				'vesperlibre'                => 'Vesper Libre',
				'galada'                     => 'Galada',
				'novamono'                   => 'Nova Mono',
				'federo'                     => 'Federo',
				'baloothambi2'               => 'Baloo Thambi 2',
				'mashanzheng'                => 'Ma Shan Zheng',
				'oxanium'                    => 'Oxanium',
				'ranchers'                   => 'Ranchers',
				'arefruqaa'                  => 'Aref Ruqaa',
				'euphoriascript'             => 'Euphoria Script',
				'caladea'                    => 'Caladea',
				'calistoga'                  => 'Calistoga',
				'tillana'                    => 'Tillana',
				'mako'                       => 'Mako',
				'orienta'                    => 'Orienta',
				'deliusswashcaps'            => 'Delius Swash Caps',
				'timmana'                    => 'Timmana',
				'imfellenglishsc'            => 'IM Fell English SC',
				'montserratsubrayada'        => 'Montserrat Subrayada',
				'craftygirls'                => 'Crafty Girls',
				'b612'                       => 'B612',
				'livvic'                     => 'Livvic',
				'ledger'                     => 'Ledger',
				'ruslandisplay'              => 'Ruslan Display',
				'baloochettan2'              => 'Baloo Chettan 2',
				'fasterone'                  => 'Faster One',
				'dmmono'                     => 'DM Mono',
				'pollerone'                  => 'Poller One',
				'novasquare'                 => 'Nova Square',
				'atma'                       => 'Atma',
				'reggaeone'                  => 'Reggae One',
				'newsreader'                 => 'Newsreader',
				'geo'                        => 'Geo',
				'denkone'                    => 'Denk One',
				'scopeone'                   => 'Scope One',
				'yuseimagic'                 => 'Yusei Magic',
				'muktamahee'                 => 'Mukta Mahee',
				'averiasanslibre'            => 'Averia Sans Libre',
				'walterturncoat'             => 'Walter Turncoat',
				'zcoolkuaile'                => 'ZCOOL KuaiLe',
				'prostoone'                  => 'Prosto One',
				'rocknrollone'               => 'RocknRoll One',
				'elsie'                      => 'Elsie',
				'iceland'                    => 'Iceland',
				'lovedbytheking'             => 'Loved by the King',
				'cormorantupright'           => 'Cormorant Upright',
				'imprima'                    => 'Imprima',
				'mina'                       => 'Mina',
				'lifesavers'                 => 'Life Savers',
				'redrose'                    => 'Red Rose',
				'inknutantiqua'              => 'Inknut Antiqua',
				'tenaliramakrishna'          => 'Tenali Ramakrishna',
				'salsa'                      => 'Salsa',
				'zcoolqingkehuangyou'        => 'ZCOOL QingKe HuangYou',
				'yeonsung'                   => 'Yeon Sung',
				'vampiroone'                 => 'Vampiro One',
				'thegirlnextdoor'            => 'The Girl Next Door',
				'shojumaru'                  => 'Shojumaru',
				'meerainimai'                => 'Meera Inimai',
				'slackey'                    => 'Slackey',
				'tradewinds'                 => 'Trade Winds',
				'antonio'                    => 'Antonio',
				'lilyscriptone'              => 'Lily Script One',
				'bilbo'                      => 'Bilbo',
				'bilboswashcaps'             => 'Bilbo Swash Caps',
				'arya'                       => 'Arya',
				'englebert'                  => 'Englebert',
				'tienne'                     => 'Tienne',
				'italiana'                   => 'Italiana',
				'cherryswash'                => 'Cherry Swash',
				'dynalight'                  => 'Dynalight',
				'bellotatext'                => 'Bellota Text',
				'metamorphous'               => 'Metamorphous',
				'ranga'                      => 'Ranga',
				'asul'                       => 'Asul',
				'cherrycreamsoda'            => 'Cherry Cream Soda',
				'flamenco'                   => 'Flamenco',
				'dellarespira'               => 'Della Respira',
				'gafata'                     => 'Gafata',
				'bigshoulderstext'           => 'Big Shoulders Text',
				'tauri'                      => 'Tauri',
				'unifrakturcook'             => 'UnifrakturCook',
				'carroisgothicsc'            => 'Carrois Gothic SC',
				'lexend'                     => 'Lexend',
				'puritan'                    => 'Puritan',
				'peralta'                    => 'Peralta',
				'headlandone'                => 'Headland One',
				'nokora'                     => 'Nokora',
				'gaegu'                      => 'Gaegu',
				'fresca'                     => 'Fresca',
				'voces'                      => 'Voces',
				'portlligatsans'             => 'Port Lligat Sans',
				'artifika'                   => 'Artifika',
				'wireone'                    => 'Wire One',
				'justmeagaindownhere'        => 'Just Me Again Down Here',
				'galdeano'                   => 'Galdeano',
				'hennypenny'                 => 'Henny Penny',
				'coiny'                      => 'Coiny',
				'gamjaflower'                => 'Gamja Flower',
				'fontdinerswanky'            => 'Fontdiner Swanky',
				'vibur'                      => 'Vibur',
				'textmeone'                  => 'Text Me One',
				'cantoraone'                 => 'Cantora One',
				'deliusunicase'              => 'Delius Unicase',
				'medulaone'                  => 'Medula One',
				'amarante'                   => 'Amarante',
				'encodesanssemiexpanded'     => 'Encode Sans Semi Expanded',
				'fjordone'                   => 'Fjord One',
				'pavanam'                    => 'Pavanam',
				'manuale'                    => 'Manuale',
				'portlligatslab'             => 'Port Lligat Slab',
				'germaniaone'                => 'Germania One',
				'mogra'                      => 'Mogra',
				'bubblerone'                 => 'Bubbler One',
				'eater'                      => 'Eater',
				'khmer'                      => 'Khmer',
				'novaround'                  => 'Nova Round',
				'koulen'                     => 'Koulen',
				'pirataone'                  => 'Pirata One',
				'librebarcode39text'         => 'Libre Barcode 39 Text',
				'notable'                    => 'Notable',
				'ribeye'                     => 'Ribeye',
				'stalemate'                  => 'Stalemate',
				'kiteone'                    => 'Kite One',
				'engagement'                 => 'Engagement',
				'newrocker'                  => 'New Rocker',
				'goblinone'                  => 'Goblin One',
				'kranky'                     => 'Kranky',
				'jomhuria'                   => 'Jomhuria',
				'habibi'                     => 'Habibi',
				'yatraone'                   => 'Yatra One',
				'rowdies'                    => 'Rowdies',
				'loversquarrel'              => 'Lovers Quarrel',
				'lexendzetta'                => 'Lexend Zetta',
				'sairastencilone'            => 'Saira Stencil One',
				'baloobhaina2'               => 'Baloo Bhaina 2',
				'spicyrice'                  => 'Spicy Rice',
				'chelaone'                   => 'Chela One',
				'sarina'                     => 'Sarina',
				'sumana'                     => 'Sumana',
				'imfelldwpicasc'             => 'IM Fell DW Pica SC',
				'ramaraja'                   => 'Ramaraja',
				'goldman'                    => 'Goldman',
				'julee'                      => 'Julee',
				'shanti'                     => 'Shanti',
				'gayathri'                   => 'Gayathri',
				'sura'                       => 'Sura',
				'moul'                       => 'Moul',
				'librebarcode39extendedtext' => 'Libre Barcode 39 Extended Text',
				'macondoswashcaps'           => 'Macondo Swash Caps',
				'leaguescript'               => 'League Script',
				'prociono'                   => 'Prociono',
				'modak'                      => 'Modak',
				'eastseadokdo'               => 'East Sea Dokdo',
				'kumarone'                   => 'Kumar One',
				'zillaslabhighlight'         => 'Zilla Slab Highlight',
				'kottaone'                   => 'Kotta One',
				'novaflat'                   => 'Nova Flat',
				'kodchasan'                  => 'Kodchasan',
				'syne'                       => 'Syne',
				'fahkwang'                   => 'Fahkwang',
				'paprika'                    => 'Paprika',
				'mysteryquest'               => 'Mystery Quest',
				'sancreek'                   => 'Sancreek',
				'milonga'                    => 'Milonga',
				'overlocksc'                 => 'Overlock SC',
				'crushed'                    => 'Crushed',
				'bigelowrules'               => 'Bigelow Rules',
				'quintessential'             => 'Quintessential',
				'angkor'                     => 'Angkor',
				'swankyandmoomoo'            => 'Swanky and Moo Moo',
				'uncialantiqua'              => 'Uncial Antiqua',
				'rosarivo'                   => 'Rosarivo',
				'imfellfrenchcanon'          => 'IM Fell French Canon',
				'rationale'                  => 'Rationale',
				'charmonman'                 => 'Charmonman',
				'kdamthmor'                  => 'Kdam Thmor',
				'dekko'                      => 'Dekko',
				'stintultraexpanded'         => 'Stint Ultra Expanded',
				'chicle'                     => 'Chicle',
				'songmyung'                  => 'Song Myung',
				'stylish'                    => 'Stylish',
				'donegalone'                 => 'Donegal One',
				'simonetta'                  => 'Simonetta',
				'bungeeoutline'              => 'Bungee Outline',
				'baloopaaji2'                => 'Baloo Paaji 2',
				'lakkireddy'                 => 'Lakki Reddy',
				'stoke'                      => 'Stoke',
				'shipporimincho'             => 'Shippori Mincho',
				'baloobhai2'                 => 'Baloo Bhai 2',
				'fenix'                      => 'Fenix',
				'offside'                    => 'Offside',
				'balootammudu2'              => 'Baloo Tammudu 2',
				'imfellfrenchcanonsc'        => 'IM Fell French Canon SC',
				'inriaserif'                 => 'Inria Serif',
				'ruluko'                     => 'Ruluko',
				'chathura'                   => 'Chathura',
				'redressed'                  => 'Redressed',
				'bellota'                    => 'Bellota',
				'solway'                     => 'Solway',
				'sonsieone'                  => 'Sonsie One',
				'condiment'                  => 'Condiment',
				'margarine'                  => 'Margarine',
				'kulimpark'                  => 'Kulim Park',
				'junge'                      => 'Junge',
				'cormorantunicase'           => 'Cormorant Unicase',
				'barrio'                     => 'Barrio',
				'petrona'                    => 'Petrona',
				'imfellgreatprimer'          => 'IM Fell Great Primer',
				'tomorrow'                   => 'Tomorrow',
				'librecaslondisplay'         => 'Libre Caslon Display',
				'cutefont'                   => 'Cute Font',
				'tulpenone'                  => 'Tulpen One',
				'averiagruesalibre'          => 'Averia Gruesa Libre',
				'chilanka'                   => 'Chilanka',
				'autourone'                  => 'Autour One',
				'cagliostro'                 => 'Cagliostro',
				'asar'                       => 'Asar',
				'chango'                     => 'Chango',
				'akronim'                    => 'Akronim',
				'londrinaoutline'            => 'Londrina Outline',
				'wellfleet'                  => 'Wellfleet',
				'croissantone'               => 'Croissant One',
				'museomoderno'               => 'MuseoModerno',
				'dorsa'                      => 'Dorsa',
				'farsan'                     => 'Farsan',
				'metal'                      => 'Metal',
				'elsieswashcaps'             => 'Elsie Swash Caps',
				'ibarrarealnova'             => 'Ibarra Real Nova',
				'lexendexa'                  => 'Lexend Exa',
				'librebarcode128'            => 'Libre Barcode 128',
				'buda'                       => 'Buda',
				'sulphurpoint'               => 'Sulphur Point',
				'bahianita'                  => 'Bahianita',
				'markoone'                   => 'Marko One',
				'castoro'                    => 'Castoro',
				'eaglelake'                  => 'Eagle Lake',
				'ribeyemarrow'               => 'Ribeye Marrow',
				'lindenhill'                 => 'Linden Hill',
				'spirax'                     => 'Spirax',
				'gotu'                       => 'Gotu',
				'rumraisin'                  => 'Rum Raisin',
				'dotgothic16'                => 'DotGothic16',
				'kiwimaru'                   => 'Kiwi Maru',
				'bethellen'                  => 'Beth Ellen',
				'srisakdi'                   => 'Srisakdi',
				'meiescript'                 => 'Meie Script',
				'nosifer'                    => 'Nosifer',
				'pottaone'                   => 'Potta One',
				'bayon'                      => 'Bayon',
				'modernantiqua'              => 'Modern Antiqua',
				'kavoon'                     => 'Kavoon',
				'arbutus'                    => 'Arbutus',
				'piazzolla'                  => 'Piazzolla',
				'maidenorange'               => 'Maiden Orange',
				'gorditas'                   => 'Gorditas',
				'miniver'                    => 'Miniver',
				'ruthie'                     => 'Ruthie',
				'jotione'                    => 'Joti One',
				'iceberg'                    => 'Iceberg',
				'inika'                      => 'Inika',
				'piedra'                     => 'Piedra',
				'flavors'                    => 'Flavors',
				'sreekrushnadevaraya'        => 'Sree Krushnadevaraya',
				'zendots'                    => 'Zen Dots',
				'jomolhari'                  => 'Jomolhari',
				'trykker'                    => 'Trykker',
				'hachimarupop'               => 'Hachi Maru Pop',
				'atomicage'                  => 'Atomic Age',
				'caesardressing'             => 'Caesar Dressing',
				'risque'                     => 'Risque',
				'griffy'                     => 'Griffy',
				'devonshire'                 => 'Devonshire',
				'siemreap'                   => 'Siemreap',
				'kantumruy'                  => 'Kantumruy',
				'poorstory'                  => 'Poor Story',
				'bigshotone'                 => 'Bigshot One',
				'felipa'                     => 'Felipa',
				'raviprakash'                => 'Ravi Prakash',
				'kavivanar'                  => 'Kavivanar',
				'metalmania'                 => 'Metal Mania',
				'rhodiumlibre'               => 'Rhodium Libre',
				'glassantiqua'               => 'Glass Antiqua',
				'jollylodger'                => 'Jolly Lodger',
				'delagothicone'              => 'Dela Gothic One',
				'sirinstencil'               => 'Sirin Stencil',
				'molle'                      => 'Molle',
				'longcang'                   => 'Long Cang',
				'shipporiminchob1'           => 'Shippori Mincho B1',
				'synemono'                   => 'Syne Mono',
				'lancelot'                   => 'Lancelot',
				'sansitaswashed'             => 'Sansita Swashed',
				'diplomatasc'                => 'Diplomata SC',
				'stalinistone'               => 'Stalinist One',
				'content'                    => 'Content',
				'odormeanchey'               => 'Odor Mean Chey',
				'mrssheppards'               => 'Mrs Sheppards',
				'sahitya'                    => 'Sahitya',
				'monofett'                   => 'Monofett',
				'dangrek'                    => 'Dangrek',
				'bahiana'                    => 'Bahiana',
				'romanesco'                  => 'Romanesco',
				'fraunces'                   => 'Fraunces',
				'snippet'                    => 'Snippet',
				'lexendmega'                 => 'Lexend Mega',
				'librebarcode128text'        => 'Libre Barcode 128 Text',
				'asset'                      => 'Asset',
				'princesssofia'              => 'Princess Sofia',
				'ewert'                      => 'Ewert',
				'jacquesfrancoisshadow'      => 'Jacques Francois Shadow',
				'revalia'                    => 'Revalia',
				'diplomata'                  => 'Diplomata',
				'londrinasketch'             => 'Londrina Sketch',
				'trainone'                   => 'Train One',
				'medievalsharp'              => 'MedievalSharp',
				'stick'                      => 'Stick',
				'smythe'                     => 'Smythe',
				'texturina'                  => 'Texturina',
				'jimnightshade'              => 'Jim Nightshade',
				'orelegaone'                 => 'Orelega One',
				'almendrasc'                 => 'Almendra SC',
				'varta'                      => 'Varta',
				'londrinashadow'             => 'Londrina Shadow',
				'novaslim'                   => 'Nova Slim',
				'galindo'                    => 'Galindo',
				'oldenburg'                  => 'Oldenburg',
				'drsugiyama'                 => 'Dr Sugiyama',
				'almendradisplay'            => 'Almendra Display',
				'gupter'                     => 'Gupter',
				'underdog'                   => 'Underdog',
				'irishgrover'                => 'Irish Grover',
				'gfsneohellenic'             => 'GFS Neohellenic',
				'peddana'                    => 'Peddana',
				'bigshouldersstenciltext'    => 'Big Shoulders Stencil Text',
				'seymourone'                 => 'Seymour One',
				'trochut'                    => 'Trochut',
				'keaniaone'                  => 'Keania One',
				'sunshiney'                  => 'Sunshiney',
				'fascinate'                  => 'Fascinate',
				'emblemaone'                 => 'Emblema One',
				'freehand'                   => 'Freehand',
				'kufam'                      => 'Kufam',
				'librebarcode39extended'     => 'Libre Barcode 39 Extended',
				'snowburstone'               => 'Snowburst One',
				'imfellgreatprimersc'        => 'IM Fell Great Primer SC',
				'newtegomin'                 => 'New Tegomin',
				'andikanewbasic'             => 'Andika New Basic',
				'unlock'                     => 'Unlock',
				'brygada1918'                => 'Brygada 1918',
				'kumaroneoutline'            => 'Kumar One Outline',
				'mrbedfort'                  => 'Mr Bedfort',
				'barriecito'                 => 'Barriecito',
				'bokor'                      => 'Bokor',
				'missfajardose'              => 'Miss Fajardose',
				'fascinateinline'            => 'Fascinate Inline',
				'plaster'                    => 'Plaster',
				'grenze'                     => 'Grenze',
				'jacquesfrancois'            => 'Jacques Francois',
				'smokum'                     => 'Smokum',
				'macondo'                    => 'Macondo',
				'liujianmaocao'              => 'Liu Jian Mao Cao',
				'chenla'                     => 'Chenla',
				'sedgwickavedisplay'         => 'Sedgwick Ave Display',
				'taprom'                     => 'Taprom',
				'lexendgiga'                 => 'Lexend Giga',
				'imfelldoublepicasc'         => 'IM Fell Double Pica SC',
				'purplepurse'                => 'Purple Purse',
				'ericaone'                   => 'Erica One',
				'inriasans'                  => 'Inria Sans',
				'blackandwhitepicture'       => 'Black And White Picture',
				'butterflykids'              => 'Butterfly Kids',
				'novacut'                    => 'Nova Cut',
				'kiranghaerang'              => 'Kirang Haerang',
				'suwannaphum'                => 'Suwannaphum',
				'supermercadoone'            => 'Supermercado One',
				'preahvihear'                => 'Preahvihear',
				'akayakanadaka'              => 'Akaya Kanadaka',
				'akayatelivigala'            => 'Akaya Telivigala',
				'zhimangxing'                => 'Zhi Mang Xing',
				'bonbon'                     => 'Bonbon',
				'astloch'                    => 'Astloch',
				'bungeehairline'             => 'Bungee Hairline',
				'rugeboogie'                 => 'Ruge Boogie',
				'sofadione'                  => 'Sofadi One',
				'miltoniantattoo'            => 'Miltonian Tattoo',
				'combo'                      => 'Combo',
				'novascript'                 => 'Nova Script',
				'gidugu'                     => 'Gidugu',
				'federant'                   => 'Federant',
				'hanalei'                    => 'Hanalei',
				'nerkoone'                   => 'Nerko One',
				'passeroone'                 => 'Passero One',
				'geostarfill'                => 'Geostar Fill',
				'novaoval'                   => 'Nova Oval',
				'vibes'                      => 'Vibes',
				'sevillana'                  => 'Sevillana',
				'aubrey'                     => 'Aubrey',
				'lacquer'                    => 'Lacquer',
				'miltonian'                  => 'Miltonian',
				'butcherman'                 => 'Butcherman',
				'moulpali'                   => 'Moulpali',
				'suravaram'                  => 'Suravaram',
				'fruktur'                    => 'Fruktur',
				'fasthand'                   => 'Fasthand',
				'kenia'                      => 'Kenia',
				'lexendtera'                 => 'Lexend Tera',
				'bigshouldersinlinetext'     => 'Big Shoulders Inline Text',
				'imbue'                      => 'Imbue',
				'dhurjati'                   => 'Dhurjati',
				'lexendpeta'                 => 'Lexend Peta',
				'viaodalibre'                => 'Viaoda Libre',
				'biorhymeexpanded'           => 'BioRhyme Expanded',
				'langar'                     => 'Langar',
				'singleday'                  => 'Single Day',
				'bigshouldersstencildisplay' => 'Big Shoulders Stencil Display',
				'karantina'                  => 'Karantina',
				'bigshouldersinlinedisplay'  => 'Big Shoulders Inline Display',
				'geostar'                    => 'Geostar',
				'warnes'                     => 'Warnes',
				'xanhmono'                   => 'Xanh Mono',
				'ballet'                     => 'Ballet',
				'trispace'                   => 'Trispace',
				'synetactile'                => 'Syne Tactile',
				'truculenta'                 => 'Truculenta',
				'librebarcodeean13text'      => 'Libre Barcode EAN13 Text',
				'oi'                         => 'Oi',
				'benne'                      => 'Benne',
			)
		);
	}
}
