<?php
/**
 * Podcast player utility functions.
 *
 * @link       https://www.vedathemes.com
 * @since      3.3.0
 *
 * @package    Podcast_Player
 * @subpackage Podcast_Player/Helper
 */

namespace PP_Pro\Helper\Functions;

/**
 * Podcast player utility functions.
 *
 * @package    Podcast_Player
 * @subpackage Podcast_Player/Helper
 * @author     vedathemes <contact@vedathemes.com>
 */
class Utility {

	/**
	 * Constructor method.
	 *
	 * @since  3.3.0
	 */
	public function __construct() {}

	/**
	 * Loosly check if a term exist in a given string.
	 *
	 * @since 3.3.0
	 *
	 * @param string  $string String to search in.
	 * @param boolean $term   Term to be searched in the string.
	 * @return bool
	 */
	public static function string_search( $string, $term ) {
		$string = strtolower( $string );
		$term   = strtolower( $term );

		// Directly search term in the string.
		if ( false !== strpos( $string, $term ) ) {
			return true;
		}

		// Break the string into array of words.
		$string_parts = explode( ' ', $string );
		$term_parts   = explode( ' ', $term );

		// Calculation variables.
		$term_char_len = strlen( str_replace( ' ', '', $term ) );
		$match_percent = 0;

		// Calculate similarity.
		foreach ( $term_parts as $part ) {
			$part_char_len = strlen( $part );
			$match         = 0;
			foreach ( $string_parts as $str ) {
				similar_text( $str, $part, $per );
				if ( 80 <= $per ) {
					$match          = $per;
					$match_percent += ( $part_char_len / $term_char_len ) * $match;
					break;
				}
			}
		}
		if ( 70 <= $match_percent ) {
			return true;
		}
		return false;
	}
}
