<?php

namespace DevOwl\RealCookieBanner\lite\presets;

use DevOwl\RealCookieBanner\comp\language\Hooks;
use DevOwl\RealCookieBanner\presets\pro\FacebookLikePreset as ProFacebookLikePreset;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Facebook (Like button) cookie preset.
 */
class FacebookLikePreset extends \DevOwl\RealCookieBanner\presets\pro\FacebookLikePreset {
    const NONCE_LENGTH = 8;
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        return \array_merge($parent, [
            'attributes' => [
                'name' => 'Facebook Like Button',
                'group' => __('Marketing', \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED),
                'purpose' => __(
                    'Facebook Like button allows users to show their support for specific blog articles, pictures, wall posts, fan pages or similar content on Facebook. The cookies are used to collect likes content as well as to collect visited websites. This data can be linked to the data of users registered on facebook.com with their Facebook accounts.',
                    \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED
                ),
                'provider' => 'Facebook Ireland Ltd.',
                'providerPrivacyPolicy' => 'https://www.facebook.com/about/privacy',
                'technicalDefinitions' => [
                    [
                        'type' => 'http',
                        'name' => 'presence',
                        'host' => '.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \true,
                        'duration' => 0
                    ],
                    [
                        'type' => 'http',
                        'name' => 'wd',
                        'host' => '.facebook.com',
                        'duration' => 7,
                        'durationUnit' => 'd',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'spin',
                        'host' => '.facebook.com',
                        'duration' => 1,
                        'durationUnit' => 'd',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'fr',
                        'host' => '.facebook.com',
                        'duration' => 3,
                        'durationUnit' => 'mo',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'xs',
                        'host' => '.facebook.com',
                        'duration' => 1,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'sb',
                        'host' => '.facebook.com',
                        'duration' => 2,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'dpr',
                        'host' => '.facebook.com',
                        'duration' => 7,
                        'durationUnit' => 'd',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'datr',
                        'host' => '.facebook.com',
                        'duration' => 2,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'c_user',
                        'host' => '.facebook.com',
                        'duration' => 1,
                        'durationUnit' => 'y',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'http',
                        'name' => 'locale',
                        'host' => '.facebook.com',
                        'duration' => 7,
                        'durationUnit' => 'd',
                        'sessionDuration' => \false
                    ],
                    [
                        'type' => 'session',
                        'name' => 'TabId',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => 'Session',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => 'hb_timestamp',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => '_video_bandwidthEstimate',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => 'CacheStorageVersion',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => 'RTC_CALL_SUMMARY_summary',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => 'marketplaceLoggingBookmarkLogTimestamp',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => 'signal_flush_timestamp',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => '_cs_marauder_last_session_id',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => 'channel_sub:*',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ],
                    [
                        'type' => 'local',
                        'name' => 'JewelBase:count-updated',
                        'host' => 'www.facebook.com',
                        'durationUnit' => 'y',
                        'sessionDuration' => \false,
                        'duration' => 0
                    ]
                ],
                'technicalHandlingNotice' => __(
                    'The default opt-in script is optimized for the use of the Facebook Like button via the Facebook JavaScript SDK in the opt-in script. If you use the Facebook Like button as an iframe or have already injected the Facebook SDK somewhere else (e. g. via a plugin), you must create a content blocker to block it before you have the consent of the user and delete the default opt-in script below.',
                    RCB_TD
                ),
                'codeOptIn' =>
                    '<div id="fb-root"></div>
<script async defer crossorigin="anonymous" src="https://connect.facebook.net/de_DE/sdk.js#xfbml=1&version=v7.0" nonce="' .
                    self::createScriptNonce() .
                    '"></script>',
                'codeOptOutDelete' => \false,
                'ePrivacyUSA' => \true
            ]
        ]);
    }
    // Documented in AbstractPreset
    public function managerNone() {
        return \false;
    }
    // Documented in AbstractPreset
    public function managerGtm() {
        return \false;
    }
    // Documented in AbstractPreset
    public function managerMtm() {
        return \false;
    }
    /**
     * Facebook uses a random generated script nonce for caching purposes.
     */
    public static function createScriptNonce() {
        $original_string = \array_merge(\range(0, 9), \range('a', 'z'), \range('A', 'Z'));
        $original_string = \implode('', $original_string);
        return \substr(\str_shuffle($original_string), 0, self::NONCE_LENGTH);
    }
}
