<?php

namespace DevOwl\RealCookieBanner\lite\presets\blocker;

use DevOwl\RealCookieBanner\comp\language\Hooks;
use DevOwl\RealCookieBanner\presets\pro\FlickrPreset as PresetsFlickrPreset;
use DevOwl\RealCookieBanner\presets\pro\blocker\FlickrPreset as BlockerFlickrPreset;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Flickr blocker preset.
 */
class FlickrPreset extends \DevOwl\RealCookieBanner\presets\pro\blocker\FlickrPreset {
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        return \array_merge($parent, [
            'attributes' => \array_merge(
                [
                    'name' => $parent['name'],
                    'description' => __(
                        'An image from Flickr has been blocked because you did not allow to load it.',
                        \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED
                    ),
                    'cookies' => [\DevOwl\RealCookieBanner\presets\pro\FlickrPreset::IDENTIFIER]
                ],
                $parent['attributes']
            )
        ]);
    }
}
