<?php

namespace DevOwl\RealCookieBanner\lite\presets\blocker;

use DevOwl\RealCookieBanner\comp\language\Hooks;
use DevOwl\RealCookieBanner\presets\pro\ProvenExpertWidgetPreset as PresetsProvenExpertWidgetPreset;
use DevOwl\RealCookieBanner\presets\pro\blocker\ProvenExpertWidgetPreset as BlockerProvenExpertWidgetPreset;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Proven Expert Widget blocker preset.
 */
class ProvenExpertWidgetPreset extends \DevOwl\RealCookieBanner\presets\pro\blocker\ProvenExpertWidgetPreset {
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        return \array_merge($parent, [
            'attributes' => \array_merge(
                [
                    'name' => $parent['name'],
                    'description' => __(
                        'Widget that shows ratings on Proven Expert has been blocked because you did not allow to load it.',
                        \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED
                    ),
                    'cookies' => [\DevOwl\RealCookieBanner\presets\pro\ProvenExpertWidgetPreset::IDENTIFIER],
                    'visual' => \true
                ],
                $parent['attributes']
            )
        ]);
    }
}
