<?php

namespace DevOwl\RealCookieBanner\lite\presets\blocker;

use DevOwl\RealCookieBanner\comp\language\Hooks;
use DevOwl\RealCookieBanner\presets\pro\ThriveLeadsPreset as PresetsThriveLeadsPreset;
use DevOwl\RealCookieBanner\presets\pro\blocker\ThriveLeadsPreset as BlockerThriveLeadsPreset;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Thrive Leads blocker preset.
 */
class ThriveLeadsPreset extends \DevOwl\RealCookieBanner\presets\pro\blocker\ThriveLeadsPreset {
    // Documented in AbstractPreset
    public function common() {
        $parent = parent::common();
        return \array_merge($parent, [
            'attributes' => \array_merge(
                [
                    'name' => $parent['name'],
                    'description' => __(
                        'We would like to offer you to subscribe to our newsletter. To do so, you would need to allow us to use the Thrive Leads service.',
                        \DevOwl\RealCookieBanner\comp\language\Hooks::TD_FORCED
                    ),
                    'cookies' => [\DevOwl\RealCookieBanner\presets\pro\ThriveLeadsPreset::IDENTIFIER],
                    'visual' => \true
                ],
                $parent['attributes']
            )
        ]);
    }
}
