<?php

namespace DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS;

use DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\CSSList\Document;
use DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Parsing\ParserState;
/**
 * Parser class parses CSS from text into a data structure.
 */
class Parser {
    private $oParserState;
    /**
     * Parser constructor.
     * Note that that iLineNo starts from 1 and not 0
     *
     * @param $sText
     * @param Settings|null $oParserSettings
     * @param int $iLineNo
     */
    public function __construct(
        $sText,
        \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Settings $oParserSettings = null,
        $iLineNo = 1
    ) {
        if ($oParserSettings === null) {
            $oParserSettings = \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Settings::create();
        }
        $this->oParserState = new \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Parsing\ParserState(
            $sText,
            $oParserSettings,
            $iLineNo
        );
    }
    public function setCharset($sCharset) {
        $this->oParserState->setCharset($sCharset);
    }
    public function getCharset() {
        $this->oParserState->getCharset();
    }
    public function parse() {
        return \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\CSSList\Document::parse($this->oParserState);
    }
}
