<?php

namespace DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\RuleSet;

use DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Property\AtRule;
/**
 * A RuleSet constructed by an unknown @-rule. @font-face rules are rendered into AtRuleSet objects.
 */
class AtRuleSet extends \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\RuleSet\RuleSet implements
    \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Property\AtRule {
    private $sType;
    private $sArgs;
    public function __construct($sType, $sArgs = '', $iLineNo = 0) {
        parent::__construct($iLineNo);
        $this->sType = $sType;
        $this->sArgs = $sArgs;
    }
    public function atRuleName() {
        return $this->sType;
    }
    public function atRuleArgs() {
        return $this->sArgs;
    }
    public function __toString() {
        return $this->render(new \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\OutputFormat());
    }
    public function render(\DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\OutputFormat $oOutputFormat) {
        $sArgs = $this->sArgs;
        if ($sArgs) {
            $sArgs = ' ' . $sArgs;
        }
        $sResult = "@{$this->sType}{$sArgs}{$oOutputFormat->spaceBeforeOpeningBrace()}{";
        $sResult .= parent::render($oOutputFormat);
        $sResult .= '}';
        return $sResult;
    }
}
