<?php

namespace DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Value;

class CSSFunction extends \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Value\ValueList {
    protected $sName;
    public function __construct($sName, $aArguments, $sSeparator = ',', $iLineNo = 0) {
        if ($aArguments instanceof \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\Value\RuleValueList) {
            $sSeparator = $aArguments->getListSeparator();
            $aArguments = $aArguments->getListComponents();
        }
        $this->sName = $sName;
        $this->iLineNo = $iLineNo;
        parent::__construct($aArguments, $sSeparator, $iLineNo);
    }
    public function getName() {
        return $this->sName;
    }
    public function setName($sName) {
        $this->sName = $sName;
    }
    public function getArguments() {
        return $this->aComponents;
    }
    public function __toString() {
        return $this->render(new \DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\OutputFormat());
    }
    public function render(\DevOwl\RealCookieBanner\Vendor\Sabberworm\CSS\OutputFormat $oOutputFormat) {
        $aArguments = parent::render($oOutputFormat);
        return "{$this->sName}({$aArguments})";
    }
}
