<?php

use League\OAuth2\Server\CryptKey;

class Oauth_AdminTokensController extends Am_Mvc_Controller_Grid
{
    function checkAdminPermissions(Admin $admin)
    {
        return $admin->hasPermission(Bootstrap_Oauth::ADMIN_PERMISSION_TOKENS);
    }
    
    function createGrid()
    {
        $ds = new Am_Query($this->getDi()->oauthAccessTokenTable);
        $ds->addWhere('is_manual>0');
        $ds->leftJoin('?_oauth_client', 'client', 'client.oauth_client_id = t.client_id');
        $ds->addField('client.name', 'client_name');
        $grid = new Am_Grid_Editable('_oauth_access_token', ___('Access Tokens'), $ds, $this->getRequest(),
            $this->getView(), $this->getDi());
        $grid->addCallback(Am_Grid_Editable::CB_RENDER_TITLE, function (&$out, $grid)
        {
            $out .= <<<CUT
<div class="info">
This controller allow to create manual tokens for clients who allowed to use <b>client_credentials</b> grant type.
</div>
CUT;
        });
        $grid->addField('comment', ___('Comment'));
        $grid->addField('client_name', ___('Client'));
        $grid->addField('scopes', ___('Permissions'), false)->setRenderFunction(function ($record)
        {
            return "<td>" . implode(", ", (array)json_decode($record->scopes, true)) . "</td>";
        });
        
        $grid->addField('expire', ___('Expiration Date'))->setFormatFunction('amDateTime');
        $grid->addField(new Am_Grid_Field_Expandable('token', ___('Token')))
            ->setGetFunction(function (OauthAccessToken $token)
            {
                return $token->convertToJWT(new CryptKey($this->getModule()->getConfig('private_key')));
            });
        
        $grid->actionsClear();
        $grid->actionAdd(
            new Am_Grid_Action_Url('_insert', ___('Generate New Access Token'),
                $this->getDi()->surl('oauth/admin-tokens/create'))
        )
            ->setType(Am_Grid_Action_Abstract::NORECORD)
            ->setTarget('_top');
        $grid->actionAdd(new Am_Grid_Action_Delete());
        return $grid;
    }
    
    function createForm()
    {
        $form = new Am_Form_Admin('_create_access_token');
        $form->addSelect('client_id', ['class' => 'am-combobox am-el-wide'])
            ->setLabel(___('Oauth Client'))
            ->loadOptions(['' => ''] + $this->getDi()->oauthClientTable->loadOptions())
            ->addRule('required');
        
        $form->addText('expire')->setLabel(___('Token Expire in days
        default lifetime'));
        
        $form->addText('comment', ['class' => 'am-el-wide'])
            ->setLabel(___('Comment'))
            ->addRule('required');
        
        $gr = $form->addGroup();
        $gr->addSubmit('generate', ['value' => ___('Generate Token')]);
        $url = $this->getDi()->surl('oauth/admin-tokens');
        $gr->addHtml()->setHtml(<<<CUT
    <a href="{$url}">Cancel</a>
CUT
        );
        
        return $form;
    }
    
    function createAction()
    {
        $form = $this->createForm();
        if ($form->isSubmitted() && $form->validate()) {
            $value = $form->getValue();
            /**
             * @var Bootstrap_Oauth $module ;
             * @var OauthClient $client ;
             */
            $module = $this->getModule();
            $client = $this->getDi()->oauthClientTable->load($value['client_id']);
            
            $scopes = [];
            foreach ($client->getAllowedScopes(Bootstrap_Oauth::GRANT_CLIENT_CREDENTIALS) as $scope) {
                $scopes[] = $module->getScopeRepository()->getScopeEntityByIdentifier($scope);
            }
            $token = $module
                ->getAuthorizationServer()
                ->getGrantTypeById(Bootstrap_Oauth::GRANT_CLIENT_CREDENTIALS)
                ->createManualAccessToken($client, !empty($value['expire'])?new DateInterval("P" . (intval($value['expire'])) . "D") : null,
                    $scopes, $value['comment']);
            $this->redirect($this->getDi()->surl('oauth/admin-tokens'));
        } else {
            $this->view->title = ___('Generate New Access Token');
            $this->view->form = $form;
            $this->view->display('admin/form.phtml');
            
        }
        
    }
}

