<?php

use League\OAuth2\Server\Exception\OAuthServerException;
use Zend\Diactoros\Stream;

class Oauth_RegisterDeviceController extends Am_Mvc_Oauth_Controller
{

    use Am_Oauth_Traits_GetModule;

    function indexAction()
    {

        try
        {
            $server = $this->getModule()->getResourceServer();

            $request = $this->getOauthRequest();


            $response = new Am_Mvc_Oauth_Response();

            $req = $request->getParsedBody();
            if(empty($req['client_id']))
            {
                throw OAuthServerException::invalidRequest('client_id');
            }
            
            $client = $this->getDi()->oauthClientTable->getClientEntity($req['client_id'], Bootstrap_Oauth::GRANT_AMEMBER_DEVICE, null, false);
            
            if(empty($client))
            {
                throw OAuthServerException::accessDenied();
            }
            
            $user_agent = $request->getHeaderLine('User-Agent');
            $remote_addr = $this->getRequest()->getClientIp();
            
            
            if (empty($req['description']))
            {
                throw OAuthServerException::invalidRequest('description');
            }
            $deviceRequest = [
                'device_name' => $req['description'],
                'user_agent' => $user_agent,
                'register_ip' => $remote_addr
            ];
            
            $device = $this->getDi()->oauthDeviceTable->registerDevice($deviceRequest);



            $body = new Stream('php://temp', 'r+');
            $resp = [
                'status' => 'OK',
                'data' => [
                    'amember_device_id' => $device->device_code
                ]
            ];

            $body->write(json_encode($resp));

            return $response->withStatus(200)->withHeader('Content-type', 'application/json')->withBody($body);
        }
        catch (OAuthServerException $exception)
        {

            return $exception->generateHttpResponse($this->getOauthResponse());
        }
        catch (\Exception $exception)
        {
            $body = new Stream('php://temp', 'r+');
            $body->write($exception->getMessage());
            return $this->getOauthResponse()->withStatus(500)->withBody($body);
        }
    }

}
