<?php
use League\OAuth2\Server\Exception\OAuthServerException;
use Zend\Diactoros\Stream;

class Oauth_ScopeController extends Am_Mvc_Oauth_Controller
{

    use Am_Oauth_Traits_GetModule;

    function indexAction()
    {

        try
        {
            $server = $this->getModule()->getResourceServer();
            $response = new Am_Mvc_Oauth_Response();
            
            $body = new Stream('php://temp', 'r+');
            $resp = [
                'status' => 'OK', 
                'data' => $server->getScopeRepository()->getAllScopes()
            ];
            
            $body->write(json_encode($resp));
            
            return $response->withStatus(200)->withHeader('Content-type', 'application/json')->withBody($body);
        }
        catch (OAuthServerException $exception)
        {

            return $exception->generateHttpResponse($this->getOauthResponse());
        }
        catch (\Exception $exception)
        {
            $body = new Stream('php://temp', 'r+');
            $body->write($exception->getMessage());
            return $this->getOauthResponse()->withStatus(500)->withBody($body);
        }
    }

}
