<?php

use League\OAuth2\Server\Exception\OAuthServerException;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Zend\Diactoros\Stream;

class Oauth_TokenController extends \Am_Mvc_Oauth_Controller
{

    use Am_Oauth_Traits_GetModule;

    function indexAction()
    {
        $server = $this->getModule()->getAuthorizationServer();

        try
        {
            return $server->respondToAccessTokenRequest($this->getOauthRequest(), $this->getOauthResponse());
        }
        catch (OAuthServerException $exception)
        {

            return $exception->generateHttpResponse($this->getOauthResponse());
        }
        catch (\Exception $exception)
        {
            $body = new Stream('php://temp', 'r+');
            $body->write($exception->getMessage());
            return $this->getOauthResponse()->withStatus(500)->withBody($body);
        }
    }

}
