<?php
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\RequestHandlerInterface;

class Am_Oauth_Api_Middleware_Device
{
    use Am_Oauth_Traits_GetModule;
    
    protected
        $scopes = [];


    function __invoke(ServerRequestInterface $request, RequestHandlerInterface $handler) : ResponseInterface
    {
        
        try
        {
            $device_id = $request->getHeaderLine('AMEMBER-DEVICE-ID');
             
            if(empty($device_id))
            {
                throw new Exception(___('AMEMBER-DEVICE-ID header is empty. Server require device registration.'));
            }
                   
            $device = $this->getModule()->getDi()->oauthDeviceTable->findFirstBy(['device_code' => $device_id]);
               
            if(empty($device) || $device->is_disabled)
            {
                throw new Exception(___('Device is not registered'));
            }
        }
        catch (\Exception $exception)
        {
            return new Am_Oauth_Api_Response_Forbidden($exception->getMessage());
        }

        return $handler->handle($request);
    }

}

