<?php

use Slim\Psr7\Request;

class Am_Oauth_Api_Request extends Request 
implements HTML_QuickForm2_DataSource_Submit, Am_Mvc_Request_Interface
{
    protected $parsedJson=[];
    protected $_di;
    protected $bodyParsers;
    
    
    function setDi(Am_Di $di)
    {
        $this->_di = $di;
    }
    
    function __construct(
        $method,
        \Psr\Http\Message\UriInterface $uri,
        \Slim\Psr7\Interfaces\HeadersInterface $headers,
        array $cookies,
        array $serverParams,
        \Psr\Http\Message\StreamInterface $body,
        array $uploadedFiles = []
    ) {
        parent::__construct($method, $uri, $headers, $cookies, $serverParams, $body, $uploadedFiles);
        $this->registerMediaTypeParser('application/json', function ($input) {
            $result = json_decode($input, true);
            if (!is_array($result)) {
                return null;
            }
            return $result;
        });
    
        $this->registerMediaTypeParser('application/x-www-form-urlencoded', function ($input) {
            parse_str($input, $data);
            return $data;
        });
    }
    
    /**
     * 
     * @return Am_Di $di
     */
    function getDi()
    {
        return $this->_di;
    }
    
    function getUserId()
    {
        return $this->getAttribute('oauth_user_id');
    }


    function getOauthClientId()
    {
        return $this->getAttribute('oauth_client_id');
    }
    
    /**
     * @return User $user|null
     */
        
    function getUser()
    {
        $user_id = $this->getUserId();
        
        if(!empty($user_id))
            return $this->getDi()->userTable->load($user_id);
        
    }

    /**
     * 
     * @return string[] $scopeRecords - List of requested scopes after all checks.
     */
    function getScopes()
    {
        return $this->getAttribute('oauth_scopes');
    }

    /**
     * 
     * @param string[] $scopes   Array of scopes to check;
     * @return string[]|false return scopes available in request after all checks, false if there is no requested scopes
     */
    function haveScope($scopes)
    {
        if (!is_array($scopes))
            $scopes = [$scopes];
        
        return array_intersect($scopes, $this->getScopes())?:false;
    }
    
    
    /**
     * 
     * @param type $name
     */
    function getValue($name)
    {
        return $this->getParam($name);
    }
    /**
     * @todo Implement later
     * @param type $name
     * @return type
     */
    function getUpload($name)
    {
        return null;  
    }
    
    /**
     * 
     * @return string $ip Yser IP address
     */
    function getClientIp()
    {
        return $this->getAttribute('ip_address');
    }
    
    function getParam($key, $default = null)
    {
        $source = $this->getMethod() === 'GET' ? $this->getQueryParams() : $this->getParsedBody();
        return $source[$key]??$default;
    }
    
    public function registerMediaTypeParser($mediaType, callable $callable)
    {
        if ($callable instanceof Closure) {
            $callable = $callable->bindTo($this);
        }
        $this->bodyParsers[(string)$mediaType] = $callable;
    }
    
    public function getContentType()
    {
        $result = $this->getHeader('Content-Type');
        
        return $result ? $result[0] : null;
    }
    public function getMediaType()
    {
        $contentType = $this->getContentType();
        if ($contentType) {
            $contentTypeParts = preg_split('/\s*[;,]\s*/', $contentType);
            
            return strtolower($contentTypeParts[0]);
        }
        
        return null;
    }
    
    public function getParsedBody()
    {
        if ($this->parsedBody !== null) {
            return $this->parsedBody;
        }
    
        if (!$this->body) {
            return null;
        }
        $mediaType = $this->getMediaType();
        
        // Check if this specific media type has a parser registered first
        if (!isset($this->bodyParsers[$mediaType])) {
            // If not, look for a media type with a structured syntax suffix (RFC 6839)
            $parts = explode('+', $mediaType);
            if (count($parts) >= 2) {
                $mediaType = 'application/' . $parts[count($parts)-1];
            }
        }
        
        if (isset($this->bodyParsers[$mediaType])) {
            $body = (string)$this->getBody();
            $parsed = $this->bodyParsers[$mediaType]($body);
            
            if (!is_null($parsed) && !is_object($parsed) && !is_array($parsed)) {
                throw new RuntimeException(
                    'Request body media type parser return value must be an array, an object, or null'
                );
            }
            $this->parsedBody = $parsed;
            return $this->parsedBody;
        }
        
        return null;
    }
    
}
