<?php

abstract
    class Am_Oauth_Api_Resource_Abstract
{

    use Am_Oauth_Traits_GetModule;

    const
        METHOD_POST = 'post';
    const
        METHOD_GET = 'get';
    const
        METHOD_PUT = 'put';
    const
        METHOD_DELETE = 'delete';

    protected
        $method, $endpoint, $scopes, $defaultScope, $_di;

    function setDi($di)
    {
        $this->_di = $di;
        return $this;
    }

    /**
     * 
     * @return \Am_Di $di
     */
    function getDi()
    {
        return $this->_di;
    }

    function setEndpoint($endpoint)
    {
        if (strpos($endpoint, '/api2') === false)
        {
            $endpoint = "/api2" . $endpoint;
        }
        $this->endpoint = $endpoint;
        return $this;
    }

    function getEndpoint()
    {
        return $this->endpoint;
    }

    function possibleMethods()
    {
        return [self::METHOD_DELETE, self::METHOD_GET, self::METHOD_POST, self::METHOD_PUT];
    }

    function getMethods()
    {
        return $this->method;
    }

    function getScopes()
    {
        return $this->scopes;
    }

    /**
     * Return Middleware;
     */
    abstract
        function getValidateScopesCallback($method);

    abstract
        function __invoke(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args);
}
