<?php
/**
 * @ApiAllowedGrantTypes GRANT_AUTHORIZATION_CODE, GRANT_PASSWORD, GRANT_CLIENT_CREDENTIALS, GRANT_AMEMBER_DEVICE
 * @ApiBaseEndpoint /agreement
 * @ApiBaseScope agreement
 */
class Am_Oauth_Api_Resource_Agreement extends Am_Oauth_Api_Resource_Object
{
    public function getDescription()
    {
        return ___('Get List of current agreement documents');
    }

    function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args){
        $data = [];
        foreach($request->getDi()->agreementTable->getTypes() as $type){
            $data[$type] = $request->getDi()->agreementTable->getCurrentByType($type);
        }
        return $response->withSuccessData($data, 200);
    }
}
