<?php


class Am_Oauth_Api_Resource_Callback extends Am_Oauth_Api_Resource_Abstract
{

    protected
        $callback;

    function __construct($endpoint = null, $methods = null, $scopes = null, $callback = null)
    {
        if (!empty($endpoint))
            $this->setEndpoint($endpoint);

        if (!empty($methods))
            $this->setMethod($methods);

        if (!empty($scopes))
            $this->setScopes($scopes);

        if (!empty($callback))
            $this->setCallback($callback);
    }

    function setScopes($scopes)
    {

        if (!is_array($scopes))
            $scopes = [$scopes];

        foreach ($scopes as $scope)
        {
            if (is_string($scope))
            {
                $this->scopes[] = $this->getModule()->getScopeRepository()->getScopeEntityByIdentifier($scope);
            }
            else if ($scope instanceof OauthScope)
            {
                $this->scopes[] = $scope;
            }
            else
            {
                throw new Am_Exception_InternalError("Invalid value for scopes");
            }
        }
        $this->scopes = $scopes;
        return $this;
    }

    function setMethod($method)
    {
        if (!is_array($method))
            $method = [$method];

        if ($unsup = array_diff($method, $this->possibleMethods()))
            throw new Am_Exception_InternalError("Unsupported methods: " . implode(", ", $unsup));

        $this->method = $method;
        return $this;
    }

    function setCallback($callback)
    {
        $this->callback = $callback;

        Closure::bind($this->callback, $this);

        return $this;
    }

    function getCallback()
    {
        return $this->callback;
    }

    public
        function __invoke(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        if (is_callable($this->callback))
            return call_user_func_array($this->callback, [$request, $response, $args]);
        else
            return new Am_Oauth_Api_Response_FatalError(___('Invalid callback'));
    }

    public
        function getValidateScopesCallback($method)
    {
        return new Am_Oauth_Api_Middleware_Scope($this->getScopes());
    }

}
