<?php

/**
 * @ApiAllowedGrantTypes GRANT_PASSWORD, GRANT_AUTHORIZATION_CODE, GRANT_IMPLICIT
 * @ApiBaseEndpoint /user/invoice/{invoice_id}/charge
 * @ApiBaseScope user.invoice.charge
 */
class Am_Oauth_Api_Resource_InvoiceCharge extends Am_Oauth_Api_Resource_Object
{
    function getDescription()
    {
        return ___('Setup charge on invoice object');
    }

    function post(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user_id = $request->getUserId();
        $invoice_id = @$args['invoice_id'];
        if (empty($invoice_id)) {
            return new Am_Oauth_Api_Response_BadRequest(___('Invoice ID is missing in incoming request'));
        }

        $invoice = $request->getDi()->invoiceTable->load($invoice_id, false);

        if (!$invoice) {
            return new Am_Oauth_Api_Response_BadRequest(___('Unable to load invoice object'));
        }

        if ($invoice->user_id != $user_id) {
            return new Am_Oauth_Api_Response_BadRequest(___('Security error. Invoice is related to another user.'));
        }

        $paysystem = $invoice->getPaysystem();

        if (!$paysystem->supportsTokenPayment()) {
            return new Am_Oauth_Api_Response_BadRequest(___("Token Payments are not supported by payment system"));
        }

        if (!in_array($invoice->status, [Invoice::RECURRING_ACTIVE, Invoice::PENDING])) {
            return new Am_Oauth_Api_Response_BadRequest(___("Attempt to charge invoice that should not be charged anymore"));
        }

        if (($invoice->status == Invoice::RECURRING_ACTIVE) && ($invoice->rebill_date > $request->getDi()->sqlDate)) {
            return new Am_Oauth_Api_Response_BadRequest(___("Attempt to charge invoice before rebill date. (%s)",
                $invoice->rebill_date));
        }

        $paysystem->_setInvoice($invoice);
        try {
            $result = $paysystem->processTokenPayment($invoice, $request->getParam('token'));
        } catch (Exception $ex) {
            return new Am_Oauth_Api_Response_BadRequest(___('Unable to process charge: %s', $ex->getMessage()));
        }

        $invoice->refresh();

        if ($result->isSuccess()) {
            $result->thanks_url = $paysystem->getReturnUrl();
        }

        $invoice->chargeResult = $result;

        return $response->withSuccessInvoice($invoice);
    }
}
