<?php

/**
 * @ApiAllowedGrantTypes GRANT_AUTHORIZATION_CODE, GRANT_PASSWORD
 * @ApiBaseEndpoint /user/confirm-email
 * @ApiBaseScope user.confirm-email
 */
class Am_Oauth_Api_Resource_UserConfirmEmail extends Am_Oauth_Api_Resource_Object
{
    function getDescription()
    {
        return ___('Send confirmation email to user/confirm email address');
    }

    function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();

        if($user->email_confirmed)
        {
            return $response->withSuccessData([], 200, 'OK', ___('Email address was confirmed already'));
        }

        $this->getModule()->sendConfirmationEmail($user);

        return $response->withSuccessData([], 200, 'OK', ___('Confirmation message was sent'));
    }

    function post(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();

        $code = $request->getParam('code');
        if($this->getModule()->confirmEmailAddress($user, $code))
        {
            return $response->withSuccessData([], 200, 'OK', ___('Email address was confirmed'));
        }
        return new Am_Oauth_Api_Response_ValidationError(___('Wrong or expired confirmation code'));
    }

}
