<?php
/**
 * Scopes
 */

/**
 * Retrieve user access records;
 * GET /api2/user/newsletter/lists 
 * 
 */
/**
 * @ApiAllowedGrantTypes GRANT_PASSWORD, GRANT_AUTHORIZATION_CODE
 * @ApiBaseEndpoint /user/newsletter/lists
 * @ApiBaseScope user.newsletter.lists
 */
class Am_Oauth_Api_Resource_UserNewsletterLists  extends Am_Oauth_Api_Resource_Object
{
    public function getDescription()
    {
        return ___('Get Newsletter Lists Available for Subscribe');
    }

    function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $lists = $this->getDi()->newsletterListTable->getAllowed($request->getUser());
        $resp = [];
        foreach($lists as $list)
        {
            $resp[] = [
                'list_id' => $list->pk(),
                'title' => $list->title,
                'description' => $list->desc
            ];
        }
        return $response->withSuccessData($resp);
    }
}
