<?php

/**
 * @ApiAllowedGrantTypes GRANT_PASSWORD, GRANT_AUTHORIZATION_CODE
 * @ApiBaseEndpoint /user/newsletter/subscription
 * @ApiBaseScope user.newsletter.subscription
 */
class Am_Oauth_Api_Resource_UserNewsletterSubscription  extends Am_Oauth_Api_Resource_Object
{

    public function getDescription()
    {
        return ___("Get user's current newsletter subscriptions. Subscribe/Unsubscribe lists");
    }

    function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();
        return $response->withSuccessData($request->getDi()->newsletterUserSubscriptionTable->getSubscribedIds($user->pk()));

    }

    function post(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();
        $list_id = $request->getParam('list_id');

        if(empty($list_id))
        {
            return new Am_Oauth_Api_Response_ValidationError(___("list_id can't be empty"));
        }
        if(!is_array($list_id))
        {
            $list_id = [$list_id];
        }

        foreach ($list_id as $v)
        {

            $list = $this->getDi()->newsletterListTable->load($v);

            $this->getDi()->userConsentTable->recordConsent($user,
                    'newsletter-list-'.$v,
                    $request->getClientIp(),
                    ___('Subscribed from Oauth App: %s', $request->getAttribute('oauth_client_id')),
                    $list->title
                    );

                $this->getDi()->newsletterUserSubscriptionTable->add($user,
                    $list,
                    NewsletterUserSubscription::TYPE_USER);
        }


        return $this->get($request, $response, $args);
    }

    function delete(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();
        $list_id = $request->getParam('list_id');

        if(empty($list_id))
        {
            return new Am_Oauth_Api_Response_ValidationError(___("list_id can't be empty"));
        }
        if(!is_array($list_id))
        {
            $list_id = [$list_id];
        }

        $subs = [];
        foreach ($this->getDi()->newsletterUserSubscriptionTable->findByUserId($user->pk()) as $s)
            $subs[$s->list_id] = $s;

        foreach ($list_id as $v)
        {
                if (!empty($subs[$v])){
                    $subs[$v]->unsubscribe();
                    $this->getDi()->userConsentTable->cancelConsent($user,
                        'newsletter-list-'.$v,
                        $request->getClientIp(),
                        ___('Unsubscribed from Oauth App: %s', $request->getAttribute('oauth_client_id'))
                        );
                }
        }

        return $this->get($request, $response, $args);
    }

}

