<?php

use Slim\Psr7\Response;
use Slim\Psr7\Stream;

class Am_Oauth_Api_Response extends Response
{
    function withSuccessData($data, $status=200, $state='OK', $msg=null)
    {
        $ret = [
            'status' => $state,
            'data' => $data,
            ];

        if(!is_null($msg))
        {
            $ret['message'] = $msg;
        }

        return $this->withJson($ret, $status);
    }
    function withDataAndNewToken($data, $status=200, $token)
    {
        $ret = [
            'status' => 'OK',
            'data' => $data,
            'access-token' => $token
            ];

        return $this->withJson($ret, $status);
    }


    function withSuccessInvoice($invoice, $status=200)
    {
        if(!is_array($invoice))
        {
            $invoice = [$invoice];
        }
        foreach($invoice as $key=>$value)
        {
            $invoice[$key]->items = $value->getItems();
            $invoice[$key]->payments = $value->getPaymentRecords();
            $invoice[$key]->refunds = $value->getRefundRecords();
            $invoice[$key]->access = $value->getAccessRecords();

        }
        return $this->withSuccessData(count($invoice)==1?array_shift($invoice) : $invoice, $status);
    }
    
    public function withJson($data, $status = null, $encodingOptions = 0)
    {
        $response = $this->withBody(new Stream(fopen('php://temp', 'r+')));
        $response->body->write($json = json_encode($data, $encodingOptions));
        
        // Ensure that the json encoding passed successfully
        if ($json === false) {
            throw new RuntimeException(json_last_error_msg(), json_last_error());
        }
        
        $responseWithJson = $response->withHeader('Content-Type', 'application/json');
        if (isset($status)) {
            return $responseWithJson->withStatus($status);
        }
        return $responseWithJson;
    }
}
