<?php

use League\OAuth2\Server\Grant\ClientCredentialsGrant;

class Am_Oauth_Grant_ClientCredentials extends ClientCredentialsGrant implements Am_Oauth_Grant_Interface
{
    
    public
    function getDescription()
    {
        return <<<CUT
Suitable for machine-to-machine authentication, when you need to make requests that are not require user's permission.
CUT;
    }
    
    function createManualAccessToken(OauthClient $client, $expire=null, $scopes = [], $comment="")
    {
        $token = $this->issueAccessToken(
            $expire?:(new DateInterval('P30D')),
            $client, null, $scopes);
        
        $token->updateQuick([
            'is_manual' => 1,
            'comment' => $comment,
            'expire' => $expire?$token->expire:Am_Period::MAX_SQL_DATE
        ]);
        return $token;
    }
    
}
