<?php

use League\OAuth2\Server\Exception\OAuthServerException;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\RequestHandlerInterface;

class Am_Oauth_Server_Resource_Middleware{
    /**
     * @var Am_Oauth_Server_Resource
     */
    private $server;
    
    public function __construct(Am_Oauth_Server_Resource $server)
    {
        $this->server = $server;
    }
    
    public function __invoke(ServerRequestInterface $request, RequestHandlerInterface $handler) : ResponseInterface
    {
        try {
            $request = $this->server->validateAuthenticatedRequest($request);
        } catch (OAuthServerException $exception) {
            return $exception->generateHttpResponse(new Am_Oauth_Api_Response());
        } catch (Exception $exception) {
            return new Am_Oauth_Api_Response_FatalError($exception->getMessage());
        }
        
        // Pass the request and response on to the next responder in the chain
        return $handler->handle($request);
    }
    

}