<?php

use League\OAuth2\Server\Repositories\AccessTokenRepositoryInterface;
use League\OAuth2\Server\Entities\AccessTokenEntityInterface;
use League\OAuth2\Server\Entities\ScopeEntityInterface;
use League\OAuth2\Server\Entities\ClientEntityInterface;
use League\OAuth2\Server\Entities\Traits\AccessTokenTrait;

class OauthAccessToken extends Am_Record implements AccessTokenEntityInterface
{

    use AccessTokenTrait,
        Am_Oauth_Traits_Token_Revoke,
        Am_Oauth_Traits_Token_Expire,
        Am_Oauth_Traits_Token_Client,
        Am_Oauth_Traits_Token_UserIdentifier,
        Am_Oauth_Traits_Token_Scopes;
        


    public
        function getIdentifier()
    {
        return $this->token;
    }



    public
        function setIdentifier($identifier)
    {
        $this->token = $identifier;
    }

}

class OauthAccessTokenTable extends Am_Table implements AccessTokenRepositoryInterface
{

    use \Am_Oauth_Traits_Token_CleanUp;

    protected
        $_key = 'oauth_access_token_id';
    protected
        $_table = '?_oauth_access_token';
    protected
        $_recordClass = 'OauthAccessToken';

    public
        function getNewToken(ClientEntityInterface $clientEntity, array $scopes, $userIdentifier = null)
    {
        $token = $this->getDi()->oauthAccessTokenRecord;

        $token->setClient($clientEntity);

        foreach ($scopes as $scope)
        {
            $token->addScope($scope);
        }

        $token->setUserIdentifier($userIdentifier);

        return $token;
    }

    public
        function isAccessTokenRevoked($tokenId)
    {
        $token = $this->findFirstBy(['token' => $tokenId]);
        if(!$token)
            return true;
        return $token->isRevoked();
    }

    public
        function persistNewAccessToken(AccessTokenEntityInterface $accessTokenEntity)
    {
        $accessTokenEntity->save();
    }

    public
        function revokeAccessToken($tokenId)
    {
        $token = $this->findFirstBy(['token' => $tokenId]);
        
        if (!$token)
            return;

        $token->revoke();
    }

}
