<?php
class OauthDevice extends \Am_Record 
{

}

class OauthDeviceTable extends \Am_Table 
{

    protected
        $_key = 'oauth_device_id';
    protected
        $_table = '?_oauth_device';
    protected
        $_recordClass = 'OauthDevice';
    
    function generateUniqueCode()
    {
        do{
            $device_code = bin2hex(random_bytes(32));
        }while($this->findFirstBy(['device_code'=>$device_code]));
        return $device_code;
    }
    function registerDevice(array $deviceRequest)
    {
        $deviceRequest['device_code'] = $this->generateUniqueCode();
        
        $deviceRequest['register_date'] = $this->getDi()->sqlDateTime;
        
        $record = $this->createRecord()->fromRow($deviceRequest);
        
        $record->insert();
        
        return $record;
    }
}

