<?php

use League\OAuth2\Server\Repositories\UserRepositoryInterface;
use League\OAuth2\Server\Entities\UserEntityInterface;

class OauthUser extends \User implements UserEntityInterface
{
    
    public
    function getIdentifier()
    {
        return $this->pk();
    }
    
    function getOauthConsent($client_id)
    {
        $scope = $this->getDi()->db->selectCell("
                            SELECT scope
                            FROM ?_oauth_user_consent
                            WHERE user_id=? AND  client_id=? AND is_revoked IS NULL
                            ", $this->pk(), $client_id);
        if (empty($scope)) {
            return false;
        }
        return json_decode($scope, true);
    }
    
    function setOauthConsent($client_id, $scopes)
    {
        $_ = [];
        foreach ($scopes as $scope) {
            if ($scope instanceof OauthScope) {
                $_[] = $scope->getIdentifier();
            } else {
                $_[] = $scope;
            }
        }
        $_ = json_encode($_);
        $this->getDi()->db->query("
                INSERT INTO ?_oauth_user_consent
                (user_id, client_id, scope, added)
                VALUES (?, ?, ?, now())
                ON DUPLICATE KEY UPDATE scope=?, is_revoked=NULL, added=now()
                ", $this->pk(), $client_id, $_, $_);
    }
    
    
}

class OauthUserTable extends \UserTable implements UserRepositoryInterface
{
    protected $_recordClass = 'OauthUser';
    
    public
    function getUserEntityByUserCredentials(
        $username,
        $password,
        $grantType,
        \League\OAuth2\Server\Entities\ClientEntityInterface $clientEntity
    ) {
        
        $user = $this->getByLoginOrEmail($username);
        
        if ($user && $user->checkPassword($password)) {
            return $user;
        }
    }
    
    
}
