package co.pixelbeard.theanfieldwrap.accountDetails;

import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface AccountDetailsContract {

    interface View extends BaseView<Presenter> {
        void showFirstNameError();

        void showLastNameError();

        void showInvalidUserNameError();

        void showUserNameNotAvailableError();

        void enableButton();

        void disableButton();

        void setUserNameAvailable(boolean isAvailable);

        void showSingleButtonDialog(String error, String message);

    }

    interface Presenter extends BasePresenter {
        boolean validateFields(String firstName, String lastName, String userName, boolean shouldShowError);

        void checkUserNameAvailable(String userName);

        void updateUserDetails(String firstName, String lastName, String userName);

        boolean checkForChanges(String firstName, String lastName, String userName);

    }
}