package co.pixelbeard.theanfieldwrap.data.responses;

import com.google.gson.annotations.SerializedName;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Article;
import co.pixelbeard.theanfieldwrap.networking.BaseResponse;

public class ArticlesResponse extends BaseResponse {

    @SerializedName("context")
    String context;
    @SerializedName("feed")
    List<Article> articles;

    public ArticlesResponse() {
    }

    public ArticlesResponse(boolean success, String message, String context, List<Article> articles) {
        super(success, message);
        this.context = context;
        this.articles = articles;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public List<Article> getArticles() {
        return articles;
    }

    public void setArticles(List<Article> articles) {
        this.articles = articles;
    }
}
