package co.pixelbeard.theanfieldwrap.data.responses;

import com.google.gson.annotations.SerializedName;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Device;
import co.pixelbeard.theanfieldwrap.data.User;
import co.pixelbeard.theanfieldwrap.networking.BaseResponse;

public class LoginResponse extends BaseResponse {

    @SerializedName("auth_token")
    String authToken;
    @SerializedName("user")
    User user;
    @SerializedName("devices")
    List<Device> deviceList;

    public LoginResponse() {
    }

    public LoginResponse(boolean success, String message, String authToken, User user, List<Device> deviceList) {
        this.setSuccess(success);
        this.setMessage(message);
        this.authToken = authToken;
        this.user = user;
        this.deviceList = deviceList;
    }

    public List<Device> getDeviceList() {
        return deviceList;
    }

    public void setDeviceList(List<Device> deviceList) {
        this.deviceList = deviceList;
    }

    public String getAuthToken() {
        return authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}
