package co.pixelbeard.theanfieldwrap.data.source;

import android.content.Context;
import android.os.Handler;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.NotificationSetting;
import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.data.RealmPodcast;
import co.pixelbeard.theanfieldwrap.data.User;
import co.pixelbeard.theanfieldwrap.data.responses.ArticleByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.ArticlesResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GetDevicesResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GetWalletResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GuestUserResponse;
import co.pixelbeard.theanfieldwrap.data.responses.LoginResponse;
import co.pixelbeard.theanfieldwrap.data.responses.NotificationSettingsResponse;
import co.pixelbeard.theanfieldwrap.data.responses.PodcastByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.PodcastsResponse;
import co.pixelbeard.theanfieldwrap.data.responses.RegisterUserResponse;
import co.pixelbeard.theanfieldwrap.data.responses.SubscriptionItemResponse;
import co.pixelbeard.theanfieldwrap.data.responses.VideoByIdResponse;
import co.pixelbeard.theanfieldwrap.data.responses.VideosResponse;
import co.pixelbeard.theanfieldwrap.data.source.local.LocalRepository;
import co.pixelbeard.theanfieldwrap.data.source.remote.RemoteRepository;
import co.pixelbeard.theanfieldwrap.freeSubscription.ActiveSubscriptionResponse;
import io.reactivex.Observable;

public class DataRepository implements DataSource {

    private LocalRepository mLocal;
    private RemoteRepository mRemote;


    public DataRepository(LocalRepository local, RemoteRepository remote) {
        this.mLocal = local;
        this.mRemote = remote;
    }

    @Override
    public Observable<GenericResponse> recordAnalytic(String type, String variable, String secondaryVariable) {
        return mRemote.recordAnalytic(type, variable, secondaryVariable);
    }

    @Override
    public Observable<LoginResponse> login(String email, String password) {
        return mRemote.login(email, password);
    }

    @Override
    public void saveUserDetails(User user, String authToken) {
        mLocal.saveUserDetails(user, authToken);
    }

    @Override
    public void saveUserDetails(String firstName, String lastName, String userName) {
        mLocal.saveUserDetails(firstName, lastName, userName);
    }

    @Override
    public Observable<GuestUserResponse> registerGuestUser() {
        return mRemote.registerGuestUser();
    }

    @Override
    public void saveGuestUserDetails(String userName, String authToken) {
        mLocal.saveGuestUserDetails(userName, authToken);
    }

    @Override
    public Observable<RegisterUserResponse> registerFullUser(String firstName, String lastName, String email, String password, boolean optIn, String username, String country) {
        return mRemote.registerFullUser(firstName, lastName, email, password, optIn, username, country);
    }

    @Override
    public Observable<GenericResponse> checkEmailAvailable(String email) {
        return mRemote.checkEmailAvailable(email);
    }

    @Override
    public Observable<GenericResponse> checkUsernameAvailable(String username) {
        return mRemote.checkUsernameAvailable(username);
    }

    @Override
    public Observable<GenericResponse> resendAuthCode(String email) {
        return mRemote.resendAuthCode(email);
    }

    @Override
    public Observable<GenericResponse> activateUser(String email, String activationCode) {
        return mRemote.activateUser(email, activationCode);
    }

    @Override
    public Observable<GenericResponse> changePassword(String oldPassword, String newPassword) {
        return mRemote.changePassword(oldPassword, newPassword);
    }

    @Override
    public Observable<NotificationSettingsResponse> getUserSettings() {
        return mRemote.getUserSettings();
    }

    @Override
    public List<NotificationSetting> getUserSettingsLocal() {
        return mLocal.getUserSettingsLocal();
    }

    @Override
    public void saveUserSettings(List<NotificationSetting> settings) {
        mLocal.saveUserSettings(settings);
    }

    @Override
    public Observable<GenericResponse> updateUserSetting(String type, int value) {
        return mRemote.updateUserSetting(type, value);
    }

    @Override
    public Observable<GenericResponse> updateUserEmail(String oldEmail, String newEmail) {
        return mRemote.updateUserEmail(oldEmail, newEmail);
    }

    @Override
    public Observable<GenericResponse> updateUserDetails(String firstName, String lastName, String userName) {
        return mRemote.updateUserDetails(firstName, lastName, userName);
    }

    @Override
    public Observable<GenericResponse> requestPasswordReset(String email) {
        return mRemote.requestPasswordReset(email);
    }

    @Override
    public Observable<GenericResponse> resetPassword(String email, String recoveryCode, String password) {
        return mRemote.resetPassword(email, recoveryCode, password);
    }

    @Override
    public Observable<GenericResponse> logout() {
        new Handler().postDelayed(() -> {
            if (mLocal != null) {
                mLocal.logout();
            }
        }, 500);
        return mRemote.logout();
    }

    @Override
    public void clearAllData(Context context) {
        mLocal.clearAllData(context);
    }

    @Override
    public Observable<PodcastsResponse> getPodcasts(int pageNum) {
        return mRemote.getPodcasts(pageNum);
    }

    @Override
    public Observable<PodcastByIdResponse> getPodcastByIdRemote(Long podcastId) {
        return mRemote.getPodcastByIdRemote(podcastId);
    }

    @Override
    public Observable<ArticlesResponse> getArticles(int pageNum) {
        return mRemote.getArticles(pageNum);
    }

    @Override
    public Observable<ArticleByIdResponse> getArticleById(Long articleId) {
        return mRemote.getArticleById(articleId);
    }

    @Override
    public Observable<VideosResponse> getVideos(int pageNum) {
        return mRemote.getVideos(pageNum);
    }

    @Override
    public Observable<VideoByIdResponse> getVideoById(String videoId) {
        return mRemote.getVideoById(videoId);
    }

    @Override
    public Observable<LoginResponse> checkUserSubscription() {
        return mRemote.checkUserSubscription();
    }

    @Override
    public Observable<GenericResponse> convertGuestToFullUser(String firstName, String lastName, String email, String password, boolean optIn, String username, String country) {
        return mRemote.convertGuestToFullUser(firstName, lastName, email, password, optIn, username, country);
    }

    @Override
    public void getDownloadedPodcasts(DownloadedPodcastCallback callback) {
        mLocal.getDownloadedPodcasts(callback);
    }

    @Override
    public void downloadPodcast(Podcast podcast, Context context) {
        mRemote.downloadPodcast(podcast, context);
    }

    @Override
    public void savePodcast(Podcast podcast, String filePath) {
        mLocal.savePodcast(podcast, filePath);
    }

    @Override
    public RealmPodcast getPodcastByIdLocal(long id) {
        return mLocal.getPodcastByIdLocal(id);
    }

    @Override
    public Observable<GetDevicesResponse> getActiveDevices() {
        return mRemote.getActiveDevices();
    }

    @Override
    public Observable<GenericResponse> unlinkDevice(String userApiToken, int deviceId) {
        return mRemote.unlinkDevice(userApiToken, deviceId);
    }

    @Override
    public Observable<GetWalletResponse> getWallet() {
        return mRemote.getWallet();
    }

    @Override
    public Observable<GetWalletResponse> creditUserAccount(int value, String title, String purchaseToken) {
        return mRemote.creditUserAccount(value, title, purchaseToken);
    }

    @Override
    public Observable<GetWalletResponse> purchaseItem(String productId) {
        return mRemote.purchaseItem(productId);
    }

    @Override
    public void getPodcastStates(PodcastStateCallback callback) {
        mLocal.getPodcastStates(callback);
    }

    @Override
    public void clearPodcastStates() {
        mLocal.clearPodcastStates();
    }

    @Override
    public void getPodcastState(long podcastId, int position, PodcastStateCallback callback) {
        mLocal.getPodcastState(podcastId, position, callback);
    }

    @Override
    public Observable<SubscriptionItemResponse> getSubscription() {
        return mRemote.getSubscription();
    }

    @Override
    public Observable<ActiveSubscriptionResponse> activeSubscription(String subscription_plan) {
        return mRemote.activeSubscription(subscription_plan);
    }

    @Override
    public Observable<ActiveSubscriptionResponse> activePaidSubscription(String subscription_plan, String planType, int duration,String purchaseToken) {
        return mRemote.activePaidSubscription(subscription_plan, planType, duration,purchaseToken);
    }


    public void onDestroyRepo() {
//        mLocal.onDestroyRepo();
//        mRemote.onDestroyRepo();

//        mLocal = null;
//        mRemote = null;
    }


}
