package co.pixelbeard.theanfieldwrap.editEmail;

import android.content.Context;
import android.util.Log;

import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.networking.CallbackWrapper;
import co.pixelbeard.theanfieldwrap.utils.PrefKey;
import co.pixelbeard.theanfieldwrap.utils.PrefUtils;
import co.pixelbeard.theanfieldwrap.utils.ValidationUtils;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class EditEmailPresenter implements EditEmailContract.Presenter {

    private EditEmailContract.View mView;
    private DataRepository mRepo;


    public EditEmailPresenter(EditEmailContract.View view, DataRepository repo) {
        if (view != null && repo != null) {
            this.mView = view;
            this.mRepo = repo;

            mView.setPresenter(this);
        }
    }

    @Override
    public boolean validateEmail(String email, boolean shouldShowError) {
        boolean valid = true;

        if (!ValidationUtils.isValidEmail(email)) {
            valid = false;
            if (shouldShowError) {
                mView.showInvalidEmailError();
            }
        }

        if (valid) {
            mView.enableButton();
        } else {
            mView.disableButton();
        }

        return valid;
    }

    @Override
    public void updateEmail(String email) {

        if (mView != null && mView.checkConnection()) {
            mView.showLoader("");
            mRepo.updateUserEmail(PrefUtils.getInstance().getStringPref(PrefKey.EMAIL), email).subscribe(new CallbackWrapper<GenericResponse>(mView) {
                @Override
                protected void onSuccess(GenericResponse genericResponse) {
                    if (mView != null) {
                        mView.goBack();
                        PrefUtils.getInstance().putStringPref(PrefKey.EMAIL, email);
                    }
                }

                @Override
                protected void onSuccessFalse(GenericResponse genericResponse) {
                    if (mView != null) {
                        mView.showEmailError(genericResponse.getMessage());
                    }
                }
            });

        } else {
            if (mView != null) {
                mView.onConnectionError();
            }
        }
    }

    @Override
    public void checkEmailAvailable(String email) {
        if (mView != null && mView.checkConnection()) {
            mRepo.checkEmailAvailable(email).subscribe(new CallbackWrapper<GenericResponse>(mView) {
                @Override
                protected void onSuccess(GenericResponse genericResponse) {
                    if (mView != null) {
                        mView.setEmailAvailable(true);
                    }
                }

                @Override
                protected void onSuccessFalse(GenericResponse genericResponse) {
                    if (mView != null) {
                        mView.setEmailAvailable(false);
                        mView.showEmailNotAvailableError();
                        mView.disableButton();
                    }
                }
            });
        } else {
            if (mView != null)
                mView.onConnectionError();
        }

    }

    @Override
    public boolean checkForChanges(String newEmail) {
        return !newEmail.toLowerCase().equals(PrefUtils.getInstance().getStringPref(PrefKey.EMAIL));
    }

    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {
//        this.mView = null;
//        this.mRepo.onDestroyRepo();
//
//        this.mRepo = null;
    }

    @Override
    public void clearUserData(Context context) {
        mRepo.logout().subscribe(new Observer<GenericResponse>() {
            @Override
            public void onSubscribe(Disposable d) {

            }

            @Override
            public void onNext(GenericResponse genericResponse) {
                Log.d("LOGOUT", genericResponse.getMessage());
            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onComplete() {

            }
        });
        //TODO test this
//        mRepo.clearAllData(context);
    }
}
