package co.pixelbeard.theanfieldwrap.networking;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import com.jaredrummler.android.device.DeviceName;

import java.util.concurrent.TimeUnit;

import co.pixelbeard.theanfieldwrap.BuildConfig;
import co.pixelbeard.theanfieldwrap.utils.TawController;
import co.pixelbeard.theanfieldwrap.utils.TextUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@SuppressLint("HardwareIds")
public class ApiClient {

    private static final String TAG = ApiClient.class.getSimpleName();

    private static Retrofit retrofit = null;
    private static ApiInterface apiService = null;

    public static synchronized Retrofit getClient(Context context) {
        if (retrofit == null) {

            Gson gson = new GsonBuilder()
                    .setLenient()
                    .create();

            OkHttpClient client;// = new OkHttpClient();

            OkHttpClient.Builder builder = new OkHttpClient.Builder();

            String androidId = TawController.getUniqueId();

            builder.connectTimeout(1, TimeUnit.MINUTES)
                    .writeTimeout(1, TimeUnit.MINUTES)
                    .readTimeout(1, TimeUnit.MINUTES)
                    .addInterceptor(chain -> {
                        Request request = chain.request().newBuilder()
                                .addHeader(NetworkConstants.HEADER_API_TOKEN, NetworkConstants.API_TOKEN)
                                .addHeader("device", androidId)
                                .addHeader("device-name", TextUtils.capitalise(Build.MANUFACTURER) + " " + DeviceName.getDeviceName())
                                .addHeader("app-version", BuildConfig.VERSION_NAME)
                                .build();
                        return chain.proceed(request);
                    })
                    .build();

            if (BuildConfig.DEBUG) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BODY);
                builder.addInterceptor(logging);
            }
            client = builder.build();

            retrofit = new Retrofit.Builder()
                    .baseUrl(BuildConfig.BASE_URL)
                    .client(client)
                    .addConverterFactory(GsonConverterFactory.create(gson))
                    .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                    .build();
        }

        return retrofit;
    }

    public static synchronized ApiInterface getApiService(Context context) {

        if (apiService == null) {
            apiService = ApiClient.getClient(context).create(ApiInterface.class);
        }

        return apiService;
    }


    public static synchronized ApiInterface getApiService() {

        if (apiService == null) {
            throw new RuntimeException("Must be called in application class first with CONTEXT");
        }

        return apiService;
    }


}
