package co.pixelbeard.theanfieldwrap.signUp.auth;

import android.content.DialogInterface;

import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface SignUpAuthCodeContract {

    interface View extends BaseView<Presenter> {
        void showInvalidAuthCodeError();

        void showIncorrectAuthCodeError();

        void enableButton();

        void disableButton();

        void hideLoader();

        void showSingleButtonDialog(String title, String body, DialogInterface.OnDismissListener listener);

        void startHomeActivity();

        void startLoginActivity();

        void finishSignUpActivity();

        void showNoConnectionHeader();
    }

    interface Presenter extends BasePresenter {
        boolean validateField(String authCode, boolean shouldShowError);

        void activateUser(String email, String password, String activationCode, boolean fromLogin, boolean fromGuest);
    }
}