package co.pixelbeard.theanfieldwrap.signUp.name;

import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface SignUpNameContract {

    interface View extends BaseView<Presenter> {
        void showFirstNameError();

        void showLastNameError();

        void showInvalidUserNameError();

        void showUserNameNotAvailableError();

        void enableButton();

        void disableButton();

        void setUserNameAvailable(boolean isAvailable);

        void showNoConnectionHeader();
    }

    interface Presenter extends BasePresenter {

        boolean validateFields(String firstName, String lastName, String userName, boolean shouldShowError);

        void checkUserNameAvailable(String userName);
    }
}