package co.pixelbeard.theanfieldwrap.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

import co.pixelbeard.theanfieldwrap.billing.BillingConstants;
import co.pixelbeard.theanfieldwrap.data.responses.SubscriptionItemResponse;

public class DateUtils {

    public static String getTimeStampString(int millis) {
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        long mins = TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis));
        long secs = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis));

        String time;

        if (hours > 0) {
            time = String.format(Locale.getDefault(), "%02d:%02d:%02d",
                    hours, mins, secs);
        } else {
            time = String.format(Locale.getDefault(), "%02d:%02d",
                    mins, secs);
        }


        return time;
    }


    public static String getDateddMMYYYY(String dateFromApi) {
        Date sourceDate = getApiDate(dateFromApi);


        if (sourceDate != null) {
            SimpleDateFormat targetFormat = new SimpleDateFormat("dd MMM yyyy", Locale.getDefault());
            return targetFormat.format(sourceDate);
        } else {
            return "";
        }
    }


    private static Date getApiDate(String dateString) {

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        Date sourceDate = null;
        try {
            if (dateString != null) {
                sourceDate = dateFormat.parse(dateString);
            } else {
                sourceDate = new Date();
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return sourceDate;
    }

    public static SubscriptionItemResponse mockSubscriptionData() {
        SubscriptionItemResponse response = new SubscriptionItemResponse();
        List<SubscriptionItemResponse.FreeSubscription> items = new ArrayList<>();
        items.add(new SubscriptionItemResponse.FreeSubscription("7",BillingConstants.VIDEO));
        items.add(new SubscriptionItemResponse.FreeSubscription("9", BillingConstants.PREMIUM));
        items.add(new SubscriptionItemResponse.FreeSubscription("8",BillingConstants.AUDIO));
        response.setFreeSubscriptions(items);
        return response;
    }
}
