package co.pixelbeard.theanfieldwrap.utils;

import android.content.Context;

import java.util.ArrayList;
import java.util.List;

import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.data.Subscription;

public class SubscriptionUtils {

    public static final int USER_SUBSCRIPTION_SKELETON = 1;
    public static final int USER_SUBSCRIPTION_VIDEO = 7;
    public static final int USER_SUBSCRIPTION_AUDIO = 8;
    public static final int USER_SUBSCRIPTION_FULL = 9;

    public static final int POD_SUB_LEVEL_FREE = 0;
    public static final int POD_SUB_LEVEL_SKELETON = 1;
    public static final int POD_SUB_LEVEL_PREMIUM = 2;

    public static boolean userCanAccessAudio(List<Subscription> userSubs, Podcast podcast) {

        boolean canAccess = false;

        int userSubLevel = -1;

        if (podcast.isPurchased()) {
            return true;
        }

        if (userSubs != null) {
            if (userSubs.size() == 1) {
                userSubLevel = userSubs.get(0).getSubscriptionAuthLevel();
            } else {

                List<Integer> list = new ArrayList<>();

                for (int i = 0; i < userSubs.size(); i++) {

                    Subscription sub = userSubs.get(i);
                    list.add(sub.getSubscriptionAuthLevel());

                    if (sub.getSubscriptionAuthLevel() > userSubLevel) {
                        userSubLevel = sub.getSubscriptionAuthLevel();
                    }
                }


//                if(list.contains(7) && list.contains(8)){
//                    userSubLevel = 9;
//                }
            }

        }


        switch (podcast.getSubLevel()) {
            case POD_SUB_LEVEL_FREE:
                if (!podcast.isPremium()) {
                    canAccess = true;
                } else if (userSubLevel == USER_SUBSCRIPTION_SKELETON || userSubLevel == USER_SUBSCRIPTION_AUDIO || userSubLevel == USER_SUBSCRIPTION_FULL) {
                    canAccess = true;
                } else {
                    canAccess = false;
                }
                break;
            case POD_SUB_LEVEL_SKELETON:
                if (userSubLevel == USER_SUBSCRIPTION_SKELETON || userSubLevel == USER_SUBSCRIPTION_AUDIO || userSubLevel == USER_SUBSCRIPTION_FULL) {
                    canAccess = true;
                } else {
                    canAccess = false;
                }
                break;
            case POD_SUB_LEVEL_PREMIUM:
                if (userSubLevel == USER_SUBSCRIPTION_AUDIO || userSubLevel == USER_SUBSCRIPTION_FULL) {
                    canAccess = true;
                } else {
                    canAccess = false;
                }
                break;
            default:
                break;
        }

        return canAccess;
    }

    private static boolean userCanAccessAudio(List<Subscription> userSubs) {

        if (userSubs == null) return false;

        boolean canAccess = false;

        for (int i = 0; i < userSubs.size(); i++) {

            Subscription sub = userSubs.get(i);
            if (sub.getSubscriptionAuthLevel() == USER_SUBSCRIPTION_AUDIO ||
                    sub.getSubscriptionAuthLevel() == USER_SUBSCRIPTION_SKELETON ||
                    sub.getSubscriptionAuthLevel() == USER_SUBSCRIPTION_FULL) {
                canAccess = true;
                break;
            }
        }
        return canAccess;
    }

    private static int getHighestAudioAvailable(List<Subscription> userSubs) {

        if (userSubs == null) return -1;

        int highestSub = -1;

        for (int i = 0; i < userSubs.size(); i++) {

            Subscription sub = userSubs.get(i);

            if (userSubs.size() == 1 && sub.getSubscriptionAuthLevel() == USER_SUBSCRIPTION_VIDEO) {
                break;
            } else if (sub.getSubscriptionAuthLevel() > highestSub && sub.getSubscriptionAuthLevel() != 7) {

                highestSub = sub.getSubscriptionAuthLevel();
            }
        }
        return highestSub;
    }


    public static boolean userCanAccessVideo(List<Subscription> userSubs) {
        if (userSubs == null) return false;

        boolean canAccess = false;

        for (int i = 0; i < userSubs.size(); i++) {

            Subscription sub = userSubs.get(i);
            if (sub.getSubscriptionAuthLevel() == USER_SUBSCRIPTION_VIDEO ||
                    sub.getSubscriptionAuthLevel() == USER_SUBSCRIPTION_FULL) {
                canAccess = true;
                break;
            }
        }
        return canAccess;
    }

    public static String getSubscriptionLevelAsString(List<Subscription> userSubs, Context context) {

        if (userSubs.size() == 1) {
            return getSubscriptionName(userSubs.get(0).getSubscriptionAuthLevel(), context);
        } else if (userCanAccessVideo(userSubs) && userCanAccessAudio(userSubs)) {
            return getSubscriptionName(USER_SUBSCRIPTION_FULL, context);
        } else if (userCanAccessVideo(userSubs)) {
            return getSubscriptionName(USER_SUBSCRIPTION_VIDEO, context);
        } else if (userCanAccessAudio(userSubs)) {
            return getSubscriptionName(getHighestAudioAvailable(userSubs), context);
        } else {
            //something fucked up
            return "";
        }
    }

    private static String getSubscriptionName(int authLevel, Context context) {
        switch (authLevel) {
            case USER_SUBSCRIPTION_FULL:
                return context.getString(R.string.sub_level_full);
            case USER_SUBSCRIPTION_VIDEO:
                return context.getString(R.string.sub_level_video);
            case USER_SUBSCRIPTION_SKELETON:
                return context.getString(R.string.sub_level_skeleton);
            case USER_SUBSCRIPTION_AUDIO:
                return context.getString(R.string.sub_level_audio);
            default:
                return "";
        }
    }

}
