package co.pixelbeard.theanfieldwrap.utils;

import android.text.TextUtils;
import android.util.Patterns;

/**
 * Created by Michael Stoddart
 * 10/10/2018.
 */
public class ValidationUtils {


    public static boolean isValidEmail(CharSequence target) {
        return (!TextUtils.isEmpty(target) && Patterns.EMAIL_ADDRESS.matcher(target).matches());
    }

    public static boolean isValidPassword(String password) {
        if (password == null) {
            return false;
        }
//        final String PASSWORD_PATTERN = "((?=.*[a-z])(?=.*[A-Z]).{8,})";
//        Pattern pattern = Pattern.compile(PASSWORD_PATTERN);
//        Matcher matcher = pattern.matcher(password);
        return password.length() > 7;
    }

    public static boolean isValidUsername(String username) {
        return username != null && username.length() > 0;
    }

    public static boolean isValidActivationCode(String code) {
        return code != null && code.length() == 6;
    }
}
