package co.pixelbeard.theanfieldwrap.wallet.viewholders;

import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.data.Transaction;
import co.pixelbeard.theanfieldwrap.utils.DateUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;

public class WalletCreditViewHolder extends BaseWalletViewHolder {

    @BindView(R.id.txt_credit)
    TextView txtCredit;
    @BindView(R.id.txt_purchase_date)
    TextView txtPurchaseDate;
    @BindView(R.id.txt_item_title)
    TextView txtItemTitle;

    public WalletCreditViewHolder(@NonNull View itemView) {
        super(itemView);

        ButterKnife.bind(this, itemView);

        txtCredit.setTypeface(FontUtils.getInstance().getDinProBlack());
        txtItemTitle.setTypeface(FontUtils.getInstance().getDinAlternateBold());
        txtPurchaseDate.setTypeface(FontUtils.getInstance().getDinAlternateBold());
    }


    @Override
    public void bindView(Transaction transaction) {
        super.bindView(transaction);

        txtItemTitle.setText(transaction.getIapTitle());
        txtPurchaseDate.setText(DateUtils.getDateddMMYYYY(transaction.getEntryDate()));
    }
}
