package co.pixelbeard.theanfieldwrap.wallet.viewholders;

import android.text.Html;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.google.gson.Gson;
import com.makeramen.roundedimageview.RoundedImageView;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.data.Transaction;
import co.pixelbeard.theanfieldwrap.data.Video;
import co.pixelbeard.theanfieldwrap.utils.DateUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.GlideApp;
import co.pixelbeard.theanfieldwrap.videos.OnVideoSelectedListener;

public class WalletVideoViewHolder extends BaseWalletViewHolder {

    @BindView(R.id.img_video)
    RoundedImageView imgVideo;
    @BindView(R.id.txt_video)
    TextView txtVideo;
    @BindView(R.id.txt_purchase_date)
    TextView txtPurchaseDate;
    @BindView(R.id.txt_video_title)
    TextView txtVideoTitle;

    private OnVideoSelectedListener mListener;

    public WalletVideoViewHolder(@NonNull View itemView, OnVideoSelectedListener listener) {
        super(itemView);

        ButterKnife.bind(this, itemView);

        this.mListener = listener;

        txtVideo.setTypeface(FontUtils.getInstance().getDinProBlack());
        txtVideoTitle.setTypeface(FontUtils.getInstance().getDinAlternateBold());
        txtPurchaseDate.setTypeface(FontUtils.getInstance().getDinAlternateBold());
    }

    @Override
    public void bindView(Transaction transaction) {
        super.bindView(transaction);

        Video video = new Gson().fromJson(transaction.getContentObject(), Video.class);

        if (video != null) {
            GlideApp.with(itemView.getContext()).load(video.getThumbnail()).placeholder(R.drawable.ic_placeholder_podcast_small).into(imgVideo);

            txtVideoTitle.setText(Html.fromHtml(video.getTitle()));
            txtPurchaseDate.setText(DateUtils.getDateddMMYYYY(transaction.getEntryDate()));

            itemView.setOnClickListener(v -> mListener.onVideoSelected(video));
        }
    }
}
