package co.pixelbeard.theanfieldwrap.data;

import com.google.gson.annotations.SerializedName;

import org.parceler.Parcel;

@Parcel(Parcel.Serialization.BEAN)
public class Device {

    @SerializedName("id")
    int id;
    @SerializedName("user_id")
    Long userId;
    @SerializedName("partner_id")
    int partnerId;
    @SerializedName("user_auth_token")
    String userAuthToken;
    @SerializedName("active")
    int active;
    @SerializedName("user_agent")
    String userAgent;
    @SerializedName("host")
    String host;
    @SerializedName("unique_device_identifier")
    String uniqueDeviceId;
    @SerializedName("unique_device_name")
    String deviceName;
    @SerializedName("last_logged_in")
    String lastLoggedIn;

    public Device() {
    }

    public Device(int id, Long userId, int partnerId, String userAuthToken, int active, String userAgent, String host, String uniqueDeviceId, String deviceName, String lastLoggedIn) {
        this.id = id;
        this.userId = userId;
        this.partnerId = partnerId;
        this.userAuthToken = userAuthToken;
        this.active = active;
        this.userAgent = userAgent;
        this.host = host;
        this.uniqueDeviceId = uniqueDeviceId;
        this.deviceName = deviceName;
        this.lastLoggedIn = lastLoggedIn;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public int getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(int partnerId) {
        this.partnerId = partnerId;
    }

    public String getUserAuthToken() {
        return userAuthToken;
    }

    public void setUserAuthToken(String userAuthToken) {
        this.userAuthToken = userAuthToken;
    }

    public int getActive() {
        return active;
    }

    public void setActive(int active) {
        this.active = active;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUniqueDeviceId() {
        return uniqueDeviceId;
    }

    public void setUniqueDeviceId(String uniqueDeviceId) {
        this.uniqueDeviceId = uniqueDeviceId;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getLastLoggedIn() {
        return lastLoggedIn;
    }

    public void setLastLoggedIn(String lastLoggedIn) {
        this.lastLoggedIn = lastLoggedIn;
    }
}
