package co.pixelbeard.theanfieldwrap.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.Html;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.ScreenUtils;

public class SingleButtonDialog extends Dialog {

    @BindView(R.id.txt_dialog_title)
    TextView txtDialogTitle;
    @BindView(R.id.txt_dialog_description)
    TextView txtDialogDescription;
    @BindView(R.id.btn_ok)
    Button btnOk;

    private String mTitle, mBody, mButtonText;
    private Context mContext;

    public SingleButtonDialog(String title, String body, String buttonText, @NonNull Context context) {
        super(context);


        this.mTitle = title;
        this.mBody = body;
        this.mContext = context;
        this.mButtonText = buttonText;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        Window window = getWindow();

        if (window != null) {
            window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
            window.getAttributes().windowAnimations = R.style.TAWDialogAnimationStyle;
        }

        setContentView(R.layout.dialog_single_button);
        ButterKnife.bind(this);

        WindowManager manager = (WindowManager) mContext.getSystemService(Activity.WINDOW_SERVICE);
        int width, height;

        Point point = new Point();
        manager.getDefaultDisplay().getSize(point);
        width = point.x;
        height = point.y;

        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(this.getWindow().getAttributes());
        lp.width = width;
        lp.height = (int) (height - ScreenUtils.dpToPx(30, mContext));
        this.getWindow().setAttributes(lp);

        this.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));


        setupTextViews();
        setupButtons();
    }

    private void setupTextViews() {
        txtDialogTitle.setTypeface(FontUtils.getInstance().getDinProBlack());
        txtDialogDescription.setTypeface(FontUtils.getInstance().getArialReg());


        txtDialogTitle.setText(Html.fromHtml(mTitle));
        txtDialogDescription.setText(Html.fromHtml(mBody));
    }

    private void setupButtons() {
        btnOk.setTypeface(FontUtils.getInstance().getDinAlternateBold());

        if (mButtonText != null) {
            btnOk.setText(mButtonText);
        }
        btnOk.setOnClickListener(v -> {
            dismiss();
        });
    }


    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }
}
