package co.pixelbeard.theanfieldwrap.editEmail;

import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface EditEmailContract {

    interface View extends BaseView<Presenter> {

        void showEmailError(String message);

        void showInvalidEmailError();

        void enableButton();

        void disableButton();

        void showEmailNotAvailableError();

        void setEmailAvailable(boolean isEmailAvailable);
    }

    interface Presenter extends BasePresenter {
        boolean validateEmail(String email, boolean shouldShowError);

        void updateEmail(String email);

        void checkEmailAvailable(String email);

        boolean checkForChanges(String newEmail);
    }
}